/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.tool;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.CompositeFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.tool.AbstractTool;
import org.jhotdraw.util.ResourceBundleUtil;

public class CreationTool
extends AbstractTool {
    @Nullable
    protected Map<AttributeKey, Object> prototypeAttributes;
    @Nullable
    protected String presentationName;
    protected Dimension minimalSizeTreshold = new Dimension(2, 2);
    protected Dimension minimalSize = new Dimension(40, 40);
    protected Figure prototype;
    @Nullable
    protected Figure createdFigure;
    private boolean isToolDoneAfterCreation = true;

    public CreationTool(String prototypeClassName) {
        this(prototypeClassName, null, null);
    }

    public CreationTool(String prototypeClassName, @Nullable Map<AttributeKey, Object> attributes) {
        this(prototypeClassName, attributes, null);
    }

    public CreationTool(String prototypeClassName, @Nullable Map<AttributeKey, Object> attributes, @Nullable String name) {
        try {
            this.prototype = (Figure)Class.forName(prototypeClassName).newInstance();
        }
        catch (Exception e) {
            InternalError error = new InternalError("Unable to create Figure from " + prototypeClassName);
            error.initCause(e);
            throw error;
        }
        this.prototypeAttributes = attributes;
        if (name == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            name = labels.getString("edit.createFigure.text");
        }
        this.presentationName = name;
    }

    public CreationTool(Figure prototype) {
        this(prototype, null, null);
    }

    public CreationTool(Figure prototype, @Nullable Map<AttributeKey, Object> attributes) {
        this(prototype, attributes, null);
    }

    public CreationTool(Figure prototype, @Nullable Map<AttributeKey, Object> attributes, @Nullable String name) {
        this.prototype = prototype;
        this.prototypeAttributes = attributes;
        if (name == null) {
            ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            name = labels.getString("edit.createFigure.text");
        }
        this.presentationName = name;
    }

    public Figure getPrototype() {
        return this.prototype;
    }

    @Override
    public void activate(DrawingEditor editor) {
        super.activate(editor);
        this.getView().setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void deactivate(DrawingEditor editor) {
        super.deactivate(editor);
        if (this.getView() != null) {
            this.getView().setCursor(Cursor.getDefaultCursor());
        }
        if (this.createdFigure != null) {
            if (this.createdFigure instanceof CompositeFigure) {
                ((CompositeFigure)this.createdFigure).layout();
            }
            this.createdFigure = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        super.mousePressed(evt);
        this.getView().clearSelection();
        this.createdFigure = this.createFigure();
        Point2D.Double p = this.constrainPoint(this.viewToDrawing(this.anchor));
        this.anchor.x = evt.getX();
        this.anchor.y = evt.getY();
        this.createdFigure.setBounds(p, p);
        this.getDrawing().add(this.createdFigure);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.createdFigure != null) {
            Point2D.Double p = this.constrainPoint(new Point(evt.getX(), evt.getY()));
            this.createdFigure.willChange();
            this.createdFigure.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), p);
            this.createdFigure.changed();
        }
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (this.createdFigure != null) {
            Rectangle2D.Double bounds = this.createdFigure.getBounds();
            if (bounds.width == 0.0 && bounds.height == 0.0) {
                this.getDrawing().remove(this.createdFigure);
                if (this.isToolDoneAfterCreation()) {
                    this.fireToolDone();
                }
            } else {
                if (Math.abs(this.anchor.x - evt.getX()) < this.minimalSizeTreshold.width && Math.abs(this.anchor.y - evt.getY()) < this.minimalSizeTreshold.height) {
                    this.createdFigure.willChange();
                    this.createdFigure.setBounds(this.constrainPoint(new Point(this.anchor.x, this.anchor.y)), this.constrainPoint(new Point(this.anchor.x + (int)Math.max(bounds.width, (double)this.minimalSize.width), this.anchor.y + (int)Math.max(bounds.height, (double)this.minimalSize.height))));
                    this.createdFigure.changed();
                }
                if (this.createdFigure instanceof CompositeFigure) {
                    ((CompositeFigure)this.createdFigure).layout();
                }
                final Figure addedFigure = this.createdFigure;
                final Drawing addedDrawing = this.getDrawing();
                this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

                    @Override
                    public String getPresentationName() {
                        return CreationTool.this.presentationName;
                    }

                    @Override
                    public void undo() throws CannotUndoException {
                        super.undo();
                        addedDrawing.remove(addedFigure);
                    }

                    @Override
                    public void redo() throws CannotRedoException {
                        super.redo();
                        addedDrawing.add(addedFigure);
                    }
                });
                Rectangle r = new Rectangle(this.anchor.x, this.anchor.y, 0, 0);
                r.add(evt.getX(), evt.getY());
                this.maybeFireBoundsInvalidated(r);
                this.creationFinished(this.createdFigure);
                this.createdFigure = null;
            }
        } else if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    protected Figure createFigure() {
        Figure f = this.prototype.clone();
        this.getEditor().applyDefaultAttributesTo(f);
        if (this.prototypeAttributes != null) {
            for (Map.Entry<AttributeKey, Object> entry : this.prototypeAttributes.entrySet()) {
                f.set(entry.getKey(), entry.getValue());
            }
        }
        return f;
    }

    protected Figure getCreatedFigure() {
        return this.createdFigure;
    }

    protected Figure getAddedFigure() {
        return this.createdFigure;
    }

    protected void creationFinished(Figure createdFigure) {
        if (createdFigure.isSelectable()) {
            this.getView().addToSelection(createdFigure);
        }
        if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    public void setToolDoneAfterCreation(boolean newValue) {
        boolean oldValue = this.isToolDoneAfterCreation;
        this.isToolDoneAfterCreation = newValue;
    }

    public boolean isToolDoneAfterCreation() {
        return this.isToolDoneAfterCreation;
    }

    @Override
    public void updateCursor(DrawingView view, Point p) {
        if (view.isEnabled()) {
            view.setCursor(Cursor.getPredefinedCursor(1));
        } else {
            view.setCursor(Cursor.getPredefinedCursor(3));
        }
    }
}

