/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Constrainer;
import org.jhotdraw.draw.DefaultDrawingViewTransferHandler;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.GridConstrainer;
import org.jhotdraw.draw.event.CompositeFigureEvent;
import org.jhotdraw.draw.event.CompositeFigureListener;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.event.FigureListener;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.jhotdraw.draw.event.FigureSelectionListener;
import org.jhotdraw.draw.event.HandleEvent;
import org.jhotdraw.draw.event.HandleListener;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.gui.EditableComponent;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.ReversedList;

public class DefaultDrawingView
extends JComponent
implements DrawingView,
EditableComponent {
    private static final boolean DEBUG = false;
    @Nullable
    private Drawing drawing;
    private Set<Figure> selectedFigures = new LinkedHashSet<Figure>();
    private LinkedList<Handle> selectionHandles = new LinkedList();
    private boolean isConstrainerVisible = false;
    private Constrainer visibleConstrainer = new GridConstrainer(8.0, 8.0);
    private Constrainer invisibleConstrainer = new GridConstrainer();
    private Handle secondaryHandleOwner;
    @Nullable
    private Handle activeHandle;
    private LinkedList<Handle> secondaryHandles = new LinkedList();
    private boolean handlesAreValid = true;
    @Nullable
    private transient Dimension cachedPreferredSize;
    private double scaleFactor = 1.0;
    private Point translation = new Point(0, 0);
    private int detailLevel;
    @Nullable
    private DrawingEditor editor;
    private JLabel emptyDrawingLabel;
    protected BufferedImage backgroundTile;
    private FigureListener handleInvalidator = new FigureAdapter(){

        @Override
        public void figureHandlesChanged(FigureEvent e) {
            DefaultDrawingView.this.invalidateHandles();
        }
    };
    @Nullable
    private transient Rectangle2D.Double cachedDrawingArea;
    public static final String DRAWING_DOUBLE_BUFFERED_PROPERTY = "drawingDoubleBuffered";
    private boolean isDrawingDoubleBuffered = true;
    @Nullable
    private VolatileImage drawingBufferV;
    @Nullable
    private BufferedImage drawingBufferNV;
    private Rectangle bufferedArea = new Rectangle();
    private Rectangle dirtyArea = new Rectangle(0, 0, -1, -1);
    private boolean paintEnabled = true;
    private static final boolean isWindows;
    private EventHandler eventHandler;

    @Override
    public void repaintHandles() {
        this.validateHandles();
        Rectangle r = null;
        for (Handle h : this.getSelectionHandles()) {
            if (r == null) {
                r = h.getDrawingArea();
                continue;
            }
            r.add(h.getDrawingArea());
        }
        for (Handle h : this.getSecondaryHandles()) {
            if (r == null) {
                r = h.getDrawingArea();
                continue;
            }
            r.add(h.getDrawingArea());
        }
        if (r != null) {
            this.repaint(r);
        }
    }

    protected void drawBackground(Graphics2D g) {
        if (this.drawing == null) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else if (this.drawing.get(AttributeKeys.CANVAS_WIDTH) == null || this.drawing.get(AttributeKeys.CANVAS_HEIGHT) == null) {
            Color canvasColor = this.drawing.get(AttributeKeys.CANVAS_FILL_COLOR);
            double canvasOpacity = this.drawing.get(AttributeKeys.CANVAS_FILL_OPACITY);
            if (canvasColor != null) {
                if (canvasOpacity == 1.0) {
                    g.setColor(new Color(canvasColor.getRGB()));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    Point r = this.drawingToView(new Point2D.Double(0.0, 0.0));
                    g.setPaint(this.getBackgroundPaint(r.x, r.y));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    g.setColor(new Color(canvasColor.getRGB() & 0xFFFFF | (int)(canvasOpacity * 256.0) << 24, true));
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            } else {
                Point r = this.drawingToView(new Point2D.Double(0.0, 0.0));
                g.setPaint(this.getBackgroundPaint(r.x, r.y));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        } else {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Rectangle r = this.drawingToView(new Rectangle2D.Double(0.0, 0.0, this.drawing.get(AttributeKeys.CANVAS_WIDTH), this.drawing.get(AttributeKeys.CANVAS_HEIGHT)));
            g.setPaint(this.getBackgroundPaint(r.x, r.y));
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selectedFigures.isEmpty();
    }

    public DefaultDrawingView() {
        this.initComponents();
        this.eventHandler = this.createEventHandler();
        this.setToolTipText("dummy");
        this.setFocusable(true);
        this.addFocusListener(this.eventHandler);
        this.setTransferHandler(new DefaultDrawingViewTransferHandler());
        this.setBackground(new Color(0xB0B0B0));
        this.setOpaque(true);
    }

    protected EventHandler createEventHandler() {
        return new EventHandler();
    }

    private void initComponents() {
        this.setLayout(null);
    }

    @Override
    @Nullable
    public Drawing getDrawing() {
        return this.drawing;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        if (this.getEditor() != null && this.getEditor().getTool() != null) {
            return this.getEditor().getTool().getToolTipText(this, evt);
        }
        return null;
    }

    public void setEmptyDrawingMessage(String newValue) {
        String oldValue;
        String string = oldValue = this.emptyDrawingLabel == null ? null : this.emptyDrawingLabel.getText();
        if (newValue == null) {
            this.emptyDrawingLabel = null;
        } else {
            this.emptyDrawingLabel = new JLabel(newValue);
            this.emptyDrawingLabel.setHorizontalAlignment(0);
        }
        this.firePropertyChange("emptyDrawingMessage", oldValue, newValue);
        this.repaint();
    }

    public String getEmptyDrawingMessage() {
        return this.emptyDrawingLabel == null ? null : this.emptyDrawingLabel.getText();
    }

    @Override
    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        this.setViewRenderingHints(g);
        this.drawBackground(g);
        this.drawCanvas(g);
        this.drawConstrainer(g);
        if (this.isDrawingDoubleBuffered()) {
            if (isWindows) {
                this.drawDrawingNonvolatileBuffered(g);
            } else {
                this.drawDrawingVolatileBuffered(g);
            }
        } else {
            this.drawDrawing(g);
        }
        this.drawHandles(g);
        this.drawTool(g);
    }

    protected void drawDrawingVolatileBuffered(Graphics2D g) {
        block20: {
            Rectangle vr = this.getVisibleRect();
            Point shift = new Point(0, 0);
            if (this.bufferedArea.contains(vr) || this.bufferedArea.width >= vr.width && this.bufferedArea.height >= vr.height) {
                shift.x = this.bufferedArea.x - vr.x;
                shift.y = this.bufferedArea.y - vr.y;
                if (shift.x > 0) {
                    this.dirtyArea.add(new Rectangle(this.bufferedArea.x - shift.x, vr.y, shift.x + this.bufferedArea.width - vr.width, this.bufferedArea.height));
                } else if (shift.x < 0) {
                    this.dirtyArea.add(new Rectangle(this.bufferedArea.x + vr.width, vr.y, -shift.x + this.bufferedArea.width - vr.width, this.bufferedArea.height));
                }
                if (shift.y > 0) {
                    this.dirtyArea.add(new Rectangle(vr.x, this.bufferedArea.y - shift.y, this.bufferedArea.width, shift.y + this.bufferedArea.height - vr.height));
                } else if (shift.y < 0) {
                    this.dirtyArea.add(new Rectangle(vr.x, this.bufferedArea.y + vr.height, this.bufferedArea.width, -shift.y + this.bufferedArea.height - vr.height));
                }
                this.bufferedArea.x = vr.x;
                this.bufferedArea.y = vr.y;
            } else {
                this.bufferedArea.setBounds(vr);
                this.dirtyArea.setBounds(vr);
                if (this.drawingBufferV != null && (this.drawingBufferV.getWidth() != vr.width || this.drawingBufferV.getHeight() != vr.height)) {
                    this.drawingBufferV.flush();
                    this.drawingBufferV = null;
                }
            }
            while (true) {
                int valid = this.drawingBufferV == null ? 2 : this.drawingBufferV.validate(this.getGraphicsConfiguration());
                switch (valid) {
                    case 2: {
                        try {
                            this.drawingBufferV = this.getGraphicsConfiguration().createCompatibleVolatileImage(vr.width, vr.height, 3);
                        }
                        catch (OutOfMemoryError e) {
                            this.drawingBufferV = null;
                        }
                        this.dirtyArea.setBounds(this.bufferedArea);
                        break;
                    }
                    case 1: {
                        this.dirtyArea.setBounds(this.bufferedArea);
                    }
                }
                if (this.drawingBufferV == null) {
                    this.drawDrawing(g);
                    break block20;
                }
                if (!this.dirtyArea.isEmpty()) {
                    Graphics2D gBuf = this.drawingBufferV.createGraphics();
                    this.setViewRenderingHints(gBuf);
                    gBuf.setComposite(AlphaComposite.Src);
                    if (shift.x != 0 || shift.y != 0) {
                        gBuf.copyArea(Math.max(0, -shift.x), Math.max(0, -shift.y), this.drawingBufferV.getWidth() - Math.abs(shift.x), this.drawingBufferV.getHeight() - Math.abs(shift.y), shift.x, shift.y);
                        shift.y = 0;
                        shift.x = 0;
                    }
                    gBuf.translate(-this.bufferedArea.x, -this.bufferedArea.y);
                    gBuf.clip(this.dirtyArea);
                    gBuf.setBackground(new Color(0, true));
                    gBuf.clearRect(this.dirtyArea.x, this.dirtyArea.y, this.dirtyArea.width, this.dirtyArea.height);
                    gBuf.setComposite(AlphaComposite.SrcOver);
                    this.drawDrawing(gBuf);
                    gBuf.dispose();
                }
                if (!this.drawingBufferV.contentsLost()) {
                    g.drawImage(this.drawingBufferV, this.bufferedArea.x, this.bufferedArea.y, null);
                }
                if (!this.drawingBufferV.contentsLost()) break;
                this.dirtyArea.setBounds(this.bufferedArea);
            }
            this.dirtyArea.setSize(-1, -1);
        }
    }

    protected void drawDrawingNonvolatileBuffered(Graphics2D g) {
        Rectangle vr = this.getVisibleRect();
        Point shift = new Point(0, 0);
        if (this.bufferedArea.contains(vr) || this.bufferedArea.width >= vr.width && this.bufferedArea.height >= vr.height) {
            shift.x = this.bufferedArea.x - vr.x;
            shift.y = this.bufferedArea.y - vr.y;
            if (shift.x > 0) {
                this.dirtyArea.add(new Rectangle(this.bufferedArea.x - shift.x, vr.y, shift.x + this.bufferedArea.width - vr.width, this.bufferedArea.height));
            } else if (shift.x < 0) {
                this.dirtyArea.add(new Rectangle(this.bufferedArea.x + vr.width, vr.y, -shift.x + this.bufferedArea.width - vr.width, this.bufferedArea.height));
            }
            if (shift.y > 0) {
                this.dirtyArea.add(new Rectangle(vr.x, this.bufferedArea.y - shift.y, this.bufferedArea.width, shift.y + this.bufferedArea.height - vr.height));
            } else if (shift.y < 0) {
                this.dirtyArea.add(new Rectangle(vr.x, this.bufferedArea.y + vr.height, this.bufferedArea.width, -shift.y + this.bufferedArea.height - vr.height));
            }
            this.bufferedArea.x = vr.x;
            this.bufferedArea.y = vr.y;
        } else {
            this.bufferedArea.setBounds(vr);
            this.dirtyArea.setBounds(vr);
            if (this.drawingBufferNV != null && (this.drawingBufferNV.getWidth() != vr.width || this.drawingBufferNV.getHeight() != vr.height)) {
                this.drawingBufferNV.flush();
                this.drawingBufferNV = null;
            }
        }
        int valid = this.drawingBufferNV == null ? 2 : 0;
        switch (valid) {
            case 2: {
                try {
                    this.drawingBufferNV = this.getGraphicsConfiguration().createCompatibleImage(vr.width, vr.height, 3);
                }
                catch (OutOfMemoryError e) {
                    this.drawingBufferNV = null;
                }
                this.dirtyArea.setBounds(this.bufferedArea);
            }
        }
        if (this.drawingBufferNV == null) {
            this.drawDrawing(g);
            return;
        }
        if (!this.dirtyArea.isEmpty()) {
            Graphics2D gBuf = this.drawingBufferNV.createGraphics();
            this.setViewRenderingHints(gBuf);
            gBuf.setComposite(AlphaComposite.Src);
            if (shift.x != 0 || shift.y != 0) {
                gBuf.copyArea(Math.max(0, -shift.x), Math.max(0, -shift.y), this.drawingBufferNV.getWidth() - Math.abs(shift.x), this.drawingBufferNV.getHeight() - Math.abs(shift.y), shift.x, shift.y);
                shift.y = 0;
                shift.x = 0;
            }
            gBuf.translate(-this.bufferedArea.x, -this.bufferedArea.y);
            gBuf.clip(this.dirtyArea);
            gBuf.setBackground(new Color(0, true));
            gBuf.clearRect(this.dirtyArea.x, this.dirtyArea.y, this.dirtyArea.width, this.dirtyArea.height);
            gBuf.setComposite(AlphaComposite.SrcOver);
            this.drawDrawing(gBuf);
            gBuf.dispose();
        }
        g.drawImage((Image)this.drawingBufferNV, this.bufferedArea.x, this.bufferedArea.y, null);
        this.dirtyArea.setSize(-1, -1);
    }

    @Override
    public void printComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.drawDrawing(g);
    }

    protected void setViewRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    protected Rectangle getCanvasViewBounds() {
        int x = -this.translation.x;
        int y = -this.translation.y;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.getDrawing() != null) {
            Double cw = this.getDrawing().get(AttributeKeys.CANVAS_WIDTH);
            Double ch = this.getDrawing().get(AttributeKeys.CANVAS_HEIGHT);
            if (cw != null && ch != null) {
                Point lowerRight = this.drawingToView(new Point2D.Double(cw, ch));
                w = lowerRight.x - x;
                h = lowerRight.y - y;
            }
        }
        return new Rectangle(x, y, w, h);
    }

    protected void drawCanvas(Graphics2D gr) {
        if (this.drawing != null) {
            Graphics2D g = (Graphics2D)gr.create();
            AffineTransform tx = g.getTransform();
            tx.translate(-this.translation.x, -this.translation.y);
            tx.scale(this.scaleFactor, this.scaleFactor);
            g.setTransform(tx);
            this.drawing.setFontRenderContext(g.getFontRenderContext());
            this.drawing.drawCanvas(g);
            g.dispose();
        }
    }

    protected void drawConstrainer(Graphics2D g) {
        Shape clip = g.getClip();
        Rectangle r = this.getCanvasViewBounds();
        g.clipRect(r.x, r.y, r.width, r.height);
        this.getConstrainer().draw(g, this);
        g.setClip(clip);
    }

    protected void drawDrawing(Graphics2D gr) {
        if (this.drawing != null) {
            if (this.drawing.getChildCount() == 0 && this.emptyDrawingLabel != null) {
                this.emptyDrawingLabel.setBounds(0, 0, this.getWidth(), this.getHeight());
                this.emptyDrawingLabel.paint(gr);
            } else {
                Graphics2D g = (Graphics2D)gr.create();
                AffineTransform tx = g.getTransform();
                tx.translate(-this.translation.x, -this.translation.y);
                tx.scale(this.scaleFactor, this.scaleFactor);
                g.setTransform(tx);
                this.drawing.setFontRenderContext(g.getFontRenderContext());
                this.drawing.draw(g);
                g.dispose();
            }
        }
    }

    protected void drawHandles(Graphics2D g) {
        if (this.editor != null && this.editor.getActiveView() == this) {
            this.validateHandles();
            for (Handle h : this.getSelectionHandles()) {
                h.draw(g);
            }
            for (Handle h : this.getSecondaryHandles()) {
                h.draw(g);
            }
        }
    }

    protected void drawTool(Graphics2D g) {
        if (this.editor != null && this.editor.getActiveView() == this && this.editor.getTool() != null) {
            this.editor.getTool().draw(g);
        }
    }

    @Override
    public void setDrawing(@Nullable Drawing newValue) {
        Drawing oldValue = this.drawing;
        if (this.drawing != null) {
            this.drawing.removeCompositeFigureListener(this.eventHandler);
            this.drawing.removeFigureListener(this.eventHandler);
            this.clearSelection();
        }
        this.drawing = newValue;
        if (this.drawing != null) {
            this.drawing.addCompositeFigureListener(this.eventHandler);
            this.drawing.addFigureListener(this.eventHandler);
        }
        this.dirtyArea.add(this.bufferedArea);
        this.firePropertyChange("drawing", oldValue, newValue);
        this.revalidate();
        this.validateViewTranslation();
        this.paintEnabled = false;
        Timer t = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultDrawingView.this.repaint();
                DefaultDrawingView.this.paintEnabled = true;
            }
        });
        t.setRepeats(false);
        t.start();
    }

    @Override
    public void paint(Graphics g) {
        if (this.paintEnabled) {
            super.paint(g);
        }
    }

    protected void repaintDrawingArea(Rectangle2D.Double r) {
        Rectangle vr = this.drawingToView(r);
        vr.grow(1, 1);
        this.dirtyArea.add(vr);
        this.repaint(vr);
    }

    @Override
    public void invalidate() {
        this.invalidateDimension();
        super.invalidate();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.drawingBufferNV != null) {
            this.drawingBufferNV.flush();
            this.drawingBufferNV = null;
        }
        if (this.drawingBufferV != null) {
            this.drawingBufferV.flush();
            this.drawingBufferV = null;
        }
    }

    @Override
    public void addToSelection(Figure figure) {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        if (this.selectedFigures.add(figure)) {
            figure.addFigureListener(this.handleInvalidator);
            HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
            Rectangle invalidatedArea = null;
            if (this.handlesAreValid && this.getEditor() != null) {
                for (Handle h : figure.createHandles(this.detailLevel)) {
                    h.setView(this);
                    this.selectionHandles.add(h);
                    h.addHandleListener(this.eventHandler);
                    if (invalidatedArea == null) {
                        invalidatedArea = h.getDrawingArea();
                        continue;
                    }
                    invalidatedArea.add(h.getDrawingArea());
                }
            }
            this.fireSelectionChanged(oldSelection, newSelection);
            if (invalidatedArea != null) {
                this.repaint(invalidatedArea);
            }
        }
    }

    @Override
    public void addToSelection(Collection<Figure> figures) {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
        boolean selectionChanged = false;
        Rectangle invalidatedArea = null;
        for (Figure figure : figures) {
            if (!this.selectedFigures.add(figure)) continue;
            selectionChanged = true;
            newSelection.add(figure);
            figure.addFigureListener(this.handleInvalidator);
            if (!this.handlesAreValid || this.getEditor() == null) continue;
            for (Handle h : figure.createHandles(this.detailLevel)) {
                h.setView(this);
                this.selectionHandles.add(h);
                h.addHandleListener(this.eventHandler);
                if (invalidatedArea == null) {
                    invalidatedArea = h.getDrawingArea();
                    continue;
                }
                invalidatedArea.add(h.getDrawingArea());
            }
        }
        if (selectionChanged) {
            this.fireSelectionChanged(oldSelection, newSelection);
            if (invalidatedArea != null) {
                this.repaint(invalidatedArea);
            }
        }
    }

    @Override
    public void removeFromSelection(Figure figure) {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        if (this.selectedFigures.remove(figure)) {
            HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
            this.invalidateHandles();
            figure.removeFigureListener(this.handleInvalidator);
            this.fireSelectionChanged(oldSelection, newSelection);
            this.repaint();
        }
    }

    @Override
    public void toggleSelection(Figure figure) {
        if (this.selectedFigures.contains(figure)) {
            this.removeFromSelection(figure);
        } else {
            this.addToSelection(figure);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setCursor(Cursor.getPredefinedCursor(b ? 0 : 3));
    }

    @Override
    public void selectAll() {
        HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
        this.selectedFigures.clear();
        for (Figure figure : this.drawing.getChildren()) {
            if (!figure.isSelectable()) continue;
            this.selectedFigures.add(figure);
        }
        HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
        this.invalidateHandles();
        this.fireSelectionChanged(oldSelection, newSelection);
        this.repaint();
    }

    @Override
    public void clearSelection() {
        if (this.getSelectionCount() > 0) {
            HashSet<Figure> oldSelection = new HashSet<Figure>(this.selectedFigures);
            this.selectedFigures.clear();
            HashSet<Figure> newSelection = new HashSet<Figure>(this.selectedFigures);
            this.invalidateHandles();
            this.fireSelectionChanged(oldSelection, newSelection);
        }
    }

    @Override
    public boolean isFigureSelected(Figure checkFigure) {
        return this.selectedFigures.contains(checkFigure);
    }

    @Override
    public Set<Figure> getSelectedFigures() {
        return Collections.unmodifiableSet(this.selectedFigures);
    }

    @Override
    public int getSelectionCount() {
        return this.selectedFigures.size();
    }

    private List<Handle> getSelectionHandles() {
        this.validateHandles();
        return Collections.unmodifiableList(this.selectionHandles);
    }

    private List<Handle> getSecondaryHandles() {
        this.validateHandles();
        return Collections.unmodifiableList(this.secondaryHandles);
    }

    private void invalidateHandles() {
        if (this.handlesAreValid) {
            this.handlesAreValid = false;
            Rectangle invalidatedArea = null;
            for (Handle handle : this.selectionHandles) {
                handle.removeHandleListener(this.eventHandler);
                if (invalidatedArea == null) {
                    invalidatedArea = handle.getDrawingArea();
                } else {
                    invalidatedArea.add(handle.getDrawingArea());
                }
                handle.dispose();
            }
            for (Handle handle : this.secondaryHandles) {
                handle.removeHandleListener(this.eventHandler);
                if (invalidatedArea == null) {
                    invalidatedArea = handle.getDrawingArea();
                } else {
                    invalidatedArea.add(handle.getDrawingArea());
                }
                handle.dispose();
            }
            this.selectionHandles.clear();
            this.secondaryHandles.clear();
            this.setActiveHandle(null);
            if (invalidatedArea != null) {
                this.repaint(invalidatedArea);
            }
        }
    }

    private void validateHandles() {
        if (!this.handlesAreValid && this.getEditor() != null) {
            this.handlesAreValid = true;
            this.selectionHandles.clear();
            Rectangle invalidatedArea = null;
            while (true) {
                for (Figure figure : this.getSelectedFigures()) {
                    for (Handle handle : figure.createHandles(this.detailLevel)) {
                        handle.setView(this);
                        this.selectionHandles.add(handle);
                        handle.addHandleListener(this.eventHandler);
                        if (invalidatedArea == null) {
                            invalidatedArea = handle.getDrawingArea();
                            continue;
                        }
                        invalidatedArea.add(handle.getDrawingArea());
                    }
                }
                if (this.selectionHandles.size() != 0 || this.detailLevel == 0) break;
                this.detailLevel = 0;
            }
            if (invalidatedArea != null) {
                this.repaint(invalidatedArea);
            }
        }
    }

    @Override
    public Handle findHandle(Point p) {
        this.validateHandles();
        for (Handle handle : new ReversedList<Handle>(this.getSecondaryHandles())) {
            if (!handle.contains(p)) continue;
            return handle;
        }
        for (Handle handle : new ReversedList<Handle>(this.getSelectionHandles())) {
            if (!handle.contains(p)) continue;
            return handle;
        }
        return null;
    }

    @Override
    public Collection<Handle> getCompatibleHandles(Handle master) {
        this.validateHandles();
        HashSet<Figure> owners = new HashSet<Figure>();
        LinkedList<Handle> compatibleHandles = new LinkedList<Handle>();
        owners.add(master.getOwner());
        compatibleHandles.add(master);
        for (Handle handle : this.getSelectionHandles()) {
            if (owners.contains(handle.getOwner()) || !handle.isCombinableWith(master)) continue;
            owners.add(handle.getOwner());
            compatibleHandles.add(handle);
        }
        return compatibleHandles;
    }

    @Override
    public Figure findFigure(Point p) {
        return this.getDrawing().findFigure(this.viewToDrawing(p));
    }

    @Override
    public Collection<Figure> findFigures(Rectangle r) {
        return this.getDrawing().findFigures(this.viewToDrawing(r));
    }

    @Override
    public Collection<Figure> findFiguresWithin(Rectangle r) {
        return this.getDrawing().findFiguresWithin(this.viewToDrawing(r));
    }

    @Override
    public void addFigureSelectionListener(FigureSelectionListener fsl) {
        this.listenerList.add(FigureSelectionListener.class, fsl);
    }

    @Override
    public void removeFigureSelectionListener(FigureSelectionListener fsl) {
        this.listenerList.remove(FigureSelectionListener.class, fsl);
    }

    protected void fireSelectionChanged(Set<Figure> oldValue, Set<Figure> newValue) {
        if (this.listenerList.getListenerCount() > 0) {
            FigureSelectionEvent event = null;
            Object[] listeners = this.listenerList.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != FigureSelectionListener.class) continue;
                if (event == null) {
                    event = new FigureSelectionEvent(this, oldValue, newValue);
                }
                ((FigureSelectionListener)listeners[i + 1]).selectionChanged(event);
            }
        }
        this.firePropertyChange("selectionEmpty", oldValue.isEmpty(), newValue.isEmpty());
    }

    protected void invalidateDimension() {
        this.cachedPreferredSize = null;
        this.cachedDrawingArea = null;
    }

    @Override
    public Constrainer getConstrainer() {
        return this.isConstrainerVisible() ? this.visibleConstrainer : this.invisibleConstrainer;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.cachedPreferredSize == null) {
            Rectangle2D.Double r = this.getDrawingArea();
            Double cw = this.getDrawing() == null ? null : this.getDrawing().get(AttributeKeys.CANVAS_WIDTH);
            Double ch = this.getDrawing() == null ? null : this.getDrawing().get(AttributeKeys.CANVAS_HEIGHT);
            Insets insets = this.getInsets();
            this.cachedPreferredSize = cw == null || ch == null ? new Dimension((int)Math.ceil((Math.max(0.0, r.x) + r.width) * this.scaleFactor) + insets.left + insets.right, (int)Math.ceil((Math.max(0.0, r.y) + r.height) * this.scaleFactor) + insets.top + insets.bottom) : new Dimension((int)Math.ceil((-Math.min(0.0, r.x) + Math.max(Math.max(0.0, r.x) + r.width + Math.min(0.0, r.x), cw)) * this.scaleFactor) + insets.left + insets.right, (int)Math.ceil((-Math.min(0.0, r.y) + Math.max(Math.max(0.0, r.y) + r.height + Math.min(0.0, r.y), ch)) * this.scaleFactor) + insets.top + insets.bottom);
        }
        return (Dimension)this.cachedPreferredSize.clone();
    }

    protected Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            this.cachedDrawingArea = this.drawing != null ? this.drawing.getDrawingArea() : new Rectangle2D.Double();
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.validateViewTranslation();
    }

    private void validateViewTranslation() {
        if (this.getDrawing() == null) {
            this.translation.y = 0;
            this.translation.x = 0;
            return;
        }
        Point oldTranslation = (Point)this.translation.clone();
        int width = this.getWidth();
        int height = this.getHeight();
        Insets insets = this.getInsets();
        Rectangle2D.Double da = this.getDrawingArea();
        Rectangle r = new Rectangle((int)(da.x * this.scaleFactor), (int)(da.y * this.scaleFactor), (int)(da.width * this.scaleFactor), (int)(da.height * this.scaleFactor));
        Double cwd = this.getDrawing().get(AttributeKeys.CANVAS_WIDTH);
        Double chd = this.getDrawing().get(AttributeKeys.CANVAS_HEIGHT);
        if (cwd == null || chd == null) {
            this.translation.x = insets.top;
            this.translation.y = insets.left;
        } else {
            int cw = (int)(cwd * this.scaleFactor);
            int ch = (int)(chd * this.scaleFactor);
            if (cw < width) {
                this.translation.x = insets.left + (width - insets.left - insets.right - cw) / -2;
            }
            if (ch < height) {
                this.translation.y = insets.top + (height - insets.top - insets.bottom - ch) / -2;
            }
        }
        if (r.y + r.height - this.translation.y > height - insets.bottom) {
            this.translation.y = r.y + r.height - (height - insets.bottom);
        }
        if (Math.min(0, r.y) - this.translation.y < insets.top) {
            this.translation.y = Math.min(0, r.y) - insets.top;
        }
        if (r.x + r.width - this.translation.x > width - insets.right) {
            this.translation.x = r.x + r.width - (width - insets.right);
        }
        if (Math.min(0, r.x) - this.translation.x < insets.left) {
            this.translation.x = Math.min(0, r.x) - insets.left;
        }
        if (!oldTranslation.equals(this.translation)) {
            this.bufferedArea.translate(oldTranslation.x - this.translation.x, oldTranslation.y - this.translation.y);
            this.fireViewTransformChanged();
        }
    }

    @Override
    public Point drawingToView(Point2D.Double p) {
        return new Point((int)(p.x * this.scaleFactor) - this.translation.x, (int)(p.y * this.scaleFactor) - this.translation.y);
    }

    @Override
    public Rectangle drawingToView(Rectangle2D.Double r) {
        return new Rectangle((int)(r.x * this.scaleFactor) - this.translation.x, (int)(r.y * this.scaleFactor) - this.translation.y, (int)(r.width * this.scaleFactor), (int)(r.height * this.scaleFactor));
    }

    @Override
    public Point2D.Double viewToDrawing(Point p) {
        return new Point2D.Double((double)(p.x + this.translation.x) / this.scaleFactor, (double)(p.y + this.translation.y) / this.scaleFactor);
    }

    @Override
    public Rectangle2D.Double viewToDrawing(Rectangle r) {
        return new Rectangle2D.Double((double)(r.x + this.translation.x) / this.scaleFactor, (double)(r.y + this.translation.y) / this.scaleFactor, (double)r.width / this.scaleFactor, (double)r.height / this.scaleFactor);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setScaleFactor(double newValue) {
        double oldValue = this.scaleFactor;
        this.scaleFactor = newValue;
        this.validateViewTranslation();
        this.dirtyArea.setBounds(this.bufferedArea);
        this.invalidateHandles();
        this.revalidate();
        this.repaint();
        this.firePropertyChange("scaleFactor", oldValue, newValue);
    }

    protected void fireViewTransformChanged() {
        for (Handle handle : this.selectionHandles) {
            handle.viewTransformChanged();
        }
        for (Handle handle : this.secondaryHandles) {
            handle.viewTransformChanged();
        }
    }

    @Override
    public void setHandleDetailLevel(int newValue) {
        if (newValue != this.detailLevel) {
            this.detailLevel = newValue;
            this.invalidateHandles();
            this.validateHandles();
        }
    }

    @Override
    public int getHandleDetailLevel() {
        return this.detailLevel;
    }

    @Override
    public AffineTransform getDrawingToViewTransform() {
        AffineTransform t = new AffineTransform();
        t.translate(-this.translation.x, -this.translation.y);
        t.scale(this.scaleFactor, this.scaleFactor);
        return t;
    }

    @Override
    public void delete() {
        final List<Figure> deletedFigures = this.drawing.sort(this.getSelectedFigures());
        for (Figure f : deletedFigures) {
            if (f.isRemovable()) continue;
            this.getToolkit().beep();
            return;
        }
        final int[] deletedFigureIndices = new int[deletedFigures.size()];
        for (int i = 0; i < deletedFigureIndices.length; ++i) {
            deletedFigureIndices[i] = this.drawing.indexOf(deletedFigures.get(i));
        }
        this.clearSelection();
        this.getDrawing().removeAll(deletedFigures);
        this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                return labels.getString("edit.delete.text");
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                DefaultDrawingView.this.clearSelection();
                Drawing d = DefaultDrawingView.this.getDrawing();
                for (int i = 0; i < deletedFigureIndices.length; ++i) {
                    d.add(deletedFigureIndices[i], (Figure)deletedFigures.get(i));
                }
                DefaultDrawingView.this.addToSelection(deletedFigures);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                for (int i = 0; i < deletedFigureIndices.length; ++i) {
                    DefaultDrawingView.this.drawing.remove((Figure)deletedFigures.get(i));
                }
            }
        });
    }

    @Override
    public void duplicate() {
        List<Figure> sorted = this.getDrawing().sort(this.getSelectedFigures());
        HashMap<Figure, Figure> originalToDuplicateMap = new HashMap<Figure, Figure>(sorted.size());
        this.clearSelection();
        final ArrayList<Figure> duplicates = new ArrayList<Figure>(sorted.size());
        AffineTransform tx = new AffineTransform();
        tx.translate(5.0, 5.0);
        for (Figure f : sorted) {
            Figure d = f.clone();
            d.transform(tx);
            duplicates.add(d);
            originalToDuplicateMap.put(f, d);
            this.drawing.add(d);
        }
        for (Figure f : duplicates) {
            f.remap(originalToDuplicateMap, false);
        }
        this.addToSelection(duplicates);
        this.getDrawing().fireUndoableEditHappened(new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
                return labels.getString("edit.duplicate.text");
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                DefaultDrawingView.this.getDrawing().removeAll(duplicates);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                DefaultDrawingView.this.getDrawing().addAll(duplicates);
            }
        });
    }

    @Override
    public void removeNotify(DrawingEditor editor) {
        this.editor = null;
        this.repaint();
    }

    @Override
    public void addNotify(DrawingEditor editor) {
        DrawingEditor oldValue = editor;
        this.editor = editor;
        this.firePropertyChange("editor", oldValue, editor);
        this.invalidateHandles();
        this.repaint();
    }

    @Override
    public void setVisibleConstrainer(Constrainer newValue) {
        Constrainer oldValue = this.visibleConstrainer;
        this.visibleConstrainer = newValue;
        this.firePropertyChange("visibleConstrainer", oldValue, newValue);
    }

    @Override
    public Constrainer getVisibleConstrainer() {
        return this.visibleConstrainer;
    }

    @Override
    public void setInvisibleConstrainer(Constrainer newValue) {
        Constrainer oldValue = this.invisibleConstrainer;
        this.invisibleConstrainer = newValue;
        this.firePropertyChange("invisibleConstrainer", oldValue, newValue);
    }

    @Override
    public Constrainer getInvisibleConstrainer() {
        return this.invisibleConstrainer;
    }

    @Override
    public void setConstrainerVisible(boolean newValue) {
        boolean oldValue = this.isConstrainerVisible;
        this.isConstrainerVisible = newValue;
        this.firePropertyChange("constrainerVisible", oldValue, newValue);
        this.repaint();
    }

    @Override
    public boolean isConstrainerVisible() {
        return this.isConstrainerVisible;
    }

    public void setDrawingDoubleBuffered(boolean newValue) {
        boolean oldValue = this.isDrawingDoubleBuffered;
        this.isDrawingDoubleBuffered = newValue;
        if (!this.isDrawingDoubleBuffered && this.drawingBufferV != null) {
            this.drawingBufferV.flush();
            this.drawingBufferV = null;
        }
        if (!this.isDrawingDoubleBuffered && this.drawingBufferNV != null) {
            this.drawingBufferNV.flush();
            this.drawingBufferNV = null;
        }
        this.firePropertyChange(DRAWING_DOUBLE_BUFFERED_PROPERTY, oldValue, newValue);
    }

    public boolean isDrawingDoubleBuffered() {
        return this.isDrawingDoubleBuffered;
    }

    protected Paint getBackgroundPaint(int x, int y) {
        if (this.backgroundTile == null) {
            this.backgroundTile = new BufferedImage(16, 16, 1);
            Graphics2D g = this.backgroundTile.createGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, 16, 16);
            g.setColor(new Color(0xDFDFDF));
            g.fillRect(0, 0, 8, 8);
            g.fillRect(8, 8, 8, 8);
            g.dispose();
        }
        return new TexturePaint(this.backgroundTile, new Rectangle(x, y, this.backgroundTile.getWidth(), this.backgroundTile.getHeight()));
    }

    @Override
    public DrawingEditor getEditor() {
        return this.editor;
    }

    @Override
    public void setActiveHandle(@Nullable Handle newValue) {
        Handle oldValue = this.activeHandle;
        if (oldValue != null) {
            this.repaint(oldValue.getDrawingArea());
        }
        this.activeHandle = newValue;
        if (newValue != null) {
            this.repaint(newValue.getDrawingArea());
        }
        this.firePropertyChange("activeHandle", oldValue, newValue);
    }

    @Override
    public Handle getActiveHandle() {
        return this.activeHandle;
    }

    static {
        boolean b = false;
        try {
            if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
                b = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isWindows = b;
    }

    private class EventHandler
    implements FigureListener,
    CompositeFigureListener,
    HandleListener,
    FocusListener {
        private EventHandler() {
        }

        @Override
        public void figureAdded(CompositeFigureEvent evt) {
            if (DefaultDrawingView.this.drawing.getChildCount() == 1 && DefaultDrawingView.this.getEmptyDrawingMessage() != null) {
                DefaultDrawingView.this.repaint();
            } else {
                DefaultDrawingView.this.repaintDrawingArea(evt.getInvalidatedArea());
            }
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void figureRemoved(CompositeFigureEvent evt) {
            if (DefaultDrawingView.this.drawing.getChildCount() == 0 && DefaultDrawingView.this.getEmptyDrawingMessage() != null) {
                DefaultDrawingView.this.repaint();
            } else {
                DefaultDrawingView.this.repaintDrawingArea(evt.getInvalidatedArea());
            }
            DefaultDrawingView.this.removeFromSelection(evt.getChildFigure());
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void areaInvalidated(FigureEvent evt) {
            DefaultDrawingView.this.repaintDrawingArea(evt.getInvalidatedArea());
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void areaInvalidated(HandleEvent evt) {
            DefaultDrawingView.this.repaint(evt.getInvalidatedArea());
            DefaultDrawingView.this.invalidateDimension();
        }

        @Override
        public void handleRequestSecondaryHandles(HandleEvent e) {
            DefaultDrawingView.this.secondaryHandleOwner = e.getHandle();
            DefaultDrawingView.this.secondaryHandles.clear();
            DefaultDrawingView.this.secondaryHandles.addAll(DefaultDrawingView.this.secondaryHandleOwner.createSecondaryHandles());
            for (Handle h : DefaultDrawingView.this.secondaryHandles) {
                h.setView(DefaultDrawingView.this);
                h.addHandleListener(DefaultDrawingView.this.eventHandler);
            }
            DefaultDrawingView.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (DefaultDrawingView.this.editor != null) {
                DefaultDrawingView.this.editor.setActiveView(DefaultDrawingView.this);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void handleRequestRemove(HandleEvent e) {
            DefaultDrawingView.this.selectionHandles.remove(e.getHandle());
            e.getHandle().dispose();
            DefaultDrawingView.this.invalidateHandles();
            DefaultDrawingView.this.repaint(e.getInvalidatedArea());
        }

        @Override
        public void attributeChanged(FigureEvent e) {
            if (e.getSource() == DefaultDrawingView.this.drawing) {
                AttributeKey a = e.getAttribute();
                if (a.equals(AttributeKeys.CANVAS_HEIGHT) || a.equals(AttributeKeys.CANVAS_WIDTH)) {
                    DefaultDrawingView.this.validateViewTranslation();
                    DefaultDrawingView.this.repaint();
                }
                if (e.getInvalidatedArea() != null) {
                    DefaultDrawingView.this.repaintDrawingArea(e.getInvalidatedArea());
                } else {
                    DefaultDrawingView.this.repaintDrawingArea(DefaultDrawingView.this.viewToDrawing(DefaultDrawingView.this.getCanvasViewBounds()));
                }
            } else if (e.getInvalidatedArea() != null) {
                DefaultDrawingView.this.repaintDrawingArea(e.getInvalidatedArea());
            }
        }

        @Override
        public void figureHandlesChanged(FigureEvent e) {
        }

        @Override
        public void figureChanged(FigureEvent e) {
            DefaultDrawingView.this.repaintDrawingArea(e.getInvalidatedArea());
        }

        @Override
        public void figureAdded(FigureEvent e) {
        }

        @Override
        public void figureRemoved(FigureEvent e) {
        }

        @Override
        public void figureRequestRemove(FigureEvent e) {
        }
    }
}

