/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.NullNode;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

public abstract class AbstractMaxByFunction
implements Function {
    protected static final JsonNodeComparator comparator = JsonNodeComparator.getInstance();
    private String fname;

    public AbstractMaxByFunction(String fname) {
        this.fname = fname;
    }

    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputType(this.fname, in, JsonNodeType.ARRAY);
        NullNode maxItem = NullNode.getInstance();
        ArrayNode maxValue = null;
        for (JsonNode i : in) {
            ArrayNode value = scope.getObjectMapper().createArrayNode();
            args.get(0).apply(scope, i, arg_0 -> ((ArrayNode)value).add(arg_0));
            if (maxValue != null && this.isLarger((JsonNode)maxValue, (JsonNode)value)) continue;
            maxValue = value;
            maxItem = i;
        }
        output.emit((JsonNode)maxItem, null);
    }

    protected abstract boolean isLarger(JsonNode var1, JsonNode var2);
}

