/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.fife.ui.rtextarea.FoldIndicator;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.GutterIconInfo;

public class GutterUtils {
    private final Gutter gutter;

    GutterUtils(Gutter gutter) {
        this.gutter = gutter;
        gutter.setSpacingBetweenLineNumbersAndFoldIndicator(0);
        gutter.setShowCollapsedRegionToolTips(true);
    }

    private void updateFoldIcons() {
        int fontSize;
        int size;
        try {
            size = (int)new FoldIndicator(null).getPreferredSize().getWidth();
        }
        catch (Error | Exception ignored) {
            size = 12;
        }
        if (size < 8) {
            size = 8;
        }
        if (size > (fontSize = this.gutter.getLineNumberFont().getSize())) {
            size = fontSize;
        }
    }

    private ImageIcon getBookmarkIcon() {
        int size = this.gutter.getLineNumberFont().getSize();
        BufferedImage image = new BufferedImage(size, size, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(this.gutter.getLineNumberColor());
        graphics.fillRect(0, 0, size, size);
        graphics.setXORMode(this.gutter.getBorderColor());
        graphics.drawRect(0, 0, size - 1, size - 1);
        image.flush();
        return new ImageIcon(image);
    }

    private void updateBookmarkIcon() {
        GutterIconInfo[] stash = this.gutter.getBookmarks();
        this.gutter.setBookmarkIcon((Icon)this.getBookmarkIcon());
        for (GutterIconInfo info : stash) {
            try {
                this.gutter.toggleBookmark(info.getMarkedOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public static void updateIcons(Gutter gutter) {
        GutterUtils utils = new GutterUtils(gutter);
        utils.updateBookmarkIcon();
    }

    private class FoldIcon
    implements Icon {
        private final boolean collapsed;
        private final Color background;
        private final Color foreground;
        private final int size;

        FoldIcon(boolean collapsed, int size) {
            this.collapsed = collapsed;
            this.background = GutterUtils.this.gutter.getBorderColor();
            this.foreground = GutterUtils.this.gutter.getActiveLineRangeColor();
            this.size = size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.collapsed) {
                g.setColor(this.foreground);
                g.fillRect(x, y, this.size, this.size);
                g.setColor(this.background);
                g.drawRect(x, y, this.size - 2, this.size - 1);
            } else {
                g.setColor(this.background);
                g.fillRect(x, y, this.size, this.size);
                g.setColor(this.foreground);
                g.drawRect(x, y, this.size - 2, this.size - 1);
            }
        }
    }
}

