/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.scijava.ui.swing.script.TextEditor;
import org.scijava.util.PlatformUtils;

class CommandPalette {
    private static final String NAME = "Command Palette...";
    private static final KeyStroke ACCELERATOR = KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 0x40);
    private static final int TABLE_ROWS = 6;
    private static final float OPACITY = 1.0f;
    private static final boolean IGNORE_WHITESPACE = true;
    private static Palette frame;
    private SearchField searchField;
    private CmdTable table;
    private final TextEditor textEditor;
    private final CmdAction noHitsCmd;
    private final CmdScrapper cmdScrapper;

    public CommandPalette(TextEditor textEditor) {
        this.textEditor = textEditor;
        this.noHitsCmd = new SearchWebCmd();
        this.cmdScrapper = new CmdScrapper(textEditor);
    }

    void install(JMenu toolsMenu) {
        AbstractAction action = new AbstractAction(NAME){
            private static final long serialVersionUID = -7030359886427866104L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CommandPalette.this.toggleVisibility();
            }
        };
        action.putValue("AcceleratorKey", ACCELERATOR);
        toolsMenu.add(new JMenuItem(action));
    }

    Map<String, String> getShortcuts() {
        if (!this.cmdScrapper.scrapeSuccessful()) {
            this.cmdScrapper.scrape();
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        this.cmdScrapper.getCmdMap().forEach((id, cmdAction) -> {
            if (cmdAction.hotkey != null && !cmdAction.hotkey.isEmpty()) {
                result.put((String)id, cmdAction.hotkey);
            }
        });
        return result;
    }

    Map<String, String> getRecordableActions() {
        if (!this.cmdScrapper.scrapeSuccessful()) {
            this.cmdScrapper.scrape();
        }
        TreeMap<String, String> result = new TreeMap<String, String>();
        this.cmdScrapper.getCmdMap().forEach((id, cmdAction) -> {
            if (cmdAction.recordable()) {
                result.put((String)id, cmdAction.hotkey);
            }
        });
        return result;
    }

    void register(AbstractButton button, String description) {
        this.cmdScrapper.registerOther(button, description);
    }

    void dispose() {
        if (frame != null) {
            frame.dispose();
        }
        frame = null;
    }

    private void hideWindow() {
        if (frame != null) {
            frame.setVisible(false);
        }
    }

    private void assemblePalette() {
        if (frame != null) {
            return;
        }
        frame = new Palette();
        frame.setLayout(new BorderLayout());
        this.searchField = new SearchField();
        frame.add((Component)this.searchField, "North");
        this.searchField.getDocument().addDocumentListener(new PromptDocumentListener());
        InternalKeyListener keyListener = new InternalKeyListener();
        this.searchField.addKeyListener(keyListener);
        this.table = new CmdTable();
        this.table.addKeyListener(keyListener);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && CommandPalette.this.table.getSelectedRow() > -1) {
                    CommandPalette.this.runCmd(CommandPalette.this.table.getInternalModel().getCommand(CommandPalette.this.table.getSelectedRow()));
                }
            }
        });
        this.populateList("");
        frame.add(this.table.getScrollPane());
        frame.pack();
    }

    private String[] makeRow(CmdAction ca) {
        return new String[]{ca.id, ca.description()};
    }

    private void populateList(String matchingSubstring) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        if (!this.cmdScrapper.scrapeSuccessful()) {
            this.cmdScrapper.scrape();
        }
        this.cmdScrapper.getCmdMap().forEach((id, cmd) -> {
            if (cmd.matches(matchingSubstring)) {
                list.add(this.makeRow((CmdAction)cmd));
            }
        });
        if (list.isEmpty()) {
            list.add(this.makeRow(this.noHitsCmd));
        }
        this.table.getInternalModel().setData(list);
        if (this.searchField != null) {
            this.searchField.requestFocus();
        }
    }

    private void runCmd(String command) {
        SwingUtilities.invokeLater(() -> {
            if ("Rebuild Actions Index".equals(command)) {
                this.cmdScrapper.scrape();
                this.table.clearSelection();
                this.searchField.setText("");
                this.searchField.requestFocus();
                frame.setVisible(true);
                return;
            }
            CmdAction cmd = this.noHitsCmd != null && command.equals(this.noHitsCmd.id) ? this.noHitsCmd : this.cmdScrapper.getCmdMap().get(command);
            if (cmd != null) {
                boolean hasButton;
                boolean bl = hasButton = cmd.button != null;
                if (hasButton && !cmd.button.isEnabled()) {
                    this.textEditor.error("Command is currently disabled. Either execution requirements are unmet or it is not supported by current language.");
                    frame.setVisible(true);
                    return;
                }
                this.hideWindow();
                if (hasButton) {
                    cmd.button.doClick();
                } else if (cmd.action != null) {
                    cmd.action.actionPerformed(new ActionEvent(this.textEditor.getTextArea(), 1001, cmd.id));
                }
            }
        });
    }

    private void toggleVisibility() {
        if (frame == null) {
            this.assemblePalette();
        }
        if (frame.isVisible()) {
            this.hideWindow();
        } else {
            frame.center(this.textEditor);
            this.table.clearSelection();
            frame.setVisible(true);
            this.searchField.requestFocus();
        }
    }

    private class SearchWebCmd
    extends CmdAction {
        SearchWebCmd() {
            super("Search the Web");
            this.button = new JMenuItem(new AbstractAction(this.id){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextEditor.GuiUtils.runSearchQueryInBrowser(CommandPalette.this.textEditor, CommandPalette.this.textEditor.getPlatformService(), CommandPalette.this.searchField.getText());
                }
            });
        }

        @Override
        String description() {
            return "|Unmatched action|";
        }
    }

    private class CmdScrapper {
        final TextEditor textEditor;
        static final String REBUILD_ID = "Rebuild Actions Index";
        private final TreeMap<String, CmdAction> cmdMap;
        private TreeMap<String, CmdAction> otherMap;

        CmdScrapper(TextEditor textEditor) {
            this.textEditor = textEditor;
            this.cmdMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        }

        TreeMap<String, CmdAction> getCmdMap() {
            if (this.otherMap != null) {
                this.cmdMap.putAll(this.otherMap);
            }
            return this.cmdMap;
        }

        boolean scrapeSuccessful() {
            return !this.cmdMap.isEmpty();
        }

        void scrape() {
            this.cmdMap.clear();
            this.cmdMap.put(REBUILD_ID, new CmdAction(REBUILD_ID));
            this.parseActionAndInputMaps();
            JMenuBar menuBar = this.textEditor.getJMenuBar();
            int topLevelMenus = menuBar.getMenuCount();
            for (int i = 0; i < topLevelMenus; ++i) {
                JMenu topLevelMenu = menuBar.getMenu(i);
                if (topLevelMenu == null || topLevelMenu.getText() == null) continue;
                this.parseMenu(topLevelMenu.getText(), topLevelMenu);
            }
            JPopupMenu popup = this.textEditor.getEditorPane().getPopupMenu();
            if (popup != null) {
                this.getMenuItems(popup).forEach(mi -> this.registerMenuItem((JMenuItem)mi, "Popup Menu"));
            }
        }

        private void parseActionAndInputMaps() {
            InputMap inputMap = this.textEditor.getTextArea().getInputMap(0);
            KeyStroke[] keys = inputMap.allKeys();
            if (keys != null) {
                for (KeyStroke key : keys) {
                    CmdAction cmdAction;
                    String cmdName;
                    if (key.getModifiers() == 0) continue;
                    Object obj = inputMap.get(key);
                    if (obj instanceof Action) {
                        cmdName = (String)((Action)obj).getValue("Name");
                        cmdAction = new CmdAction(this.cleanseActionDescription(cmdName), (AbstractAction)obj);
                    } else {
                        if (!(obj instanceof AbstractButton)) continue;
                        cmdName = ((AbstractButton)obj).getText();
                        cmdAction = new CmdAction(cmdName, (AbstractButton)obj);
                    }
                    cmdAction.setkeyString(key);
                    this.cmdMap.put(cmdAction.id, cmdAction);
                }
            }
            ActionMap actionMap = this.textEditor.getTextArea().getActionMap();
            for (Object obj : actionMap.keys()) {
                if (!(obj instanceof String) || this.cmdMap.get((String)obj) != null) continue;
                Action action = actionMap.get((String)obj);
                CmdAction cmdAction = new CmdAction(this.cleanseActionDescription((String)obj), action);
                this.cmdMap.put(cmdAction.id, cmdAction);
            }
        }

        private void parseMenu(String componentHostingMenu, JMenu menu) {
            int n = menu.getItemCount();
            for (int i = 0; i < n; ++i) {
                this.registerMenuItem(menu.getItem(i), componentHostingMenu);
            }
        }

        private void registerMenuItem(JMenuItem m, String hostingComponent) {
            if (m != null) {
                String label = m.getActionCommand();
                if (label == null) {
                    label = m.getText();
                }
                if (m instanceof JMenu) {
                    JMenu subMenu = (JMenu)m;
                    String hostDesc = subMenu.getText();
                    if (hostDesc == null) {
                        hostDesc = hostingComponent;
                    }
                    this.parseMenu(hostDesc, subMenu);
                } else {
                    this.registerMain(m, hostingComponent);
                }
            }
        }

        private List<JMenuItem> getMenuItems(JPopupMenu popupMenu) {
            ArrayList<JMenuItem> list = new ArrayList<JMenuItem>();
            for (MenuElement me : popupMenu.getSubElements()) {
                if (me == null) continue;
                if (me instanceof JMenuItem) {
                    list.add((JMenuItem)me);
                    continue;
                }
                if (!(me instanceof JMenu)) continue;
                this.getMenuItems((JMenu)me, list);
            }
            return list;
        }

        private void getMenuItems(JMenu menu, List<JMenuItem> holdingList) {
            for (int j = 0; j < menu.getItemCount(); ++j) {
                JMenuItem jmi = menu.getItem(j);
                if (jmi == null) continue;
                if (jmi instanceof JMenu) {
                    this.getMenuItems((JMenu)jmi, holdingList);
                    continue;
                }
                holdingList.add(jmi);
            }
        }

        private boolean irrelevantCommand(String label) {
            return label == null || label.endsWith(" pt") || label.length() < 2;
        }

        void registerMain(AbstractButton button, String description) {
            this.register(this.cmdMap, button, description);
        }

        void registerOther(AbstractButton button, String description) {
            if (this.otherMap == null) {
                this.otherMap = new TreeMap();
            }
            this.register(this.otherMap, button, description);
        }

        private void register(TreeMap<String, CmdAction> map, AbstractButton button, String descriptionOfComponentHostingButton) {
            KeyStroke accelerator;
            String label = button.getActionCommand();
            if (CommandPalette.NAME.equals(label)) {
                return;
            }
            if (label == null) {
                label = button.getText().trim();
            }
            if (this.irrelevantCommand(label)) {
                return;
            }
            if (label.endsWith("...")) {
                label = label.substring(0, label.length() - 3);
            }
            boolean isMenuItem = button instanceof JMenuItem;
            CmdAction registeredAction = map.get(label);
            KeyStroke keyStroke = accelerator = isMenuItem ? ((JMenuItem)button).getAccelerator() : null;
            if (registeredAction != null && accelerator != null) {
                registeredAction.setkeyString(accelerator);
            } else {
                CmdAction ca = new CmdAction(label, button);
                ca.menuLocation = descriptionOfComponentHostingButton;
                if (accelerator != null) {
                    ca.setkeyString(accelerator);
                }
                map.put(ca.id, ca);
            }
        }

        private String cleanseActionDescription(String actionId) {
            if (actionId.startsWith("RTA.")) {
                actionId = actionId.substring(4);
            } else if (actionId.startsWith("RSTA.")) {
                actionId = actionId.substring(5);
            }
            if (actionId.endsWith("Action")) {
                actionId = actionId.substring(0, actionId.length() - 6);
            }
            actionId = actionId.replace("-", " ");
            return actionId.replaceAll("([A-Z])", " $1").trim();
        }
    }

    private class CmdAction {
        final String id;
        String menuLocation;
        String hotkey;
        AbstractButton button;
        Action action;

        CmdAction(String cmdName) {
            this.id = this.capitalize(cmdName);
            this.menuLocation = "";
            this.hotkey = "";
        }

        CmdAction(String cmdName, AbstractButton button) {
            this(cmdName);
            if (button.getAction() != null && button.getAction() instanceof AbstractAction) {
                this.action = (AbstractAction)button.getAction();
            } else {
                this.button = button;
            }
        }

        CmdAction(String cmdName, Action action) {
            this(cmdName);
            this.action = action;
        }

        boolean recordable() {
            return this.action != null && this.action instanceof RecordableTextAction;
        }

        String description() {
            String rec;
            String string = rec = this.recordable() ? "   \u29bf" : "";
            if (!this.hotkey.isEmpty()) {
                return this.hotkey + rec;
            }
            if (!this.menuLocation.isEmpty()) {
                return "|" + this.menuLocation + "|" + rec;
            }
            return rec;
        }

        boolean matches(String lowercaseQuery) {
            return this.id.toLowerCase().replaceAll("\\s+", "").contains(lowercaseQuery) || this.menuLocation.toLowerCase().contains(lowercaseQuery);
        }

        void setkeyString(KeyStroke key) {
            if (this.hotkey.isEmpty()) {
                this.hotkey = this.prettifiedKey(key);
            } else {
                String oldHotkey = this.hotkey;
                String newHotKey = this.prettifiedKey(key);
                if (!oldHotkey.contains(newHotKey)) {
                    this.hotkey = oldHotkey + " or " + newHotKey;
                }
            }
        }

        private String capitalize(String string) {
            return string.substring(0, 1).toUpperCase() + string.substring(1);
        }

        private String prettifiedKey(KeyStroke key) {
            if (key == null) {
                return "";
            }
            StringBuilder s = new StringBuilder();
            int m = key.getModifiers();
            if ((m & 0x80) != 0) {
                s.append(PlatformUtils.isMac() ? "\u2303 " : "Ctrl ");
            }
            if ((m & 0x100) != 0) {
                s.append(PlatformUtils.isMac() ? "\u2318 " : "Ctrl ");
            }
            if ((m & 0x200) != 0) {
                s.append(PlatformUtils.isMac() ? "\u2387 " : "Alt ");
            }
            if ((m & 0x40) != 0) {
                s.append("\u21e7 ");
            }
            if ((m & 0x400) != 0) {
                s.append("L-click ");
            }
            if ((m & 0x800) != 0) {
                s.append("R-click ");
            }
            if ((m & 0x1000) != 0) {
                s.append("M-click ");
            }
            switch (key.getKeyEventType()) {
                case 400: {
                    s.append(key.getKeyChar() + " ");
                    break;
                }
                case 401: 
                case 402: {
                    s.append(this.getKeyText(key.getKeyCode()) + " ");
                    break;
                }
            }
            return s.toString();
        }

        String getKeyText(int keyCode) {
            if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
                return String.valueOf((char)keyCode);
            }
            switch (keyCode) {
                case 44: {
                    return ",";
                }
                case 46: {
                    return ".";
                }
                case 47: {
                    return "/";
                }
                case 59: {
                    return ";";
                }
                case 61: {
                    return "=";
                }
                case 91: {
                    return "[";
                }
                case 92: {
                    return "\\";
                }
                case 93: {
                    return "]";
                }
                case 10: {
                    return "\u21b5";
                }
                case 8: {
                    return "\u232b";
                }
                case 9: {
                    return "\u21b9";
                }
                case 3: {
                    return "Cancel";
                }
                case 12: {
                    return "Clear";
                }
                case 19: {
                    return "Pause";
                }
                case 20: {
                    return "Caps Lock";
                }
                case 27: {
                    return "Esc";
                }
                case 32: {
                    return "Space";
                }
                case 33: {
                    return "\u21de";
                }
                case 34: {
                    return "\u21df";
                }
                case 35: {
                    return "END";
                }
                case 36: {
                    return "Home";
                }
                case 37: {
                    return "\u2190";
                }
                case 38: {
                    return "\u2191";
                }
                case 39: {
                    return "\u2192";
                }
                case 40: {
                    return "\u2193";
                }
                case 106: {
                    return "[Num \u00d7]";
                }
                case 107: {
                    return "[Num +]";
                }
                case 109: {
                    return "[Num \u2212]";
                }
                case 111: {
                    return "[Num /]";
                }
                case 127: {
                    return "\u2326";
                }
                case 155: {
                    return "Ins";
                }
                case 192: {
                    return "`";
                }
                case 222: {
                    return "'";
                }
                case 150: {
                    return "&";
                }
                case 151: {
                    return "*";
                }
                case 152: {
                    return "\"";
                }
                case 153: {
                    return "<";
                }
                case 160: {
                    return ">";
                }
                case 161: {
                    return "{";
                }
                case 162: {
                    return "}";
                }
                case 513: {
                    return ",";
                }
                case 514: {
                    return "^";
                }
                case 131: {
                    return "~";
                }
                case 515: {
                    return "$";
                }
                case 517: {
                    return "!";
                }
                case 519: {
                    return "(";
                }
                case 45: {
                    return "-";
                }
                case 521: {
                    return "+";
                }
                case 522: {
                    return ")";
                }
                case 523: {
                    return "_";
                }
            }
            return KeyEvent.getKeyText(keyCode);
        }
    }

    private class CmdTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int COLUMNS = 2;
        List<String[]> list;

        private CmdTableModel() {
        }

        void setData(ArrayList<String[]> list) {
            this.list = list;
            this.fireTableDataChanged();
        }

        String getCommand(int row) {
            if (this.list.size() == 1) {
                return (String)this.getValueAt(row, 0);
            }
            if (row < 0 || row >= this.list.size()) {
                return "";
            }
            return (String)this.getValueAt(row, 0);
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row >= this.list.size() || column >= 2) {
                return null;
            }
            String[] strings = this.list.get(row);
            return strings[column];
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }
    }

    private class CmdTableRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        final Font col0Font = SearchField.REF_FONT.deriveFont((float)SearchField.REF_FONT.getSize() * 1.2f);
        final Font col1Font = SearchField.REF_FONT.deriveFont((float)SearchField.REF_FONT.getSize() * 1.2f);

        private CmdTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 1) {
                this.setHorizontalAlignment(4);
                this.setEnabled(false);
                this.setFont(this.col1Font);
            } else {
                this.setHorizontalAlignment(2);
                this.setEnabled(true);
                this.setFont(this.col0Font);
            }
            return c;
        }

        int rowHeight() {
            return (int)((float)this.col0Font.getSize() * 1.75f);
        }

        int maxWidh(int columnIndex) {
            if (columnIndex == 1) {
                return SwingUtilities.computeStringWidth(this.getFontMetrics(this.col1Font), "Really+Huge+Key+Combo");
            }
            return SwingUtilities.computeStringWidth(this.getFontMetrics(this.col0Font), "A large filename from the Recents menu.groovy");
        }
    }

    private class CmdTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        CmdTable() {
            super(new CmdTableModel());
            this.setAutoCreateRowSorter(false);
            this.setSelectionMode(0);
            this.setShowGrid(false);
            this.setRowSelectionAllowed(true);
            this.setColumnSelectionAllowed(false);
            this.setTableHeader(null);
            this.setAutoResizeMode(3);
            CmdTableRenderer renderer = new CmdTableRenderer();
            int col0Width = renderer.maxWidh(0);
            int col1Width = renderer.maxWidh(1);
            this.setDefaultRenderer(Object.class, renderer);
            this.getColumnModel().getColumn(0).setMaxWidth(col0Width);
            this.getColumnModel().getColumn(1).setMaxWidth(col1Width);
            this.setRowHeight(renderer.rowHeight());
            int height = 6 * this.getRowHeight();
            if (this.getRowMargin() > 0) {
                height *= this.getRowMargin();
            }
            this.setPreferredScrollableViewportSize(new Dimension(col0Width + col1Width, height));
            this.setFillsViewportHeight(true);
        }

        private JScrollPane getScrollPane() {
            JScrollPane scrollPane = new JScrollPane(this, 20, 30);
            scrollPane.setWheelScrollingEnabled(true);
            return scrollPane;
        }

        CmdTableModel getInternalModel() {
            return (CmdTableModel)this.getModel();
        }
    }

    private class Palette
    extends JFrame {
        private static final long serialVersionUID = 1L;

        Palette() {
            super("Command Palette");
            this.setUndecorated(true);
            this.setAlwaysOnTop(true);
            this.setOpacity(1.0f);
            this.getRootPane().setWindowDecorationStyle(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    CommandPalette.this.hideWindow();
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    CommandPalette.this.hideWindow();
                }

                @Override
                public void windowDeactivated(WindowEvent e) {
                    CommandPalette.this.hideWindow();
                }
            });
        }

        void center(Container component) {
            Rectangle bounds = component.getBounds();
            Dimension w = this.getSize();
            int x = bounds.x + (bounds.width - w.width) / 2;
            int y = bounds.y + (bounds.height - w.height) / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.setLocation(x, y);
        }
    }

    private class InternalKeyListener
    extends KeyAdapter {
        private InternalKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            boolean meta;
            int key = ke.getKeyCode();
            int flags = ke.getModifiersEx();
            int items = CommandPalette.this.table.getInternalModel().getRowCount();
            Object source = ke.getSource();
            boolean bl = meta = (flags & 0x100) != 0 || (flags & 0x80) != 0;
            if (key == 27 || key == 87 && meta || key == 80 && meta) {
                CommandPalette.this.hideWindow();
            } else if (source == CommandPalette.this.searchField) {
                if (key == 10 && 1 == items) {
                    CommandPalette.this.runCmd(CommandPalette.this.table.getInternalModel().getCommand(0));
                }
                int index = -1;
                if (key == 38) {
                    index = CommandPalette.this.table.getSelectedRow() - 1;
                    if (index < 0) {
                        index = items - 1;
                    }
                } else if (key == 40 && (index = CommandPalette.this.table.getSelectedRow() + 1) >= items) {
                    index = Math.min(items - 1, 0);
                }
                if (index >= 0) {
                    CommandPalette.this.table.requestFocus();
                    CommandPalette.this.table.setRowSelectionInterval(index, index);
                }
            } else if (key == 8 || key == 127) {
                CommandPalette.this.searchField.requestFocus();
            } else if (source == CommandPalette.this.table) {
                if (key == 10) {
                    ke.consume();
                    int row = CommandPalette.this.table.getSelectedRow();
                    if (row >= 0) {
                        CommandPalette.this.runCmd(CommandPalette.this.table.getInternalModel().getCommand(row));
                    }
                } else if (key == 38) {
                    if (CommandPalette.this.table.getSelectedRow() == 0) {
                        CommandPalette.this.table.setRowSelectionInterval(CommandPalette.this.table.getRowCount() - 1, CommandPalette.this.table.getRowCount() - 1);
                    }
                } else if (key == 40 && CommandPalette.this.table.getSelectedRow() == CommandPalette.this.table.getRowCount() - 1) {
                    CommandPalette.this.table.setRowSelectionInterval(0, 0);
                }
            }
        }
    }

    private class PromptDocumentListener
    implements DocumentListener {
        private PromptDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            CommandPalette.this.populateList(this.getQueryFromSearchField());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            CommandPalette.this.populateList(this.getQueryFromSearchField());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            CommandPalette.this.populateList(this.getQueryFromSearchField());
        }

        String getQueryFromSearchField() {
            String text = CommandPalette.this.searchField.getText();
            if (text == null) {
                return "";
            }
            String query = text.toLowerCase();
            return query.replaceAll("\\s+", "");
        }
    }

    private static class SearchField
    extends TextEditor.TextFieldWithPlaceholder {
        private static final long serialVersionUID = 1L;
        private static final int PADDING = 4;
        static final Font REF_FONT = SearchField.refFont();

        SearchField() {
            this.setPlaceholder(" Search for commands and actions (e.g., Theme)");
            this.setMargin(new Insets(4, 4, 0, 0));
            this.setFont(REF_FONT.deriveFont((float)REF_FONT.getSize() * 1.5f));
        }

        @Override
        Font getPlaceholderFont() {
            return REF_FONT.deriveFont(2);
        }

        static Font refFont() {
            try {
                return UIManager.getFont("TextField.font");
            }
            catch (Exception ignored) {
                return new JTextField().getFont();
            }
        }
    }
}

