/*
 * Decompiled with CFR 0.152.
 */
package process;

import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class GaussianMaskFit {
    public static void gaussianMaskFit(RandomAccessibleInterval<FloatType> signalInterval, double[] location, double[] sigma, int iterations) {
        int n = signalInterval.numDimensions();
        double[] two_sq_sigma = new double[n];
        for (int d = 0; d < n; ++d) {
            two_sq_sigma[d] = 2.0 * sigma[d] * sigma[d];
        }
        IterableInterval signalIterable = Views.iterable(signalInterval);
        Img gaussianMask = new ArrayImgFactory().create(signalInterval, signalIterable.firstElement());
        long[] translation = new long[n];
        for (int d = 0; d < n; ++d) {
            translation[d] = signalInterval.min(d);
        }
        IntervalView translatedMask = Views.translate((RandomAccessibleInterval)gaussianMask, (long[])translation);
        IterableInterval translatedIterableMask = Views.iterable((RandomAccessibleInterval)translatedMask);
        double bg = GaussianMaskFit.removeBackground((IterableInterval<FloatType>)signalIterable);
        double N = 0.0;
        int i = 0;
        do {
            GaussianMaskFit.setGaussian((IterableInterval<FloatType>)translatedIterableMask, location, two_sq_sigma);
            Cursor cMask = gaussianMask.cursor();
            Cursor cImg = signalIterable.localizingCursor();
            double[] sumLocSN = new double[n];
            double sumSN = 0.0;
            double sumSS = 0.0;
            while (cMask.hasNext()) {
                cMask.fwd();
                cImg.fwd();
                double signal = ((FloatType)cImg.get()).getRealDouble();
                double mask = ((FloatType)cMask.get()).getRealDouble();
                double weight = 8.0;
                double signalmask = signal * mask * 8.0;
                sumSN += signalmask;
                sumSS += signal * signal * 8.0;
                int d = 0;
                while (d < n) {
                    double l = cImg.getLongPosition(d);
                    int n2 = d++;
                    sumLocSN[n2] = sumLocSN[n2] + l * signalmask;
                }
            }
            for (int d = 0; d < n; ++d) {
                location[d] = sumLocSN[d] / sumSN;
            }
            N = sumSN / sumSS;
        } while (++i < iterations);
        GaussianMaskFit.restoreBackground((IterableInterval<FloatType>)signalIterable, bg);
    }

    public static double removeBackground(IterableInterval<FloatType> iterable) {
        double i = 0.0;
        for (FloatType t : iterable) {
            i += t.getRealDouble();
        }
        i /= (double)iterable.size();
        for (FloatType t : iterable) {
            t.setReal((double)t.get() - i);
        }
        return i;
    }

    public static void restoreBackground(IterableInterval<FloatType> iterable, double value) {
        for (FloatType t : iterable) {
            t.setReal((double)t.get() + value);
        }
    }

    public static final void setGaussian(IterableInterval<FloatType> image, double[] location, double[] two_sq_sigma) {
        int numDimensions = image.numDimensions();
        Cursor cursor = image.localizingCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            double value = 1.0;
            for (int d = 0; d < numDimensions; ++d) {
                double x = location[d] - (double)cursor.getIntPosition(d);
                value *= Math.exp(-(x * x) / two_sq_sigma[d]);
            }
            ((FloatType)cursor.get()).setReal(value);
        }
    }
}

