/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.inference.fits;

import java.util.ArrayList;
import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.array.ArrayCursor;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.array.ArrayRandomAccess;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.list.ListImg;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.RealComposite;
import org.janelia.thickness.inference.Options;
import org.janelia.thickness.inference.fits.AbstractCorrelationFit;

public class LocalCorrelationFitAverage
extends AbstractCorrelationFit {
    int estimateWindowRadius;
    ScaleAndTranslation scaleAndTranslation;
    ArrayImg<DoubleType, DoubleArray> summedMeasurements;
    ArrayRandomAccess<DoubleType> measurementsAccess;
    double[][] nSamples;
    double[] transformCoordinate;

    public LocalCorrelationFitAverage(int dimension, Options o) {
        this.estimateWindowRadius = o.estimateWindowRadius < 1 ? dimension : Math.min(o.estimateWindowRadius, dimension);
        int nFits = Math.max(dimension / this.estimateWindowRadius, 1);
        double[] translation = new double[]{this.estimateWindowRadius};
        double[] scale = new double[]{this.estimateWindowRadius};
        this.scaleAndTranslation = new ScaleAndTranslation(scale, translation);
        this.summedMeasurements = ArrayImgs.doubles((long[])new long[]{nFits, o.comparisonRange + 1});
        this.measurementsAccess = this.summedMeasurements.randomAccess();
        this.nSamples = new double[nFits][o.comparisonRange + 1];
        this.transformCoordinate = new double[1];
    }

    @Override
    protected void add(int z, int dz, double value, double weight) {
        this.transformCoordinate[0] = z;
        this.scaleAndTranslation.applyInverse(this.transformCoordinate, this.transformCoordinate);
        if (this.transformCoordinate[0] <= 0.0) {
            this.addLocal(0, dz, value, weight);
        } else if (this.transformCoordinate[0] >= (double)(this.nSamples.length - 1)) {
            this.addLocal(this.nSamples.length - 1, dz, value, weight);
        } else {
            int lower = (int)Math.floor(this.transformCoordinate[0]);
            this.addLocal(lower, dz, value, weight);
            this.addLocal(lower + 1, dz, value, weight);
        }
    }

    private void addLocal(int localZ, int dz, double value, double weight) {
        this.measurementsAccess.setPosition(localZ, 0);
        this.measurementsAccess.setPosition(dz, 1);
        ((DoubleType)this.measurementsAccess.get()).add((AbstractRealType)new DoubleType(value * weight));
        double[] dArray = this.nSamples[localZ];
        int n = dz;
        dArray[n] = dArray[n] + weight;
    }

    @Override
    protected void init(int size) {
        ArrayCursor c = this.summedMeasurements.cursor();
        int sizePlusOne = size + 1;
        for (int n = 0; n < this.nSamples.length; ++n) {
            double[] ns = this.nSamples[n];
            for (int r = 0; r < sizePlusOne; ++r) {
                ns[r] = 0.0;
                ((DoubleType)c.next()).set(0.0);
            }
        }
    }

    @Override
    protected RandomAccessibleInterval<double[]> estimate(int size) {
        ArrayRandomAccess ra = this.summedMeasurements.randomAccess();
        for (int n = 0; n < this.nSamples.length; ++n) {
            ra.setPosition(n, 0);
            double[] ns = this.nSamples[n];
            for (int r = 0; r < ns.length; ++r) {
                ra.setPosition(r, 1);
                ((DoubleType)ra.get()).mul(1.0 / ns[r]);
            }
        }
        CompositeIntervalView collapsed = Views.collapseReal(this.summedMeasurements);
        RealRandomAccessible interpolated = Views.interpolate((EuclideanSpace)Views.extendBorder((RandomAccessibleInterval)collapsed), (InterpolatorFactory)new NLinearInterpolatorFactory());
        FinalInterval fi = new FinalInterval(new long[]{size});
        IntervalView transformed = Views.interval((RandomAccessible)Views.raster((RealRandomAccessible)RealViews.transformReal((RealRandomAccessible)interpolated, (InvertibleRealTransform)this.scaleAndTranslation)), (Interval)fi);
        Cursor t = transformed.cursor();
        ArrayList<double[]> list = new ArrayList<double[]>();
        for (int n = 0; n < size; ++n) {
            RealComposite c = (RealComposite)t.next();
            double[] target = new double[this.nSamples[0].length];
            target[0] = -1.0;
            for (int i = 1; i < target.length; ++i) {
                target[i] = -((DoubleType)c.get((long)i)).get();
            }
            list.add(target);
        }
        return new ListImg(list, new long[]{list.size()});
    }
}

