/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import bdv.viewer.render.Tiling;
import bdv.viewer.render.VolatileProjector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.util.Intervals;
import net.imglib2.util.StopWatch;
import net.imglib2.view.Views;

public abstract class AccumulateProjector<A, B>
implements VolatileProjector {
    private List<VolatileProjector> sourceProjectors;
    private final List<IterableInterval<? extends A>> sources;
    private final RandomAccessibleInterval<B> target;
    private final IterableInterval<B> iterableTarget;
    private long lastFrameRenderNanoTime;
    private volatile boolean canceled = false;
    private volatile boolean valid = false;

    @Deprecated
    public AccumulateProjector(List<VolatileProjector> sourceProjectors, List<? extends RandomAccessible<? extends A>> sources, RandomAccessibleInterval<B> target, int numThreads, ExecutorService executorService) {
        this(sourceProjectors, sources, target);
    }

    public AccumulateProjector(List<VolatileProjector> sourceProjectors, List<? extends RandomAccessible<? extends A>> sources, RandomAccessibleInterval<B> target) {
        this.sourceProjectors = sourceProjectors;
        this.sources = new ArrayList<IterableInterval<? extends A>>();
        for (RandomAccessible<A> randomAccessible : sources) {
            this.sources.add(Views.flatIterable(Views.interval(randomAccessible, target)));
        }
        this.target = target;
        this.iterableTarget = Views.flatIterable(target);
        this.lastFrameRenderNanoTime = -1L;
    }

    @Override
    public boolean map(boolean clearUntouchedTargetPixels) {
        if (this.canceled) {
            return false;
        }
        if (this.isValid()) {
            return true;
        }
        StopWatch stopWatch = StopWatch.createAndStart();
        if (Intervals.numElements(this.target) < (long)Tiling.MIN_ACCUMULATE_FORK_SIZE) {
            this.sourceProjectors.forEach(p -> p.map(clearUntouchedTargetPixels));
        } else {
            ForkJoinTask.invokeAll(this.sourceProjectors.stream().map(p -> ForkJoinTask.adapt(() -> p.map(clearUntouchedTargetPixels))).collect(Collectors.toList()));
        }
        if (this.canceled) {
            return false;
        }
        this.mapAccumulate();
        this.sourceProjectors = this.sourceProjectors.stream().filter(p -> !p.isValid()).collect(Collectors.toList());
        this.lastFrameRenderNanoTime = stopWatch.nanoTime();
        this.valid = this.sourceProjectors.isEmpty();
        return !this.canceled;
    }

    private void mapAccumulate() {
        if (this.canceled) {
            return;
        }
        int numSources = this.sources.size();
        Cursor[] sourceCursors = new Cursor[numSources];
        Arrays.setAll(sourceCursors, s -> this.sources.get(s).cursor());
        RealCursor targetCursor = this.iterableTarget.cursor();
        int width = (int)this.target.dimension(0);
        int height = (int)this.target.dimension(1);
        int size = width * height;
        for (int i = 0; i < size; ++i) {
            for (int s2 = 0; s2 < numSources; ++s2) {
                sourceCursors[s2].fwd();
            }
            this.accumulate(sourceCursors, targetCursor.next());
        }
    }

    protected abstract void accumulate(Cursor<? extends A>[] var1, B var2);

    @Override
    public void cancel() {
        this.canceled = true;
        for (VolatileProjector p : this.sourceProjectors) {
            p.cancel();
        }
    }

    @Override
    public long getLastFrameRenderNanoTime() {
        return this.lastFrameRenderNanoTime;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }
}

