/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.overlay;

import bdv.ui.UIUtils;
import bdv.util.Affine3DHelpers;
import bdv.util.Prefs;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerState;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.realtransform.AffineTransform3D;

public class ScaleBarOverlayRenderer {
    private final DecimalFormat format = new DecimalFormat("0.####");
    private final AffineTransform3D transform = new AffineTransform3D();
    private final AffineTransform3D sourceTransform = new AffineTransform3D();
    private final int targetScaleBarLength = 100;
    private final int subdivPerPowerOfTen = 4;
    private double scaleBarLength;
    private double scale;
    private String unit;
    private boolean drawScaleBar;
    private static final String[] lengthUnits = new String[]{"nm", "\u00b5m", "mm", "m", "km"};

    public synchronized void paint(Graphics2D g) {
        if (this.drawScaleBar) {
            Font font = UIUtils.getFont("defaultFont");
            String scaleBarText = this.format.format(this.scale) + " " + this.unit;
            Color color = new Color(Prefs.scaleBarColor(), true);
            Color bgcolor = new Color(Prefs.scaleBarBgColor(), true);
            int x = 20;
            int y = (int)g.getClipBounds().getHeight() - 30;
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout layout = new TextLayout(scaleBarText, font, frc);
            Rectangle2D bounds = layout.getBounds();
            float tx = (float)(20.0 + (this.scaleBarLength - bounds.getMaxX()) / 2.0);
            float ty = y - 5;
            g.setColor(bgcolor);
            g.fillRect(13, (int)((double)ty - bounds.getHeight() - 3.0), (int)this.scaleBarLength + 14, (int)bounds.getHeight() + 25);
            g.setColor(color);
            g.fillRect(20, y, (int)this.scaleBarLength, 10);
            layout.draw(g, tx, ty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public synchronized void setViewerState(bdv.viewer.state.ViewerState state) {
        bdv.viewer.state.ViewerState viewerState = state;
        synchronized (viewerState) {
            this.setViewerState(state.getState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setViewerState(ViewerState state) {
        ViewerState viewerState = state;
        synchronized (viewerState) {
            SourceAndConverter<?> current = state.getCurrentSource();
            if (current == null) {
                this.drawScaleBar = false;
                return;
            }
            Source<?> spimSource = current.getSpimSource();
            VoxelDimensions voxelDimensions = spimSource.getVoxelDimensions();
            if (voxelDimensions == null) {
                this.drawScaleBar = false;
                return;
            }
            this.drawScaleBar = true;
            state.getViewerTransform(this.transform);
            int t = state.getCurrentTimepoint();
            spimSource.getSourceTransform(t, 0, this.sourceTransform);
            this.transform.concatenate(this.sourceTransform);
            double sizeOfOnePixel = voxelDimensions.dimension(0) / Affine3DHelpers.extractScale(this.transform, 0);
            double sT = 100.0 * sizeOfOnePixel;
            double pot = Math.floor(Math.log10(sT));
            double l2 = sT / Math.pow(10.0, pot);
            int fracs = (int)(0.1 * l2 * 4.0);
            double scale1 = fracs > 0 ? Math.pow(10.0, pot + 1.0) * (double)fracs / 4.0 : Math.pow(10.0, pot);
            double scale2 = fracs == 3 ? Math.pow(10.0, pot + 1.0) : Math.pow(10.0, pot + 1.0) * (double)(fracs + 1) / 4.0;
            double lB1 = scale1 / sizeOfOnePixel;
            double lB2 = scale2 / sizeOfOnePixel;
            if (Math.abs(lB1 - 100.0) < Math.abs(lB2 - 100.0)) {
                this.scale = scale1;
                this.scaleBarLength = lB1;
            } else {
                this.scale = scale2;
                this.scaleBarLength = lB2;
            }
            String scaleUnit = voxelDimensions.unit();
            if ("um".equals(scaleUnit)) {
                scaleUnit = "\u00b5m";
            }
            int scaleUnitIndex = -1;
            for (int i = 0; i < lengthUnits.length; ++i) {
                if (!lengthUnits[i].equals(scaleUnit)) continue;
                scaleUnitIndex = i;
                break;
            }
            if (scaleUnitIndex >= 0) {
                int shifts = (int)Math.floor((Math.log10(this.scale) + 1.0) / 3.0);
                int shiftedIndex = scaleUnitIndex + shifts;
                if (shiftedIndex < 0) {
                    shifts = -scaleUnitIndex;
                    shiftedIndex = 0;
                } else if (shiftedIndex >= lengthUnits.length) {
                    shifts = lengthUnits.length - 1 - scaleUnitIndex;
                    shiftedIndex = lengthUnits.length - 1;
                }
                this.scale /= Math.pow(1000.0, shifts);
                this.unit = lengthUnits[shiftedIndex];
            } else {
                this.unit = scaleUnit;
            }
        }
    }
}

