/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.tools.brightness.ConverterSetup;
import bdv.viewer.BasicViewerState;
import bdv.viewer.ConverterSetupBounds;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceToConverterSetupBimap;
import bdv.viewer.ViewerState;
import bdv.viewer.ViewerStateChange;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.scijava.listeners.Listeners;

public class ConverterSetups
implements SourceToConverterSetupBimap {
    private final Map<ConverterSetup, SourceAndConverter<?>> setupToSource = new HashMap();
    private final Map<SourceAndConverter<?>, ConverterSetup> sourceToSetup = new HashMap();
    private final ViewerState state;
    private final BasicViewerState previousState;
    private final ConverterSetup.SetupChangeListener converterSetupChangeListener;
    private final Listeners.List<ConverterSetup.SetupChangeListener> forwardedSetupChangeListeners = new Listeners.SynchronizedList();
    private final ConverterSetupBounds bounds;

    public ConverterSetups(ViewerState state) {
        this.state = state;
        this.previousState = new BasicViewerState(state);
        this.converterSetupChangeListener = setup -> this.forwardedSetupChangeListeners.list.forEach(l -> l.setupParametersChanged(setup));
        state.changeListeners().add(this::analyzeChanges);
        this.bounds = new ConverterSetupBounds(this);
    }

    public Listeners<ConverterSetup.SetupChangeListener> listeners() {
        return this.forwardedSetupChangeListeners;
    }

    @Override
    public SourceAndConverter<?> getSource(ConverterSetup setup) {
        return this.setupToSource.get(setup);
    }

    @Override
    public ConverterSetup getConverterSetup(SourceAndConverter<?> source) {
        return this.sourceToSetup.get(source);
    }

    public synchronized void put(SourceAndConverter<?> source, ConverterSetup setup) {
        ConverterSetup previousSetup = this.sourceToSetup.put(source, setup);
        SourceAndConverter<?> previousSource = this.setupToSource.put(setup, source);
        setup.setupChangeListeners().add((Object)this.converterSetupChangeListener);
        if (previousSetup != null && previousSetup != setup) {
            this.setupToSource.remove(previousSetup);
            previousSetup.setupChangeListeners().remove((Object)this.converterSetupChangeListener);
        }
        if (previousSource != null && previousSource != source) {
            this.sourceToSetup.remove(previousSource);
        }
    }

    public ConverterSetupBounds getBounds() {
        return this.bounds;
    }

    private synchronized void analyzeChanges(ViewerStateChange change) {
        if (change != ViewerStateChange.NUM_SOURCES_CHANGED) {
            return;
        }
        HashSet removedSources = new HashSet(this.previousState.getSources());
        removedSources.removeAll(this.state.getSources());
        for (SourceAndConverter<?> sourceAndConverter : removedSources) {
            ConverterSetup setup = this.sourceToSetup.remove(sourceAndConverter);
            if (setup == null) continue;
            this.setupToSource.remove(setup);
            setup.setupChangeListeners().remove((Object)this.converterSetupChangeListener);
        }
        this.previousState.set(this.state);
    }
}

