/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class Prefs {
    private static Prefs instance;
    private static final String SHOW_SCALE_BAR = "show-scale-bar";
    private static final String SHOW_MULTIBOX_OVERLAY = "show-multibox-overlay";
    private static final String SHOW_TEXT_OVERLAY = "show-text-overlay";
    private static final String SOURCE_NAME_OVERLAY_POSITION = "source-name-overlay-position";
    private static final String SHOW_SCALE_BAR_IN_MOVIE = "show-scale-bar-in-movie";
    private static final String SCALE_BAR_COLOR = "scale-bar-color";
    private static final String SCALE_BAR_BG_COLOR = "scale-bar-bg-color";
    private boolean showScaleBar;
    private boolean showMultibox;
    private boolean showTextOverlay;
    private OverlayPosition sourceNameOverlayPosition;
    private boolean showScaleBarInMovie;
    private int scaleBarColor;
    private int scaleBarBgColor;

    public static boolean showScaleBar() {
        return Prefs.getInstance().showScaleBar;
    }

    public static boolean showMultibox() {
        return Prefs.getInstance().showMultibox;
    }

    public static boolean showTextOverlay() {
        return Prefs.getInstance().showTextOverlay;
    }

    public static OverlayPosition sourceNameOverlayPosition() {
        return Prefs.getInstance().sourceNameOverlayPosition;
    }

    public static boolean showScaleBarInMovie() {
        return Prefs.getInstance().showScaleBarInMovie;
    }

    public static int scaleBarColor() {
        return Prefs.getInstance().scaleBarColor;
    }

    public static int scaleBarBgColor() {
        return Prefs.getInstance().scaleBarBgColor;
    }

    public static void showScaleBar(boolean show) {
        Prefs.getInstance().showScaleBar = show;
    }

    public static void showMultibox(boolean show) {
        Prefs.getInstance().showMultibox = show;
    }

    public static void showTextOverlay(boolean show) {
        Prefs.getInstance().showTextOverlay = show;
    }

    public static void sourceNameOverlayPosition(OverlayPosition position) {
        Prefs.getInstance().sourceNameOverlayPosition = position;
    }

    public static void showScaleBarInMovie(boolean show) {
        Prefs.getInstance().showScaleBarInMovie = show;
    }

    public static void scaleBarColor(int color) {
        Prefs.getInstance().scaleBarColor = color;
    }

    public static void scaleBarBgColor(int color) {
        Prefs.getInstance().scaleBarBgColor = color;
    }

    public static Prefs getInstance() {
        if (instance == null) {
            instance = Prefs.readPropertyFile();
        }
        return instance;
    }

    private Prefs(Properties p) {
        this.showScaleBar = this.getBoolean(p, SHOW_SCALE_BAR, false);
        this.showMultibox = this.getBoolean(p, SHOW_MULTIBOX_OVERLAY, true);
        this.showTextOverlay = this.getBoolean(p, SHOW_TEXT_OVERLAY, true);
        this.sourceNameOverlayPosition = this.getOverlayPosition(p, SOURCE_NAME_OVERLAY_POSITION, OverlayPosition.TOP_CENTER);
        this.showScaleBarInMovie = this.getBoolean(p, SHOW_SCALE_BAR_IN_MOVIE, false);
        this.scaleBarColor = this.getInt(p, SCALE_BAR_COLOR, -1);
        this.scaleBarBgColor = this.getInt(p, SCALE_BAR_BG_COLOR, -2013265920);
    }

    private boolean getBoolean(Properties p, String key, boolean defaultValue) {
        String property = p != null ? p.getProperty(key) : null;
        return property != null ? Boolean.parseBoolean(property) : defaultValue;
    }

    private int getInt(Properties p, String key, int defaultValue) {
        try {
            String property = p != null ? p.getProperty(key) : null;
            return property != null ? (int)(Long.decode(property) & 0xFFFFFFFFFFFFFFFFL) : defaultValue;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    private double getDouble(Properties p, String key, double defaultValue) {
        try {
            String property = p != null ? p.getProperty(key) : null;
            return property != null ? Double.parseDouble(property) : defaultValue;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    private OverlayPosition getOverlayPosition(Properties p, String key, OverlayPosition defaultValue) {
        try {
            String property = p != null ? p.getProperty(key) : null;
            return property != null ? OverlayPosition.valueOf(property) : defaultValue;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    private static Prefs readPropertyFile() {
        File[] files;
        for (File file : files = new File[]{new File("bigdataviewer.properties"), new File(System.getProperty("user.home") + "/.bdv/bigdataviewer.properties")}) {
            if (!file.isFile()) continue;
            try {
                return Prefs.readPropertyFile(file);
            }
            catch (IOException e) {
                System.err.println("Cannot read config file :" + file);
                e.printStackTrace();
            }
        }
        return new Prefs(null);
    }

    private static Prefs readPropertyFile(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        Properties config = new Properties();
        config.load(stream);
        return new Prefs(config);
    }

    public static Properties getDefaultProperties() {
        Properties properties = new Properties();
        Prefs prefs = new Prefs(null);
        properties.put(SHOW_SCALE_BAR, "" + prefs.showScaleBar);
        properties.put(SHOW_MULTIBOX_OVERLAY, "" + prefs.showMultibox);
        properties.put(SHOW_TEXT_OVERLAY, "" + prefs.showTextOverlay);
        properties.put(SOURCE_NAME_OVERLAY_POSITION, "" + (Object)((Object)prefs.sourceNameOverlayPosition));
        properties.put(SHOW_SCALE_BAR_IN_MOVIE, "" + prefs.showScaleBarInMovie);
        properties.put(SCALE_BAR_COLOR, "" + prefs.scaleBarColor);
        properties.put(SCALE_BAR_BG_COLOR, "" + prefs.scaleBarBgColor);
        return properties;
    }

    public static void printDefaultProperties() throws IOException {
        Prefs.getDefaultProperties().store(System.out, "default properties");
    }

    public static enum OverlayPosition {
        TOP_CENTER,
        TOP_RIGHT;

    }
}

