/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.BigDataViewer;
import bdv.cache.CacheControl;
import bdv.export.ProgressWriter;
import bdv.export.ProgressWriterConsole;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.transformation.ManualTransformationEditor;
import bdv.ui.UIUtils;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.keymap.KeymapManager;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.viewer.DisplayMode;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerFrame;
import bdv.viewer.ViewerOptions;
import bdv.viewer.ViewerStateChange;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class BdvHandleFrame
extends BdvHandle {
    private BigDataViewer bdv;
    private final String frameTitle;

    BdvHandleFrame(BdvOptions options) {
        super(options);
        this.frameTitle = options.values.getFrameTitle();
        this.bdv = null;
        this.cacheControls = new CacheControl.CacheControls();
        UIUtils.installFlatLafInfos();
    }

    public BigDataViewer getBigDataViewer() {
        return this.bdv;
    }

    @Override
    public void close() {
        if (this.bdv != null) {
            ViewerFrame frame = this.bdv.getViewerFrame();
            frame.dispatchEvent(new WindowEvent(frame, 201));
            this.bdv = null;
        }
        super.close();
    }

    @Override
    public ManualTransformationEditor getManualTransformEditor() {
        return this.bdv.getManualTransformEditor();
    }

    @Override
    public KeymapManager getKeymapManager() {
        return this.bdv.getKeymapManager();
    }

    @Override
    public AppearanceManager getAppearanceManager() {
        return this.bdv.getAppearanceManager();
    }

    @Override
    public InputActionBindings getKeybindings() {
        return this.bdv.getViewerFrame().getKeybindings();
    }

    @Override
    public TriggerBehaviourBindings getTriggerbindings() {
        return this.bdv.getViewerFrame().getTriggerbindings();
    }

    @Override
    boolean createViewer(List<? extends ConverterSetup> converterSetups, List<? extends SourceAndConverter<?>> sources, int numTimepoints) {
        ProgressWriterConsole progressWriter = new ProgressWriterConsole();
        ViewerOptions viewerOptions = this.bdvOptions.values.getViewerOptions();
        InputTriggerConfig inputTriggerConfig = BigDataViewer.getInputTriggerConfig(viewerOptions);
        this.bdv = new BigDataViewer(new ArrayList<ConverterSetup>(converterSetups), new ArrayList(sources), null, numTimepoints, (CacheControl)this.cacheControls, this.frameTitle, (ProgressWriter)progressWriter, viewerOptions.inputTriggerConfig(inputTriggerConfig));
        this.viewer = this.bdv.getViewer();
        this.cards = this.bdv.getViewerFrame().getCardPanel();
        this.splitPanel = this.bdv.getViewerFrame().getSplitPanel();
        this.setupAssignments = this.bdv.getSetupAssignments();
        this.setups = this.bdv.getConverterSetups();
        this.viewer.state().changeListeners().add(change -> {
            if (change == ViewerStateChange.VISIBILITY_CHANGED) {
                this.viewer.getDisplay().repaint();
            }
        });
        this.viewer.setDisplayMode(DisplayMode.FUSED);
        this.bdv.getViewerFrame().setVisible(true);
        boolean initTransform = !sources.isEmpty();
        return initTransform;
    }
}

