/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools;

import bdv.KeyConfigScopes;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import org.scijava.ui.behaviour.util.Actions;

public class CloseWindowActions {
    public static final String CLOSE_WINDOW = "close window";
    public static final String CLOSE_DIALOG = "close dialog window";
    public static final String[] CLOSE_WINDOW_KEYS = new String[]{"ctrl W", "meta W"};
    public static final String[] CLOSE_DIALOG_KEYS = new String[]{"ctrl W", "meta W", "ESCAPE"};

    public static void install(Actions actions, JFrame frame) {
        actions.namedAction((AbstractNamedAction)new CloseWindowAction(frame, CLOSE_WINDOW), CLOSE_WINDOW_KEYS);
    }

    public static void install(Actions actions, JDialog dialog) {
        actions.namedAction((AbstractNamedAction)new CloseWindowAction(dialog, CLOSE_DIALOG), CLOSE_DIALOG_KEYS);
    }

    private static class CloseWindowAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 1L;
        private final Window window;

        public CloseWindowAction(Window window, String name) {
            super(name);
            this.window = window;
        }

        public void actionPerformed(ActionEvent e) {
            this.window.dispatchEvent(new WindowEvent(this.window, 201));
        }
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(KeyConfigScopes.BIGDATAVIEWER, new String[]{"bdv"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(CloseWindowActions.CLOSE_WINDOW, CLOSE_WINDOW_KEYS, "Close the active window.");
            descriptions.add(CloseWindowActions.CLOSE_DIALOG, CLOSE_DIALOG_KEYS, "Close the active dialog.");
        }
    }
}

