/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.imaris;

import bdv.img.cache.CacheArrayLoader;
import bdv.img.imaris.IHDF5Access;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;

public class ImarisVolatileFloatArrayLoader
implements CacheArrayLoader<VolatileFloatArray> {
    private final IHDF5Access hdf5Access;

    public ImarisVolatileFloatArrayLoader(IHDF5Access hdf5Access) {
        this.hdf5Access = hdf5Access;
    }

    @Override
    public VolatileFloatArray loadArray(int timepoint, int setup, int level, int[] dimensions, long[] min) throws InterruptedException {
        float[] array = this.hdf5Access.readFloatMDArrayBlockWithOffset(timepoint, setup, level, dimensions, min);
        return new VolatileFloatArray(array, true);
    }

    @Override
    public int getBytesPerElement() {
        return 4;
    }
}

