/*
 * Decompiled with CFR 0.152.
 */
package bdv;

import bdv.KeyConfigScopes;
import bdv.TransformEventHandler;
import bdv.TransformState;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.ScrollBehaviour;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.Behaviours;

public class TransformEventHandler3D
implements TransformEventHandler {
    public static final String DRAG_TRANSLATE = "drag translate";
    public static final String ZOOM_NORMAL = "scroll zoom";
    public static final String SELECT_AXIS_X = "axis x";
    public static final String SELECT_AXIS_Y = "axis y";
    public static final String SELECT_AXIS_Z = "axis z";
    public static final String DRAG_ROTATE = "drag rotate";
    public static final String SCROLL_Z = "scroll browse z";
    public static final String ROTATE_LEFT = "rotate left";
    public static final String ROTATE_RIGHT = "rotate right";
    public static final String KEY_ZOOM_IN = "zoom in";
    public static final String KEY_ZOOM_OUT = "zoom out";
    public static final String KEY_FORWARD_Z = "forward z";
    public static final String KEY_BACKWARD_Z = "backward z";
    public static final String DRAG_ROTATE_FAST = "drag rotate fast";
    public static final String SCROLL_Z_FAST = "scroll browse z fast";
    public static final String ROTATE_LEFT_FAST = "rotate left fast";
    public static final String ROTATE_RIGHT_FAST = "rotate right fast";
    public static final String KEY_ZOOM_IN_FAST = "zoom in fast";
    public static final String KEY_ZOOM_OUT_FAST = "zoom out fast";
    public static final String KEY_FORWARD_Z_FAST = "forward z fast";
    public static final String KEY_BACKWARD_Z_FAST = "backward z fast";
    public static final String DRAG_ROTATE_SLOW = "drag rotate slow";
    public static final String SCROLL_Z_SLOW = "scroll browse z slow";
    public static final String ROTATE_LEFT_SLOW = "rotate left slow";
    public static final String ROTATE_RIGHT_SLOW = "rotate right slow";
    public static final String KEY_ZOOM_IN_SLOW = "zoom in slow";
    public static final String KEY_ZOOM_OUT_SLOW = "zoom out slow";
    public static final String KEY_FORWARD_Z_SLOW = "forward z slow";
    public static final String KEY_BACKWARD_Z_SLOW = "backward z slow";
    public static final String[] DRAG_TRANSLATE_KEYS = new String[]{"button2", "button3"};
    public static final String[] ZOOM_NORMAL_KEYS = new String[]{"meta scroll", "ctrl shift scroll"};
    public static final String[] SELECT_AXIS_X_KEYS = new String[]{"X"};
    public static final String[] SELECT_AXIS_Y_KEYS = new String[]{"Y"};
    public static final String[] SELECT_AXIS_Z_KEYS = new String[]{"Z"};
    public static final String[] DRAG_ROTATE_KEYS = new String[]{"button1"};
    public static final String[] SCROLL_Z_KEYS = new String[]{"scroll"};
    public static final String[] ROTATE_LEFT_KEYS = new String[]{"LEFT"};
    public static final String[] ROTATE_RIGHT_KEYS = new String[]{"RIGHT"};
    public static final String[] KEY_ZOOM_IN_KEYS = new String[]{"UP"};
    public static final String[] KEY_ZOOM_OUT_KEYS = new String[]{"DOWN"};
    public static final String[] KEY_FORWARD_Z_KEYS = new String[]{"COMMA"};
    public static final String[] KEY_BACKWARD_Z_KEYS = new String[]{"PERIOD"};
    public static final String[] DRAG_ROTATE_FAST_KEYS = new String[]{"shift button1"};
    public static final String[] SCROLL_Z_FAST_KEYS = new String[]{"shift scroll"};
    public static final String[] ROTATE_LEFT_FAST_KEYS = new String[]{"shift LEFT"};
    public static final String[] ROTATE_RIGHT_FAST_KEYS = new String[]{"shift RIGHT"};
    public static final String[] KEY_ZOOM_IN_FAST_KEYS = new String[]{"shift UP"};
    public static final String[] KEY_ZOOM_OUT_FAST_KEYS = new String[]{"shift DOWN"};
    public static final String[] KEY_FORWARD_Z_FAST_KEYS = new String[]{"shift COMMA"};
    public static final String[] KEY_BACKWARD_Z_FAST_KEYS = new String[]{"shift PERIOD"};
    public static final String[] DRAG_ROTATE_SLOW_KEYS = new String[]{"ctrl button1"};
    public static final String[] SCROLL_Z_SLOW_KEYS = new String[]{"ctrl scroll"};
    public static final String[] ROTATE_LEFT_SLOW_KEYS = new String[]{"ctrl LEFT"};
    public static final String[] ROTATE_RIGHT_SLOW_KEYS = new String[]{"ctrl RIGHT"};
    public static final String[] KEY_ZOOM_IN_SLOW_KEYS = new String[]{"ctrl UP"};
    public static final String[] KEY_ZOOM_OUT_SLOW_KEYS = new String[]{"ctrl DOWN"};
    public static final String[] KEY_FORWARD_Z_SLOW_KEYS = new String[]{"ctrl COMMA"};
    public static final String[] KEY_BACKWARD_Z_SLOW_KEYS = new String[]{"ctrl PERIOD"};
    private final TranslateXY dragTranslate;
    private final Zoom zoom;
    private final SelectRotationAxis selectRotationAxisX;
    private final SelectRotationAxis selectRotationAxisY;
    private final SelectRotationAxis selectRotationAxisZ;
    private final Rotate dragRotate;
    private final Rotate dragRotateFast;
    private final Rotate dragRotateSlow;
    private final TranslateZ translateZ;
    private final TranslateZ translateZFast;
    private final TranslateZ translateZSlow;
    private final KeyRotate rotateLeft;
    private final KeyRotate rotateLeftFast;
    private final KeyRotate rotateLeftSlow;
    private final KeyRotate rotateRight;
    private final KeyRotate rotateRightFast;
    private final KeyRotate rotateRightSlow;
    private final KeyZoom keyZoomIn;
    private final KeyZoom keyZoomInFast;
    private final KeyZoom keyZoomInSlow;
    private final KeyZoom keyZoomOut;
    private final KeyZoom keyZoomOutFast;
    private final KeyZoom keyZoomOutSlow;
    private final KeyTranslateZ keyForwardZ;
    private final KeyTranslateZ keyForwardZFast;
    private final KeyTranslateZ keyForwardZSlow;
    private final KeyTranslateZ keyBackwardZ;
    private final KeyTranslateZ keyBackwardZFast;
    private final KeyTranslateZ keyBackwardZSlow;
    private static final double[] speed = new double[]{1.0, 10.0, 0.1};
    private final AffineTransform3D affineDragStart = new AffineTransform3D();
    private final AffineTransform3D affineDragCurrent = new AffineTransform3D();
    private double oX;
    private double oY;
    private int axis = 0;
    private int canvasW = 1;
    private int canvasH = 1;
    private int centerX = 0;
    private int centerY = 0;
    private final TransformState transform;
    private static final double step = Math.PI / 180;

    public TransformEventHandler3D(TransformState transform) {
        this.transform = transform;
        this.dragTranslate = new TranslateXY();
        this.zoom = new Zoom();
        this.selectRotationAxisX = new SelectRotationAxis(0);
        this.selectRotationAxisY = new SelectRotationAxis(1);
        this.selectRotationAxisZ = new SelectRotationAxis(2);
        this.dragRotate = new Rotate(speed[0]);
        this.dragRotateFast = new Rotate(speed[1]);
        this.dragRotateSlow = new Rotate(speed[2]);
        this.translateZ = new TranslateZ(speed[0]);
        this.translateZFast = new TranslateZ(speed[1]);
        this.translateZSlow = new TranslateZ(speed[2]);
        this.rotateLeft = new KeyRotate(speed[0]);
        this.rotateLeftFast = new KeyRotate(speed[1]);
        this.rotateLeftSlow = new KeyRotate(speed[2]);
        this.rotateRight = new KeyRotate(-speed[0]);
        this.rotateRightFast = new KeyRotate(-speed[1]);
        this.rotateRightSlow = new KeyRotate(-speed[2]);
        this.keyZoomIn = new KeyZoom(speed[0]);
        this.keyZoomInFast = new KeyZoom(speed[1]);
        this.keyZoomInSlow = new KeyZoom(speed[2]);
        this.keyZoomOut = new KeyZoom(-speed[0]);
        this.keyZoomOutFast = new KeyZoom(-speed[1]);
        this.keyZoomOutSlow = new KeyZoom(-speed[2]);
        this.keyForwardZ = new KeyTranslateZ(speed[0]);
        this.keyForwardZFast = new KeyTranslateZ(speed[1]);
        this.keyForwardZSlow = new KeyTranslateZ(speed[2]);
        this.keyBackwardZ = new KeyTranslateZ(-speed[0]);
        this.keyBackwardZFast = new KeyTranslateZ(-speed[1]);
        this.keyBackwardZSlow = new KeyTranslateZ(-speed[2]);
    }

    @Override
    public void install(Behaviours behaviours) {
        behaviours.behaviour((Behaviour)this.dragTranslate, DRAG_TRANSLATE, DRAG_TRANSLATE_KEYS);
        behaviours.behaviour((Behaviour)this.zoom, ZOOM_NORMAL, ZOOM_NORMAL_KEYS);
        behaviours.behaviour((Behaviour)this.selectRotationAxisX, SELECT_AXIS_X, SELECT_AXIS_X_KEYS);
        behaviours.behaviour((Behaviour)this.selectRotationAxisY, SELECT_AXIS_Y, SELECT_AXIS_Y_KEYS);
        behaviours.behaviour((Behaviour)this.selectRotationAxisZ, SELECT_AXIS_Z, SELECT_AXIS_Z_KEYS);
        behaviours.behaviour((Behaviour)this.dragRotate, DRAG_ROTATE, DRAG_ROTATE_KEYS);
        behaviours.behaviour((Behaviour)this.dragRotateFast, DRAG_ROTATE_FAST, DRAG_ROTATE_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.dragRotateSlow, DRAG_ROTATE_SLOW, DRAG_ROTATE_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.translateZ, SCROLL_Z, SCROLL_Z_KEYS);
        behaviours.behaviour((Behaviour)this.translateZFast, SCROLL_Z_FAST, SCROLL_Z_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.translateZSlow, SCROLL_Z_SLOW, SCROLL_Z_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.rotateLeft, ROTATE_LEFT, ROTATE_LEFT_KEYS);
        behaviours.behaviour((Behaviour)this.rotateLeftFast, ROTATE_LEFT_FAST, ROTATE_LEFT_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.rotateLeftSlow, ROTATE_LEFT_SLOW, ROTATE_LEFT_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.rotateRight, ROTATE_RIGHT, ROTATE_RIGHT_KEYS);
        behaviours.behaviour((Behaviour)this.rotateRightFast, ROTATE_RIGHT_FAST, ROTATE_RIGHT_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.rotateRightSlow, ROTATE_RIGHT_SLOW, ROTATE_RIGHT_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomIn, KEY_ZOOM_IN, KEY_ZOOM_IN_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomInFast, KEY_ZOOM_IN_FAST, KEY_ZOOM_IN_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomInSlow, KEY_ZOOM_IN_SLOW, KEY_ZOOM_IN_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomOut, KEY_ZOOM_OUT, KEY_ZOOM_OUT_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomOutFast, KEY_ZOOM_OUT_FAST, KEY_ZOOM_OUT_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.keyZoomOutSlow, KEY_ZOOM_OUT_SLOW, KEY_ZOOM_OUT_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.keyForwardZ, KEY_FORWARD_Z, KEY_FORWARD_Z_KEYS);
        behaviours.behaviour((Behaviour)this.keyForwardZFast, KEY_FORWARD_Z_FAST, KEY_FORWARD_Z_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.keyForwardZSlow, KEY_FORWARD_Z_SLOW, KEY_FORWARD_Z_SLOW_KEYS);
        behaviours.behaviour((Behaviour)this.keyBackwardZ, KEY_BACKWARD_Z, KEY_BACKWARD_Z_KEYS);
        behaviours.behaviour((Behaviour)this.keyBackwardZFast, KEY_BACKWARD_Z_FAST, KEY_BACKWARD_Z_FAST_KEYS);
        behaviours.behaviour((Behaviour)this.keyBackwardZSlow, KEY_BACKWARD_Z_SLOW, KEY_BACKWARD_Z_SLOW_KEYS);
    }

    @Override
    public void setCanvasSize(int width, int height, boolean updateTransform) {
        if (width == 0 || height == 0) {
            return;
        }
        if (updateTransform) {
            AffineTransform3D affine = this.transform.get();
            affine.set(affine.get(0, 3) - (double)(this.canvasW / 2), 0, 3);
            affine.set(affine.get(1, 3) - (double)(this.canvasH / 2), 1, 3);
            affine.scale((double)width / (double)this.canvasW);
            affine.set(affine.get(0, 3) + (double)(width / 2), 0, 3);
            affine.set(affine.get(1, 3) + (double)(height / 2), 1, 3);
            this.transform.set(affine);
        }
        this.canvasW = width;
        this.canvasH = height;
        this.centerX = width / 2;
        this.centerY = height / 2;
    }

    private void scale(double s, double x, double y) {
        AffineTransform3D affine = this.transform.get();
        affine.set(affine.get(0, 3) - x, 0, 3);
        affine.set(affine.get(1, 3) - y, 1, 3);
        affine.scale(s);
        affine.set(affine.get(0, 3) + x, 0, 3);
        affine.set(affine.get(1, 3) + y, 1, 3);
        this.transform.set(affine);
    }

    private void rotate(int axis, double d) {
        AffineTransform3D affine = this.transform.get();
        affine.set(affine.get(0, 3) - (double)this.centerX, 0, 3);
        affine.set(affine.get(1, 3) - (double)this.centerY, 1, 3);
        affine.rotate(axis, d);
        affine.set(affine.get(0, 3) + (double)this.centerX, 0, 3);
        affine.set(affine.get(1, 3) + (double)this.centerY, 1, 3);
        this.transform.set(affine);
    }

    private class KeyTranslateZ
    implements ClickBehaviour {
        private final double speed;

        public KeyTranslateZ(double speed) {
            this.speed = speed;
        }

        public void click(int x, int y) {
            AffineTransform3D affine = TransformEventHandler3D.this.transform.get();
            affine.set(affine.get(2, 3) + this.speed, 2, 3);
            TransformEventHandler3D.this.transform.set(affine);
        }
    }

    private class KeyZoom
    implements ClickBehaviour {
        private final double dScale;

        public KeyZoom(double speed) {
            this.dScale = speed > 0.0 ? 1.0 + 0.1 * speed : 1.0 / (1.0 - 0.1 * speed);
        }

        public void click(int x, int y) {
            TransformEventHandler3D.this.scale(this.dScale, TransformEventHandler3D.this.centerX, TransformEventHandler3D.this.centerY);
        }
    }

    private class KeyRotate
    implements ClickBehaviour {
        private final double speed;

        public KeyRotate(double speed) {
            this.speed = speed;
        }

        public void click(int x, int y) {
            TransformEventHandler3D.this.rotate(TransformEventHandler3D.this.axis, Math.PI / 180 * this.speed);
        }
    }

    private class SelectRotationAxis
    implements ClickBehaviour {
        private final int axis;

        public SelectRotationAxis(int axis) {
            this.axis = axis;
        }

        public void click(int x, int y) {
            TransformEventHandler3D.this.axis = this.axis;
        }
    }

    private class Zoom
    implements ScrollBehaviour {
        private final double speed = 1.0;

        private Zoom() {
        }

        public void scroll(double wheelRotation, boolean isHorizontal, int x, int y) {
            double s = 1.0 * wheelRotation;
            double dScale = 1.05;
            if (s > 0.0) {
                TransformEventHandler3D.this.scale(0.9523809523809523, x, y);
            } else {
                TransformEventHandler3D.this.scale(1.05, x, y);
            }
        }
    }

    private class TranslateZ
    implements ScrollBehaviour {
        private final double speed;

        public TranslateZ(double speed) {
            this.speed = speed;
        }

        public void scroll(double wheelRotation, boolean isHorizontal, int x, int y) {
            AffineTransform3D affine = TransformEventHandler3D.this.transform.get();
            double dZ = this.speed * -wheelRotation;
            affine.set(affine.get(2, 3) - dZ, 2, 3);
            TransformEventHandler3D.this.transform.set(affine);
        }
    }

    private class TranslateXY
    implements DragBehaviour {
        private TranslateXY() {
        }

        public void init(int x, int y) {
            TransformEventHandler3D.this.oX = x;
            TransformEventHandler3D.this.oY = y;
            TransformEventHandler3D.this.transform.get(TransformEventHandler3D.this.affineDragStart);
        }

        public void drag(int x, int y) {
            double dX = TransformEventHandler3D.this.oX - (double)x;
            double dY = TransformEventHandler3D.this.oY - (double)y;
            TransformEventHandler3D.this.affineDragCurrent.set(TransformEventHandler3D.this.affineDragStart);
            TransformEventHandler3D.this.affineDragCurrent.set(TransformEventHandler3D.this.affineDragCurrent.get(0, 3) - dX, 0, 3);
            TransformEventHandler3D.this.affineDragCurrent.set(TransformEventHandler3D.this.affineDragCurrent.get(1, 3) - dY, 1, 3);
            TransformEventHandler3D.this.transform.set(TransformEventHandler3D.this.affineDragCurrent);
        }

        public void end(int x, int y) {
        }
    }

    private class Rotate
    implements DragBehaviour {
        private final double speed;

        public Rotate(double speed) {
            this.speed = speed;
        }

        public void init(int x, int y) {
            TransformEventHandler3D.this.oX = x;
            TransformEventHandler3D.this.oY = y;
            TransformEventHandler3D.this.transform.get(TransformEventHandler3D.this.affineDragStart);
        }

        public void drag(int x, int y) {
            double dX = TransformEventHandler3D.this.oX - (double)x;
            double dY = TransformEventHandler3D.this.oY - (double)y;
            TransformEventHandler3D.this.affineDragCurrent.set(TransformEventHandler3D.this.affineDragStart);
            TransformEventHandler3D.this.affineDragCurrent.set(TransformEventHandler3D.this.affineDragCurrent.get(0, 3) - TransformEventHandler3D.this.oX, 0, 3);
            TransformEventHandler3D.this.affineDragCurrent.set(TransformEventHandler3D.this.affineDragCurrent.get(1, 3) - TransformEventHandler3D.this.oY, 1, 3);
            double v = Math.PI / 180 * this.speed;
            TransformEventHandler3D.this.affineDragCurrent.rotate(0, -dY * v);
            TransformEventHandler3D.this.affineDragCurrent.rotate(1, dX * v);
            TransformEventHandler3D.this.affineDragCurrent.set(TransformEventHandler3D.this.affineDragCurrent.get(0, 3) + TransformEventHandler3D.this.oX, 0, 3);
            TransformEventHandler3D.this.affineDragCurrent.set(TransformEventHandler3D.this.affineDragCurrent.get(1, 3) + TransformEventHandler3D.this.oY, 1, 3);
            TransformEventHandler3D.this.transform.set(TransformEventHandler3D.this.affineDragCurrent);
        }

        public void end(int x, int y) {
        }
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(KeyConfigScopes.BIGDATAVIEWER, new String[]{"bdv"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(TransformEventHandler3D.DRAG_TRANSLATE, DRAG_TRANSLATE_KEYS, "Pan the view by mouse-dragging.");
            descriptions.add(TransformEventHandler3D.ZOOM_NORMAL, ZOOM_NORMAL_KEYS, "Zoom in by scrolling.");
            descriptions.add(TransformEventHandler3D.SELECT_AXIS_X, SELECT_AXIS_X_KEYS, "Select X as the rotation axis for keyboard rotation.");
            descriptions.add(TransformEventHandler3D.SELECT_AXIS_Y, SELECT_AXIS_Y_KEYS, "Select Y as the rotation axis for keyboard rotation.");
            descriptions.add(TransformEventHandler3D.SELECT_AXIS_Z, SELECT_AXIS_Z_KEYS, "Select Z as the rotation axis for keyboard rotation.");
            descriptions.add(TransformEventHandler3D.DRAG_ROTATE, DRAG_ROTATE_KEYS, "Rotate the view by mouse-dragging.");
            descriptions.add(TransformEventHandler3D.SCROLL_Z, SCROLL_Z_KEYS, "Translate in Z by scrolling.");
            descriptions.add(TransformEventHandler3D.ROTATE_LEFT, ROTATE_LEFT_KEYS, "Rotate left (counter-clockwise) by 1 degree.");
            descriptions.add(TransformEventHandler3D.ROTATE_RIGHT, ROTATE_RIGHT_KEYS, "Rotate right (clockwise) by 1 degree.");
            descriptions.add(TransformEventHandler3D.KEY_ZOOM_IN, KEY_ZOOM_IN_KEYS, "Zoom in.");
            descriptions.add(TransformEventHandler3D.KEY_ZOOM_OUT, KEY_ZOOM_OUT_KEYS, "Zoom out.");
            descriptions.add(TransformEventHandler3D.KEY_FORWARD_Z, KEY_FORWARD_Z_KEYS, "Translate forward in Z.");
            descriptions.add(TransformEventHandler3D.KEY_BACKWARD_Z, KEY_BACKWARD_Z_KEYS, "Translate backward in Z.");
            descriptions.add(TransformEventHandler3D.DRAG_ROTATE_FAST, DRAG_ROTATE_FAST_KEYS, "Rotate the view by mouse-dragging (fast).");
            descriptions.add(TransformEventHandler3D.SCROLL_Z_FAST, SCROLL_Z_FAST_KEYS, "Translate in Z by scrolling (fast).");
            descriptions.add(TransformEventHandler3D.ROTATE_LEFT_FAST, ROTATE_LEFT_FAST_KEYS, "Rotate left (counter-clockwise) by 10 degrees.");
            descriptions.add(TransformEventHandler3D.ROTATE_RIGHT_FAST, ROTATE_RIGHT_FAST_KEYS, "Rotate right (clockwise) by 10 degrees.");
            descriptions.add(TransformEventHandler3D.KEY_ZOOM_IN_FAST, KEY_ZOOM_IN_FAST_KEYS, "Zoom in (fast).");
            descriptions.add(TransformEventHandler3D.KEY_ZOOM_OUT_FAST, KEY_ZOOM_OUT_FAST_KEYS, "Zoom out (fast).");
            descriptions.add(TransformEventHandler3D.KEY_FORWARD_Z_FAST, KEY_FORWARD_Z_FAST_KEYS, "Translate forward in Z (fast).");
            descriptions.add(TransformEventHandler3D.KEY_BACKWARD_Z_FAST, KEY_BACKWARD_Z_FAST_KEYS, "Translate backward in Z (fast).");
            descriptions.add(TransformEventHandler3D.DRAG_ROTATE_SLOW, DRAG_ROTATE_SLOW_KEYS, "Rotate the view by mouse-dragging (slow).");
            descriptions.add(TransformEventHandler3D.SCROLL_Z_SLOW, SCROLL_Z_SLOW_KEYS, "Translate in Z by scrolling (slow).");
            descriptions.add(TransformEventHandler3D.ROTATE_LEFT_SLOW, ROTATE_LEFT_SLOW_KEYS, "Rotate left (counter-clockwise) by 0.1 degree.");
            descriptions.add(TransformEventHandler3D.ROTATE_RIGHT_SLOW, ROTATE_RIGHT_SLOW_KEYS, "Rotate right (clockwise) by 0.1 degree.");
            descriptions.add(TransformEventHandler3D.KEY_ZOOM_IN_SLOW, KEY_ZOOM_IN_SLOW_KEYS, "Zoom in (slow).");
            descriptions.add(TransformEventHandler3D.KEY_ZOOM_OUT_SLOW, KEY_ZOOM_OUT_SLOW_KEYS, "Zoom out (slow).");
            descriptions.add(TransformEventHandler3D.KEY_FORWARD_Z_SLOW, KEY_FORWARD_Z_SLOW_KEYS, "Translate forward in Z (slow).");
            descriptions.add(TransformEventHandler3D.KEY_BACKWARD_Z_SLOW, KEY_BACKWARD_Z_SLOW_KEYS, "Translate backward in Z (slow).");
        }
    }
}

