/*
 * Decompiled with CFR 0.152.
 */
package octree;

import ij3d.AxisConstants;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import octree.Cube;
import octree.ShapeGroup;
import org.jogamp.java3d.TexCoordGeneration;
import org.jogamp.vecmath.Vector4f;

public class CubeData
implements AxisConstants {
    private static final int SIZE = 128;
    private static final int B_IMG_TYPE = 10;
    final float[] cal = new float[3];
    final float[] min = new float[3];
    final float[] max = new float[3];
    BufferedImage[] images;
    private final TexCoordGeneration tgx;
    private final TexCoordGeneration tgy;
    private final TexCoordGeneration tgz;
    int axis;
    TexCoordGeneration tg;
    ShapeGroup[] shapes;
    Cube cube;

    public CubeData(Cube c) {
        this.cube = c;
        CubeData.readCalibration(c.dir + c.name + ".info", this.cal);
        this.min[0] = (float)c.x * c.octree.pw;
        this.min[1] = (float)c.y * c.octree.ph;
        this.min[2] = (float)c.z * c.octree.pd;
        this.max[0] = this.min[0] + 128.0f * this.cal[0];
        this.max[1] = this.min[1] + 128.0f * this.cal[1];
        this.max[2] = this.min[2] + 128.0f * this.cal[2];
        float xTexGenScale = (float)(1.0 / (double)(this.cal[0] * 128.0f));
        float yTexGenScale = (float)(1.0 / (double)(this.cal[1] * 128.0f));
        float zTexGenScale = (float)(1.0 / (double)(this.cal[2] * 128.0f));
        this.tgz = new TexCoordGeneration();
        this.tgz.setPlaneS(new Vector4f(xTexGenScale, 0.0f, 0.0f, -(xTexGenScale * this.min[0])));
        this.tgz.setPlaneT(new Vector4f(0.0f, yTexGenScale, 0.0f, -(yTexGenScale * this.min[1])));
        this.tgx = new TexCoordGeneration();
        this.tgx.setPlaneS(new Vector4f(0.0f, yTexGenScale, 0.0f, -(yTexGenScale * this.min[1])));
        this.tgx.setPlaneT(new Vector4f(0.0f, 0.0f, zTexGenScale, -(zTexGenScale * this.min[2])));
        this.tgy = new TexCoordGeneration();
        this.tgy.setPlaneS(new Vector4f(xTexGenScale, 0.0f, 0.0f, -(xTexGenScale * this.min[0])));
        this.tgy.setPlaneT(new Vector4f(0.0f, 0.0f, zTexGenScale, -(zTexGenScale * this.min[2])));
        this.shapes = new ShapeGroup[128];
        for (int i = 0; i < 128; ++i) {
            this.shapes[i] = new ShapeGroup();
        }
        this.images = new BufferedImage[128];
    }

    public void prepareForAxis(int axis) {
        this.axis = axis;
        for (int i = 0; i < 128; ++i) {
            this.shapes[i].prepareForAxis(this.min[axis] + this.cal[axis] * (float)i);
        }
        switch (axis) {
            case 0: {
                this.tg = this.tgx;
                break;
            }
            case 1: {
                this.tg = this.tgy;
                break;
            }
            case 2: {
                this.tg = this.tgz;
            }
        }
    }

    public void show() {
        try {
            this.createData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < 128; ++i) {
            this.shapes[i].show(this, i);
        }
    }

    public void hide() {
        for (int i = 0; i < 128; ++i) {
            this.shapes[i].hide();
        }
        this.releaseData();
    }

    private void createData() throws IOException {
        switch (this.axis) {
            case 0: {
                this.createImages(this.cube.dir + "/x/" + this.cube.name);
                break;
            }
            case 1: {
                this.createImages(this.cube.dir + "/y/" + this.cube.name);
                break;
            }
            case 2: {
                this.createImages(this.cube.dir + "/z/" + this.cube.name);
            }
        }
    }

    private void releaseData() {
        for (int i = 0; i < 128; ++i) {
            this.images[i] = null;
        }
        this.tg = null;
    }

    public static final float[] readCalibration(String path, float[] ret) {
        if (ret == null) {
            ret = new float[3];
        }
        File f = new File(path);
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(f));
            if (in == null) {
                return null;
            }
            ret[0] = in.readFloat();
            ret[1] = in.readFloat();
            ret[2] = in.readFloat();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return ret;
    }

    private void createImages(String path) throws IOException {
        DataInputStream is = new DataInputStream(new FileInputStream(path));
        for (int i = 0; i < 128; ++i) {
            this.images[i] = new BufferedImage(128, 128, 10);
            byte[] pixels = ((DataBufferByte)this.images[i].getRaster().getDataBuffer()).getData();
            is.readFully(pixels);
        }
        is.close();
    }
}

