/*
 * Decompiled with CFR 0.152.
 */
package customnode;

import customnode.CustomMesh;
import isosurface.MeshProperties;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.utils.geometry.GeometryInfo;
import org.jogamp.java3d.utils.geometry.NormalGenerator;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Point2d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;

public class CustomTriangleMesh
extends CustomMesh {
    private double volume = 0.0;
    private final Point3f[] threePoints = new Point3f[3];
    private final int[] threeIndices = new int[3];
    private final Point2d p2d = new Point2d();

    public CustomTriangleMesh(List<Point3f> mesh) {
        this(mesh, DEFAULT_COLOR, 0.0f);
    }

    public CustomTriangleMesh(List<Point3f> mesh, Color3f col, float trans) {
        super(mesh, col, trans);
        if (mesh != null) {
            Point3d center = new Point3d();
            double[][] inertia = new double[3][3];
            this.volume = MeshProperties.compute(mesh, center, inertia);
        }
    }

    public void setMesh(List<Point3f> mesh) {
        this.mesh = mesh;
        this.update();
    }

    public void addTriangles(Point3f[] v) {
        if (v.length % 3 != 0) {
            throw new IllegalArgumentException("Number must be a multiple of 3");
        }
        this.addVertices(v);
    }

    public void addTriangle(Point3f p1, Point3f p2, Point3f p3) {
        this.threePoints[0] = p1;
        this.threePoints[1] = p2;
        this.threePoints[2] = p3;
        this.addVertices(this.threePoints);
    }

    public void removeTriangle(int index) {
        int offs;
        this.threeIndices[0] = offs = 3 * index;
        this.threeIndices[1] = offs + 1;
        this.threeIndices[2] = offs + 2;
        this.removeVertices(this.threeIndices);
    }

    public void removeTriangles(int[] indices) {
        Arrays.sort(indices);
        int[] vIndices = new int[indices.length * 3];
        int j = 0;
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            int offs = 3 * index;
            vIndices[j++] = offs;
            vIndices[j++] = offs + 1;
            vIndices[j++] = offs + 2;
        }
        this.removeVertices(vIndices);
    }

    @Override
    protected GeometryArray createGeometry() {
        if (this.mesh == null || this.mesh.size() < 3) {
            return null;
        }
        List tri = this.mesh;
        int nValid = tri.size();
        int nAll = 2 * nValid;
        Point3f[] coords = new Point3f[nValid];
        tri.toArray(coords);
        Object[] colors = new Color3f[nValid];
        if (null == this.color) {
            for (int i = 0; i < colors.length; ++i) {
                colors[i] = new Color3f(DEFAULT_COLOR);
            }
            GeometryArray gaOld = (GeometryArray)this.getGeometry();
            if (null != gaOld) {
                gaOld.getColors(0, (Color3f[])colors);
            }
        } else {
            Arrays.fill(colors, this.color);
        }
        TriangleArray ta = new TriangleArray(nAll, 7);
        ta.setCoordinates(0, coords);
        ta.setColors(0, (Color3f[])colors);
        GeometryInfo gi = new GeometryInfo((GeometryArray)ta);
        NormalGenerator ng = new NormalGenerator();
        ng.generateNormals(gi);
        GeometryArray result = gi.getGeometryArray();
        result.setCapability(5);
        result.setCapability(3);
        result.setCapability(1);
        result.setCapability(20);
        result.setCapability(8);
        result.setCapability(17);
        result.setCapability(18);
        result.setValidVertexCount(nValid);
        return result;
    }

    private boolean roiContains(Point3f p, Transform3D volToIP, Canvas3D canvas, Polygon polygon) {
        Point3d locInImagePlate = new Point3d(p);
        volToIP.transform(locInImagePlate);
        canvas.getPixelLocationFromImagePlate(locInImagePlate, this.p2d);
        return polygon.contains(this.p2d.x, this.p2d.y);
    }

    public void retain(Canvas3D canvas, Polygon polygon) {
        Transform3D volToIP = new Transform3D();
        canvas.getImagePlateToVworld(volToIP);
        volToIP.invert();
        Transform3D toVWorld = new Transform3D();
        this.getLocalToVworld(toVWorld);
        volToIP.mul(toVWorld);
        ArrayList<Point3f> f = new ArrayList<Point3f>();
        for (int i = 0; i < this.mesh.size(); i += 3) {
            Point3f p1 = (Point3f)this.mesh.get(i);
            Point3f p2 = (Point3f)this.mesh.get(i + 1);
            Point3f p3 = (Point3f)this.mesh.get(i + 2);
            if (!this.roiContains(p1, volToIP, canvas, polygon) && !this.roiContains(p2, volToIP, canvas, polygon) && !this.roiContains(p3, volToIP, canvas, polygon)) continue;
            f.add(p1);
            f.add(p2);
            f.add(p3);
        }
        this.mesh.clear();
        this.mesh.addAll(f);
        this.update();
    }

    @Override
    public float getVolume() {
        return (float)this.volume;
    }
}

