/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.sat;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.sat.BoundingBoxHelper;

public class MSGnavigation
extends ProjectionImpl {
    public static final String HEIGHT_FROM_EARTH_CENTER = "height_from_earth_center";
    public static final String SCALE_X = "scale_x";
    public static final String SCALE_Y = "scale_y";
    private static final double SAT_HEIGHT = 42164.0;
    private static final double R_EQ = 6378.169;
    private static final double R_POL = 6356.5838;
    private static final double SUB_LON = 0.0;
    private double lat0;
    private double lon0;
    private double major_axis;
    private double minor_axis;
    private double sat_height;
    private double scale_x;
    private double scale_y;
    private double const1;
    private double const2;
    private double const3;
    private double maxR;

    public MSGnavigation() {
        this(0.0, 0.0, 6378.169, 6356.5838, 42164.0, 35785.831, 35785.831);
    }

    public MSGnavigation(double lat0, double lon0, double major_axis, double minor_axis, double sat_height, double scale_x, double scale_y) {
        super("MSGnavigation", false);
        this.lon0 = Math.toRadians(lon0);
        this.major_axis = 0.001 * major_axis;
        this.minor_axis = 0.001 * minor_axis;
        this.sat_height = 0.001 * sat_height;
        this.scale_x = scale_x;
        this.scale_y = scale_y;
        this.const1 = major_axis / minor_axis;
        this.const1 *= this.const1;
        this.const2 = 1.0 - minor_axis * minor_axis / (major_axis * major_axis);
        this.const3 = this.sat_height * this.sat_height - this.major_axis * this.major_axis;
        double P = sat_height / major_axis;
        this.maxR = 0.99 * this.major_axis * Math.sqrt((P - 1.0) / (P + 1.0));
        this.addParameter("grid_mapping_name", "MSGnavigation");
        this.addParameter("longitude_of_projection_origin", lon0);
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("semi_major_axis", major_axis);
        this.addParameter("semi_minor_axis", minor_axis);
        this.addParameter(HEIGHT_FROM_EARTH_CENTER, sat_height);
        this.addParameter(SCALE_X, scale_x);
        this.addParameter(SCALE_Y, scale_y);
    }

    @Override
    public String toString() {
        return "MSGnavigation{lat0=" + this.lat0 + ", lon0=" + this.lon0 + ", major_axis=" + this.major_axis + ", minor_axis=" + this.minor_axis + ", sat_height=" + this.sat_height + ", scale_x=" + this.scale_x + ", scale_y=" + this.scale_y + '}';
    }

    private int pixcoord2geocoord(double xkm, double ykm, LatLonPointImpl result) {
        double xrad = xkm / this.scale_x;
        double yrad = ykm / this.scale_y;
        double cosx = Math.cos(xrad);
        double cosy = Math.cos(yrad);
        double siny = Math.sin(yrad);
        double sa = Math.pow(this.sat_height * cosx * cosy, 2.0) - (cosy * cosy + this.const1 * siny * siny) * this.const3;
        if (sa <= 0.0) {
            result.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            return -1;
        }
        double sd = Math.sqrt(sa);
        double sn = (this.sat_height * cosx * cosy - sd) / (cosy * cosy + this.const1 * siny * siny);
        double s1 = this.sat_height - sn * cosx * cosy;
        double s2 = sn * Math.sin(xrad) * cosy;
        double s3 = -sn * siny;
        double sxy = Math.sqrt(s1 * s1 + s2 * s2);
        double longi = Math.atan(s2 / s1) + this.lon0;
        double lati = Math.atan(this.const1 * s3 / sxy);
        result.setLatitude(Math.toDegrees(lati));
        result.setLongitude(Math.toDegrees(longi));
        return 0;
    }

    private int geocoord2pixcoord(double latitude, double longitude, ProjectionPointImpl result) {
        if (latitude < -90.0 || latitude > 90.0 || longitude < -180.0 || longitude > 180.0) {
            result.setLocation(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            return -1;
        }
        double lat = Math.toRadians(latitude);
        double lon = Math.toRadians(longitude) - this.lon0;
        double cosLon = Math.cos(lon);
        double c_lat = Math.atan(Math.tan(lat) / this.const1);
        double coscLat = Math.cos(c_lat);
        double re = this.minor_axis / Math.sqrt(1.0 - this.const2 * coscLat * coscLat);
        double r1 = this.sat_height - re * coscLat * cosLon;
        double r2 = -re * coscLat * Math.sin(lon);
        double r3 = re * Math.sin(c_lat);
        double rn = Math.sqrt(r1 * r1 + r2 * r2 + r3 * r3);
        double dotprod = r1 * (re * coscLat * cosLon) - r2 * r2 - r3 * r3 * this.const1;
        if (dotprod <= 0.0) {
            result.setLocation(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            return -1;
        }
        double xx = Math.atan(-r2 / r1);
        double yy = Math.asin(-r3 / rn);
        result.setLocation(this.scale_x * xx, this.scale_y * yy);
        return 0;
    }

    @Override
    public ProjectionImpl constructCopy() {
        MSGnavigation result = new MSGnavigation(this.lat0, Math.toDegrees(this.lon0), 1000.0 * this.major_axis, 1000.0 * this.minor_axis, 1000.0 * this.sat_height, this.scale_x, this.scale_y);
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    @Override
    public String paramsToString() {
        return "";
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl destPoint) {
        this.geocoord2pixcoord(latlon.getLatitude(), latlon.getLongitude(), destPoint);
        return destPoint;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl destPoint) {
        this.pixcoord2geocoord(ppt.getX(), ppt.getY(), destPoint);
        return destPoint;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        if (LatLonPoints.isInfinite(pt1) || LatLonPoints.isInfinite(pt2)) {
            return true;
        }
        return pt1.getX() * pt2.getX() < 0.0 && Math.abs(pt1.getX() - pt2.getX()) > 100.0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSGnavigation that = (MSGnavigation)o;
        if (Double.compare(that.lat0, this.lat0) != 0) {
            return false;
        }
        if (Double.compare(that.lon0, this.lon0) != 0) {
            return false;
        }
        if (Double.compare(that.major_axis, this.major_axis) != 0) {
            return false;
        }
        if (Double.compare(that.minor_axis, this.minor_axis) != 0) {
            return false;
        }
        if (Double.compare(that.sat_height, this.sat_height) != 0) {
            return false;
        }
        if (Double.compare(that.scale_x, this.scale_x) != 0) {
            return false;
        }
        return Double.compare(that.scale_y, this.scale_y) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.lat0);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon0);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.major_axis);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minor_axis);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.sat_height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.scale_x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.scale_y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public ProjectionRect latLonToProjBB(LatLonRect rect) {
        BoundingBoxHelper bbhelper = new BoundingBoxHelper(this, this.maxR);
        return bbhelper.latLonToProjBB(rect);
    }

    public double getLon0() {
        return this.lon0;
    }
}

