/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.type;

import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.integer.ByteType;
import mpicbg.imglib.type.numeric.integer.IntType;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.integer.ShortType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.integer.UnsignedShortType;
import mpicbg.imglib.type.numeric.real.FloatType;

public abstract class TypeConverter {
    public abstract void convert();

    public static <A extends Type<A>, B extends Type<B>> TypeConverter getTypeConverter(A input, B output) {
        if (input instanceof ByteType) {
            return TypeConverter.getTypeConverter((ByteType)input, output);
        }
        if (input instanceof UnsignedByteType) {
            return TypeConverter.getTypeConverter((UnsignedByteType)input, output);
        }
        if (input instanceof ShortType) {
            return TypeConverter.getTypeConverter((ShortType)input, output);
        }
        if (input instanceof UnsignedShortType) {
            return TypeConverter.getTypeConverter((UnsignedShortType)input, output);
        }
        System.out.println("mpi.imglib.type.TypeConverter(): Do not know how to convert Type " + input.getClass());
        return null;
    }

    public static <A extends Type<A>> TypeConverter getTypeConverter(final ByteType in, A output) {
        if (ByteType.class.isInstance(output)) {
            final ByteType out = (ByteType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in);
                }
            };
        }
        if (ShortType.class.isInstance(output)) {
            final ShortType out = (ShortType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set((short)(in.get() & 0xFF));
                }
            };
        }
        if (IntType.class.isInstance(output)) {
            final IntType out = (IntType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in.get() & 0xFF);
                }
            };
        }
        if (LongType.class.isInstance(output)) {
            final IntType out = (IntType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in.get() & 0xFF);
                }
            };
        }
        if (FloatType.class.isInstance(output)) {
            final FloatType out = (FloatType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in.get() & 0xFF);
                }
            };
        }
        System.out.println("mpi.imglib.type.TypeConverter(): Do not know how to convert Type ByteType to Type " + output.getClass());
        return null;
    }

    public static <A extends Type<A>> TypeConverter getTypeConverter(final UnsignedByteType in, A output) {
        if (UnsignedByteType.class.isInstance(output)) {
            final UnsignedByteType out = (UnsignedByteType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in);
                }
            };
        }
        if (ShortType.class.isInstance(output)) {
            final ShortType out = (ShortType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set((short)in.get());
                }
            };
        }
        if (IntType.class.isInstance(output)) {
            final IntType out = (IntType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in.get());
                }
            };
        }
        if (LongType.class.isInstance(output)) {
            final IntType out = (IntType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in.get());
                }
            };
        }
        if (FloatType.class.isInstance(output)) {
            final FloatType out = (FloatType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in.get());
                }
            };
        }
        System.out.println("mpi.imglib.type.TypeConverter(): Do not know how to convert Type UnsignedByteType to Type " + output.getClass());
        return null;
    }

    public static <A extends Type<A>> TypeConverter getTypeConverter(final ShortType in, A output) {
        if (ShortType.class.isInstance(output)) {
            final ShortType out = (ShortType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in);
                }
            };
        }
        if (FloatType.class.isInstance(output)) {
            final FloatType out = (FloatType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in.get() & 0xFFFF);
                }
            };
        }
        System.out.println("mpi.imglib.type.TypeConverter(): Do not know how to convert Type ShortType to Type " + output.getClass());
        return null;
    }

    public static <A extends Type<A>> TypeConverter getTypeConverter(final UnsignedShortType in, A output) {
        if (UnsignedShortType.class.isInstance(output)) {
            final UnsignedShortType out = (UnsignedShortType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in);
                }
            };
        }
        if (FloatType.class.isInstance(output)) {
            final FloatType out = (FloatType)output;
            return new TypeConverter(){

                @Override
                public final void convert() {
                    out.set(in.get());
                }
            };
        }
        System.out.println("mpi.imglib.type.TypeConverter(): Do not know how to convert Type UnsignedShortType to Type " + output.getClass());
        return null;
    }
}

