/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import mpicbg.imglib.container.basictypecontainer.LongAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

public class NIOLongArray
implements ArrayDataAccess<NIOLongArray>,
LongAccess {
    protected LongBuffer data;

    public NIOLongArray(int numEntities) {
        this.data = ByteBuffer.allocateDirect(numEntities * 8).order(ByteOrder.nativeOrder()).asLongBuffer();
    }

    public NIOLongArray(long[] data) {
        LongBuffer bufferIn = LongBuffer.wrap(data);
        LongBuffer copy = ByteBuffer.allocateDirect(bufferIn.capacity()).order(ByteOrder.nativeOrder()).asLongBuffer();
        this.data = copy.put(bufferIn);
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public long getValue(int index) {
        return this.data.get(index);
    }

    @Override
    public void setValue(int index, long value) {
        this.data.put(index, value);
    }

    public long[] getCurrentStorageArray() {
        long[] outData = new long[this.data.capacity()];
        this.data.get(outData);
        return outData;
    }

    @Override
    public NIOLongArray createArray(int numEntities) {
        return new NIOLongArray(numEntities);
    }
}

