/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.transformation;

import java.util.ArrayList;
import java.util.Arrays;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.math.PickImagePeaks;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;

public abstract class HoughTransform<S extends RealType<S>, T extends Type<T> & Comparable<T>>
implements OutputAlgorithm<S>,
Benchmark {
    protected long pTime;
    private String errorMsg;
    private final Image<T> image;
    private final Image<S> voteSpace;
    private LocalizableByDimCursor<S> voteCursor;
    private ArrayList<int[]> peaks;
    private final double[] peakExclusion;
    private final S one;

    protected HoughTransform(Image<T> inputImage, int[] voteSize, S type) {
        this(inputImage, voteSize, new ImageFactory<S>(type, new ArrayContainerFactory()));
    }

    protected HoughTransform(Image<T> inputImage, int[] voteSize, ImageFactory<S> voteFactory) {
        this.image = inputImage;
        this.voteCursor = null;
        this.pTime = 0L;
        this.voteSpace = voteFactory.createImage(voteSize);
        this.peaks = null;
        this.peakExclusion = new double[voteSize.length];
        this.one = (RealType)this.voteSpace.createType();
        this.one.setOne();
        Arrays.fill(this.peakExclusion, 0.0);
    }

    protected boolean placeVote(int[] loc, S vote) {
        if (this.voteCursor == null) {
            this.voteCursor = this.voteSpace.createLocalizableByDimCursor();
        }
        this.voteCursor.setPosition(loc);
        ((RealType)this.voteCursor.getType()).add(vote);
        return true;
    }

    protected boolean placeVote(int[] loc) {
        if (this.voteSpace != null) {
            if (this.voteCursor == null) {
                this.voteCursor = this.voteSpace.createLocalizableByDimCursor();
            }
            this.voteCursor.setPosition(loc);
            ((RealType)this.voteCursor.getType()).add(this.one);
            return true;
        }
        this.errorMsg = "Uninitialized Vote Space";
        return false;
    }

    public ArrayList<int[]> getPeakList() {
        return this.peaks;
    }

    public boolean setExclusion(double[] newExclusion) {
        if (newExclusion.length >= this.peakExclusion.length) {
            System.arraycopy(newExclusion, 0, this.peakExclusion, 0, this.peakExclusion.length);
            return true;
        }
        return false;
    }

    protected void setErrorMsg(String msg) {
        this.errorMsg = msg;
    }

    protected boolean pickPeaks() {
        PickImagePeaks<S> peakPicker = new PickImagePeaks<S>(this.voteSpace);
        peakPicker.setSuppression(this.peakExclusion);
        boolean ok = peakPicker.process();
        if (ok) {
            this.peaks = peakPicker.getPeakList();
            return true;
        }
        return false;
    }

    @Override
    public boolean checkInput() {
        return this.voteSpace != null;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    public long getProcessingTime() {
        return this.pTime;
    }

    public Image<T> getImage() {
        return this.image;
    }

    @Override
    public Image<S> getResult() {
        return this.voteSpace;
    }
}

