/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.AbstractLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.transform.Transform;

public final class TransformRandomAccess<T>
extends AbstractLocalizable
implements RandomAccess<T> {
    private final RandomAccess<T> source;
    private final Transform transformToSource;
    private final long[] tmp;

    TransformRandomAccess(RandomAccess<T> source, Transform transformToSource) {
        super(transformToSource.numSourceDimensions());
        this.source = source;
        this.transformToSource = transformToSource;
        this.tmp = new long[transformToSource.numTargetDimensions()];
    }

    protected TransformRandomAccess(TransformRandomAccess<T> randomAccess) {
        super(randomAccess.numDimensions());
        this.source = randomAccess.source.copy();
        this.transformToSource = randomAccess.transformToSource;
        this.tmp = new long[randomAccess.tmp.length];
    }

    @Override
    public void fwd(int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + 1L;
    }

    @Override
    public void bck(int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] - 1L;
    }

    @Override
    public void move(int distance, int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
    }

    @Override
    public void move(long distance, int d) {
        assert (d < this.n);
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    @Override
    public void move(Localizable localizable) {
        assert (localizable.numDimensions() >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getLongPosition(d);
        }
    }

    @Override
    public void move(int[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (long)distance[d];
        }
    }

    @Override
    public void move(long[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        assert (localizable.numDimensions() == this.n);
        localizable.localize(this.position);
    }

    @Override
    public void setPosition(int[] pos) {
        assert (pos.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
        }
    }

    @Override
    public void setPosition(long[] pos) {
        assert (pos.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
        }
    }

    @Override
    public void setPosition(int pos, int d) {
        assert (d < this.n);
        this.position[d] = pos;
    }

    @Override
    public void setPosition(long pos, int d) {
        assert (d < this.n);
        this.position[d] = pos;
    }

    @Override
    public T get() {
        this.transformToSource.apply(this.position, this.tmp);
        this.source.setPosition(this.tmp);
        return this.source.get();
    }

    @Override
    public T getType() {
        return this.source.getType();
    }

    @Override
    public TransformRandomAccess<T> copy() {
        return new TransformRandomAccess<T>(this);
    }
}

