/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.transform.integer.Mixed;

public final class FullSourceMapMixedRandomAccess<T>
extends AbstractEuclideanSpace
implements RandomAccess<T> {
    private final RandomAccess<T> s;
    private final int m;
    private final long[] translation;
    private final boolean[] sourceInv;
    private final int[] sourceComponent;
    private final long[] tmpPosition;
    private final long[] tmpDistance;

    FullSourceMapMixedRandomAccess(RandomAccess<T> source, Mixed transformToSource) {
        super(transformToSource.numSourceDimensions());
        assert (source.numDimensions() == transformToSource.numTargetDimensions());
        this.s = source;
        this.m = transformToSource.numTargetDimensions();
        this.translation = new long[this.m];
        boolean[] targetZero = new boolean[this.m];
        boolean[] targetInv = new boolean[this.m];
        int[] targetComponent = new int[this.m];
        transformToSource.getTranslation(this.translation);
        transformToSource.getComponentZero(targetZero);
        transformToSource.getComponentMapping(targetComponent);
        transformToSource.getComponentInversion(targetInv);
        this.sourceInv = new boolean[this.n];
        this.sourceComponent = new int[this.n];
        for (int d = 0; d < this.m; ++d) {
            if (targetZero[d]) {
                this.s.setPosition(this.translation[d], d);
                continue;
            }
            int e = targetComponent[d];
            this.sourceInv[e] = targetInv[d];
            this.sourceComponent[e] = d;
        }
        this.tmpPosition = (long[])this.translation.clone();
        this.tmpDistance = new long[this.m];
    }

    protected FullSourceMapMixedRandomAccess(FullSourceMapMixedRandomAccess<T> randomAccess) {
        super(randomAccess.numDimensions());
        this.s = randomAccess.s.copy();
        this.m = randomAccess.m;
        this.translation = (long[])randomAccess.translation.clone();
        this.sourceInv = (boolean[])randomAccess.sourceInv.clone();
        this.sourceComponent = (int[])randomAccess.sourceComponent.clone();
        this.tmpPosition = (long[])this.translation.clone();
        this.tmpDistance = new long[this.m];
    }

    @Override
    public void localize(int[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getIntPosition(d);
        }
    }

    @Override
    public void localize(long[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getLongPosition(d);
        }
    }

    @Override
    public int getIntPosition(int d) {
        assert (d < this.n);
        int td = this.sourceComponent[d];
        int v = this.s.getIntPosition(td) - (int)this.translation[td];
        return this.sourceInv[d] ? -v : v;
    }

    @Override
    public long getLongPosition(int d) {
        assert (d < this.n);
        int td = this.sourceComponent[d];
        long v = this.s.getLongPosition(td) - this.translation[td];
        return this.sourceInv[d] ? -v : v;
    }

    @Override
    public void localize(float[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getFloatPosition(d);
        }
    }

    @Override
    public void localize(double[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getDoublePosition(d);
        }
    }

    @Override
    public float getFloatPosition(int d) {
        return this.getLongPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.getLongPosition(d);
    }

    @Override
    public void fwd(int d) {
        assert (d < this.n);
        if (this.sourceInv[d]) {
            this.s.bck(this.sourceComponent[d]);
        } else {
            this.s.fwd(this.sourceComponent[d]);
        }
    }

    @Override
    public void bck(int d) {
        assert (d < this.n);
        if (this.sourceInv[d]) {
            this.s.fwd(this.sourceComponent[d]);
        } else {
            this.s.bck(this.sourceComponent[d]);
        }
    }

    @Override
    public void move(int distance, int d) {
        assert (d < this.n);
        this.s.move(this.sourceInv[d] ? -distance : distance, this.sourceComponent[d]);
    }

    @Override
    public void move(long distance, int d) {
        assert (d < this.n);
        this.s.move(this.sourceInv[d] ? -distance : distance, this.sourceComponent[d]);
    }

    @Override
    public void move(Localizable localizable) {
        assert (localizable.numDimensions() >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int td = this.sourceComponent[d];
            long p = localizable.getLongPosition(d);
            this.tmpDistance[td] = this.sourceInv[d] ? -p : p;
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void move(int[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int td = this.sourceComponent[d];
            this.tmpDistance[td] = this.sourceInv[d] ? (long)(-distance[d]) : (long)distance[d];
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void move(long[] distance) {
        assert (distance.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int td = this.sourceComponent[d];
            this.tmpDistance[td] = this.sourceInv[d] ? -distance[d] : distance[d];
        }
        this.s.move(this.tmpDistance);
    }

    @Override
    public void setPosition(Localizable localizable) {
        assert (localizable.numDimensions() >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int td = this.sourceComponent[d];
            long p = localizable.getLongPosition(d);
            this.tmpPosition[td] = this.translation[td] + (this.sourceInv[d] ? -p : p);
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(int[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int td = this.sourceComponent[d];
            this.tmpPosition[td] = this.translation[td] + (long)(this.sourceInv[d] ? -position[d] : position[d]);
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(long[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            int td = this.sourceComponent[d];
            this.tmpPosition[td] = this.translation[td] + (this.sourceInv[d] ? -position[d] : position[d]);
        }
        this.s.setPosition(this.tmpPosition);
    }

    @Override
    public void setPosition(int position, int d) {
        assert (d < this.n);
        int td = this.sourceComponent[d];
        int targetPos = (int)this.translation[td] + (this.sourceInv[d] ? -position : position);
        this.s.setPosition(targetPos, td);
    }

    @Override
    public void setPosition(long position, int d) {
        assert (d < this.n);
        int td = this.sourceComponent[d];
        long targetPos = this.translation[td] + (this.sourceInv[d] ? -position : position);
        this.s.setPosition(targetPos, td);
    }

    @Override
    public T get() {
        return this.s.get();
    }

    @Override
    public T getType() {
        return this.s.getType();
    }

    @Override
    public FullSourceMapMixedRandomAccess<T> copy() {
        return new FullSourceMapMixedRandomAccess<T>(this);
    }
}

