/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.planar;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.img.AbstractNativeImg;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.PlanarAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.planar.PlanarCursor;
import net.imglib2.img.planar.PlanarCursor1D;
import net.imglib2.img.planar.PlanarCursor2D;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.img.planar.PlanarLocalizingCursor;
import net.imglib2.img.planar.PlanarLocalizingCursor1D;
import net.imglib2.img.planar.PlanarLocalizingCursor2D;
import net.imglib2.img.planar.PlanarPlaneSubsetCursor;
import net.imglib2.img.planar.PlanarPlaneSubsetLocalizingCursor;
import net.imglib2.img.planar.PlanarRandomAccess;
import net.imglib2.img.planar.PlanarRandomAccess1D;
import net.imglib2.img.planar.PlanarSpliterator;
import net.imglib2.stream.LocalizableSpliterator;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.util.Fraction;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.iteration.SubIntervalIterable;

public class PlanarImg<T extends NativeType<T>, A extends ArrayDataAccess<A>>
extends AbstractNativeImg<T, A>
implements PlanarAccess<A>,
SubIntervalIterable<T> {
    protected final int numSlices;
    final int elementsPerSlice;
    protected final int[] dimensions;
    protected final int[] sliceSteps;
    protected final List<A> mirror;

    public PlanarImg(List<A> slices, long[] dim, Fraction entitiesPerPixel) {
        super(dim, entitiesPerPixel);
        this.dimensions = Util.long2int(dim);
        this.sliceSteps = PlanarImg.computeSliceSteps(dim);
        this.numSlices = PlanarImg.numberOfSlices(dim);
        this.elementsPerSlice = PlanarImg.elementsPerSlice(dim);
        if (slices.size() != this.numSlices) {
            throw new IllegalArgumentException();
        }
        this.mirror = slices;
    }

    @Deprecated
    public PlanarImg(long[] dim, Fraction entitiesPerPixel) {
        this(PlanarImg.emptySlices(dim), dim, entitiesPerPixel);
    }

    PlanarImg(A creator, long[] dim, Fraction entitiesPerPixel) {
        this(PlanarImg.createSlices(creator, dim, entitiesPerPixel), dim, entitiesPerPixel);
    }

    @Override
    public A update(Object c) {
        int i = ((PlanarContainerSampler)c).getCurrentSliceIndex();
        return (A)((ArrayDataAccess)((ArrayDataAccess)this.mirror.get(i < 0 ? 0 : (i >= this.numSlices ? this.numSlices - 1 : i))).createView(c));
    }

    public int numSlices() {
        return this.numSlices;
    }

    public final int getIndex(int[] l) {
        if (this.n > 1) {
            return l[1] * this.dimensions[0] + l[0];
        }
        return l[0];
    }

    public void indexToGlobalPosition(int sliceIndex, int indexInSlice, int[] position) {
        if (this.n > 1) {
            position[1] = indexInSlice / this.dimensions[0];
            position[0] = indexInSlice - position[1] * this.dimensions[0];
            if (this.n > 2) {
                int maxDim = this.n - 1;
                for (int d = 2; d < maxDim; ++d) {
                    int j = sliceIndex / this.dimensions[d];
                    position[d] = sliceIndex - j * this.dimensions[d];
                    sliceIndex = j;
                }
                position[maxDim] = sliceIndex;
            }
        } else {
            position[0] = indexInSlice;
        }
    }

    public int indexToGlobalPosition(int sliceIndex, int indexInSlice, int dim) {
        if (dim == 0) {
            return indexInSlice % this.dimensions[0];
        }
        if (dim == 1) {
            return indexInSlice / this.dimensions[0];
        }
        if (dim < this.n) {
            return sliceIndex / this.sliceSteps[dim] % this.dimensions[dim];
        }
        return 0;
    }

    @Override
    public PlanarCursor<T> cursor() {
        if (this.n == 1) {
            return new PlanarCursor1D(this);
        }
        if (this.n == 2) {
            return new PlanarCursor2D(this);
        }
        return new PlanarCursor(this);
    }

    @Override
    public PlanarLocalizingCursor<T> localizingCursor() {
        if (this.n == 1) {
            return new PlanarLocalizingCursor1D(this);
        }
        if (this.n == 2) {
            return new PlanarLocalizingCursor2D(this);
        }
        return new PlanarLocalizingCursor(this);
    }

    @Override
    public PlanarRandomAccess<T> randomAccess() {
        if (this.n == 1) {
            return new PlanarRandomAccess1D(this);
        }
        return new PlanarRandomAccess(this);
    }

    @Override
    public FlatIterationOrder iterationOrder() {
        return new FlatIterationOrder(this);
    }

    @Override
    public A getPlane(int no) {
        return (A)((ArrayDataAccess)this.mirror.get(no));
    }

    @Override
    public void setPlane(int no, A plane) {
        this.mirror.set(no, plane);
    }

    @Override
    public PlanarImgFactory<T> factory() {
        return new PlanarImgFactory<NativeType>(this.linkedType);
    }

    public PlanarImg<T, ?> copy() {
        NativeImg copy = ((PlanarImgFactory)this.factory()).create(this.dimension);
        Cursor cursor1 = this.cursor();
        Cursor cursor2 = ((PlanarImg)copy).cursor();
        while (((PlanarCursor)cursor1).hasNext()) {
            ((NativeType)cursor2.next()).set((Type)cursor1.next());
        }
        return copy;
    }

    @Override
    public boolean supportsOptimizedCursor(Interval interval) {
        return Intervals.contains((Interval)this, interval) && this.correspondsToPlane(interval);
    }

    @Override
    public Object subIntervalIterationOrder(Interval interval) {
        return new FlatIterationOrder(interval);
    }

    @Override
    public Cursor<T> cursor(Interval interval) {
        assert (this.supportsOptimizedCursor(interval));
        return new PlanarPlaneSubsetCursor(this, interval);
    }

    @Override
    public LocalizableSpliterator<T> spliterator() {
        return new PlanarSpliterator(this, 0L, this.size());
    }

    @Override
    public LocalizableSpliterator<T> localizingSpliterator() {
        return this.spliterator();
    }

    private boolean correspondsToPlane(Interval interval) {
        if (interval.dimension(0) != this.dimension[0]) {
            return false;
        }
        if (this.dimension.length == 1) {
            return true;
        }
        if (interval.dimension(1) != this.dimension[1]) {
            return false;
        }
        for (int d = 2; d < interval.numDimensions(); ++d) {
            if (interval.dimension(d) == 1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public Cursor<T> localizingCursor(Interval interval) {
        assert (this.supportsOptimizedCursor(interval));
        return new PlanarPlaneSubsetLocalizingCursor(this, interval);
    }

    public static int elementsPerSlice(long[] dimensions) {
        int size = (int)dimensions[0];
        if (dimensions.length > 1) {
            size *= (int)dimensions[1];
        }
        return size;
    }

    public static int numberOfSlices(long[] dimensions) {
        int s = 1;
        for (int d = 2; d < dimensions.length; ++d) {
            s = (int)((long)s * dimensions[d]);
        }
        return s;
    }

    private static int[] computeSliceSteps(long[] dimensions) {
        int n = dimensions.length;
        if (n <= 2) {
            return null;
        }
        int[] sliceSteps = new int[n];
        sliceSteps[2] = 1;
        for (int i = 3; i < n; ++i) {
            sliceSteps[i] = (int)dimensions[i - 1] * sliceSteps[i - 1];
        }
        return sliceSteps;
    }

    private static <A> List<A> emptySlices(long[] dim) {
        int numSlices = PlanarImg.numberOfSlices(dim);
        ArrayList<Object> mirror = new ArrayList<Object>(numSlices);
        for (int i = 0; i < numSlices; ++i) {
            mirror.add(null);
        }
        return mirror;
    }

    private static <A extends ArrayDataAccess<A>> List<A> createSlices(A creator, long[] dim, Fraction entitiesPerPixel) {
        int numSlices = PlanarImg.numberOfSlices(dim);
        ArrayList<A> mirror = new ArrayList<A>(numSlices);
        int pixelsPerPlane = (int)((dim.length > 1 ? dim[1] : 1L) * dim[0]);
        int numEntitiesPerSlice = (int)entitiesPerPixel.mulCeil(pixelsPerPlane);
        for (int i = 0; i < numSlices; ++i) {
            mirror.add(creator.createArray(numEntitiesPerSlice));
        }
        return mirror;
    }

    public static interface PlanarContainerSampler {
        public int getCurrentSliceIndex();
    }
}

