/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.display.screenimage.awt;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import net.imglib2.Dimensions;
import net.imglib2.display.screenimage.awt.AWTScreenImage;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;

public abstract class ArrayImgAWTScreenImage<T extends NativeType<T>, A extends DataAccess>
extends ArrayImg<T, A>
implements AWTScreenImage {
    private final BufferedImage bufferedImage;

    public ArrayImgAWTScreenImage(ArrayImg<T, A> img) {
        this((NativeType)img.firstElement(), img.update(null), ArrayImgAWTScreenImage.dimensions(img));
    }

    public ArrayImgAWTScreenImage(T type, A data, long[] dim) {
        super(data, dim, type.getEntitiesPerPixel());
        this.bufferedImage = this.createBufferedImage(type, data, (int)dim[0], (int)dim[1]);
    }

    @Override
    public BufferedImage image() {
        return this.bufferedImage;
    }

    protected int getBitsPerPixel(T type) {
        if (type instanceof RealType) {
            return ((RealType)type).getBitsPerPixel();
        }
        throw new IllegalStateException("Unknown bits per pixel: " + type);
    }

    protected abstract DataBuffer createDataBuffer(A var1);

    private BufferedImage createBufferedImage(T type, A data, int width, int height) {
        DataBuffer buffer = this.createDataBuffer(data);
        PixelInterleavedSampleModel model = new PixelInterleavedSampleModel(buffer.getDataType(), width, height, 1, width, new int[]{0});
        ColorModel colorModel = this.createColorModel(type, buffer);
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    private ColorModel createColorModel(T type, DataBuffer buffer) {
        ColorSpace cs = ColorSpace.getInstance(1003);
        int[] bits = new int[]{this.getBitsPerPixel(type)};
        return new ComponentColorModel(cs, bits, false, false, 1, buffer.getDataType());
    }

    private static long[] dimensions(Dimensions img) {
        long[] dimensions = new long[img.numDimensions()];
        img.dimensions(dimensions);
        return dimensions;
    }

    @Deprecated
    public ArrayImgAWTScreenImage(T type, Object data, long[] dim) {
        this(type, (DataAccess)data, dim);
    }
}

