/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.converter;

import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.converter.RealTypeConverterInternals;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public final class RealTypeConverters {
    private RealTypeConverters() {
    }

    public static void copyFromTo(RandomAccessible<? extends RealType<?>> source, RandomAccessibleInterval<? extends RealType<?>> destination) {
        IntervalView<RealType<?>> sourceInterval = Views.interval(source, destination);
        RealType<?> s = sourceInterval.getType();
        RealType d = (RealType)destination.getType();
        Converter<RealType<?>, RealType> copy = RealTypeConverters.getConverter(s, d);
        boolean useMultiThreading = Intervals.numElements(destination) >= 20000L;
        LoopBuilder.setImages(sourceInterval, destination).multiThreaded(useMultiThreading).forEachPixel(copy::convert);
    }

    public static <T extends RealType<T>> RandomAccessibleInterval<T> convert(RandomAccessibleInterval<? extends RealType<?>> image, T pixelType) {
        RealType in = (RealType)image.getType();
        Converter<RealType, T> converter = RealTypeConverters.getConverter(in, pixelType);
        return Converters.convert(image, converter, pixelType);
    }

    public static <S extends RealType<?>, T extends RealType<?>> Converter<S, T> getConverter(S inputType, T outputType) {
        return RealTypeConverterInternals.getConverter(inputType, outputType);
    }
}

