/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import net.imglib2.type.PrimitiveType;

interface MemCopy<S, T> {
    public static final MemCopyBoolean BOOLEAN = new MemCopyBoolean();
    public static final MemCopyByte BYTE = new MemCopyByte();
    public static final MemCopyChar CHAR = new MemCopyChar();
    public static final MemCopyShort SHORT = new MemCopyShort();
    public static final MemCopyInt INT = new MemCopyInt();
    public static final MemCopyLong LONG = new MemCopyLong();
    public static final MemCopyFloat FLOAT = new MemCopyFloat();
    public static final MemCopyDouble DOUBLE = new MemCopyDouble();
    public static final MemCopyByteBufferToArray BUFFER_TO_ARRAY_BYTE = new MemCopyByteBufferToArray();
    public static final MemCopyCharBufferToArray BUFFER_TO_ARRAY_CHAR = new MemCopyCharBufferToArray();
    public static final MemCopyShortBufferToArray BUFFER_TO_ARRAY_SHORT = new MemCopyShortBufferToArray();
    public static final MemCopyIntBufferToArray BUFFER_TO_ARRAY_INT = new MemCopyIntBufferToArray();
    public static final MemCopyLongBufferToArray BUFFER_TO_ARRAY_LONG = new MemCopyLongBufferToArray();
    public static final MemCopyFloatBufferToArray BUFFER_TO_ARRAY_FLOAT = new MemCopyFloatBufferToArray();
    public static final MemCopyDoubleBufferToArray BUFFER_TO_ARRAY_DOUBLE = new MemCopyDoubleBufferToArray();
    public static final MemCopyByteArrayToBuffer ARRAY_TO_BUFFER_BYTE = new MemCopyByteArrayToBuffer();
    public static final MemCopyCharArrayToBuffer ARRAY_TO_BUFFER_CHAR = new MemCopyCharArrayToBuffer();
    public static final MemCopyShortArrayToBuffer ARRAY_TO_BUFFER_SHORT = new MemCopyShortArrayToBuffer();
    public static final MemCopyIntArrayToBuffer ARRAY_TO_BUFFER_INT = new MemCopyIntArrayToBuffer();
    public static final MemCopyLongArrayToBuffer ARRAY_TO_BUFFER_LONG = new MemCopyLongArrayToBuffer();
    public static final MemCopyFloatArrayToBuffer ARRAY_TO_BUFFER_FLOAT = new MemCopyFloatArrayToBuffer();
    public static final MemCopyDoubleArrayToBuffer ARRAY_TO_BUFFER_DOUBLE = new MemCopyDoubleArrayToBuffer();
    public static final MemCopyByteBufferToBuffer BUFFER_TO_BUFFER_BYTE = new MemCopyByteBufferToBuffer();
    public static final MemCopyCharBufferToBuffer BUFFER_TO_BUFFER_CHAR = new MemCopyCharBufferToBuffer();
    public static final MemCopyShortBufferToBuffer BUFFER_TO_BUFFER_SHORT = new MemCopyShortBufferToBuffer();
    public static final MemCopyIntBufferToBuffer BUFFER_TO_BUFFER_INT = new MemCopyIntBufferToBuffer();
    public static final MemCopyLongBufferToBuffer BUFFER_TO_BUFFER_LONG = new MemCopyLongBufferToBuffer();
    public static final MemCopyFloatBufferToBuffer BUFFER_TO_BUFFER_FLOAT = new MemCopyFloatBufferToBuffer();
    public static final MemCopyDoubleBufferToBuffer BUFFER_TO_BUFFER_DOUBLE = new MemCopyDoubleBufferToBuffer();

    public void copyForward(S var1, int var2, T var3, int var4, int var5);

    public void copyReverse(S var1, int var2, T var3, int var4, int var5);

    public void copyValue(S var1, int var2, T var3, int var4, int var5);

    public void copyStrided(S var1, int var2, T var3, int var4, int var5, int var6);

    default public void copyLines(int lineDir, int lineLength, int numLines, S src, int srcPos, int srcStep, T dest, int destPos, int destStep) {
        if (lineDir == 1) {
            for (int i = 0; i < numLines; ++i) {
                this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
            }
        } else if (lineDir == -1) {
            for (int i = 0; i < numLines; ++i) {
                this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
            }
        } else {
            for (int i = 0; i < numLines; ++i) {
                this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
            }
        }
    }

    default public void copyNDRangeRecursive(int d, S src, int[] srcStrides, int srcPos, T dest, int[] destStrides, int destPos, int[] size) {
        int len = size[d];
        if (d > 0) {
            int stride_src = srcStrides[d];
            int stride_dst = destStrides[d];
            for (int i = 0; i < len; ++i) {
                this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
            }
        } else {
            this.copyForward(src, srcPos, dest, destPos, len);
        }
    }

    public static MemCopy<?, ?> forPrimitiveType(PrimitiveType primitiveType) {
        return MemCopy.forPrimitiveType(primitiveType, false, false);
    }

    public static MemCopy<?, ?> forPrimitiveType(PrimitiveType primitiveType, boolean fromBuffer, boolean toBuffer) {
        switch (primitiveType) {
            case BOOLEAN: {
                if (fromBuffer || toBuffer) {
                    throw new IllegalArgumentException("No BufferAccess implementation for PrimitiveType.BOOLEAN");
                }
                return BOOLEAN;
            }
            case BYTE: {
                return fromBuffer ? (toBuffer ? BUFFER_TO_BUFFER_BYTE : BUFFER_TO_ARRAY_BYTE) : (toBuffer ? ARRAY_TO_BUFFER_BYTE : BYTE);
            }
            case CHAR: {
                return fromBuffer ? (toBuffer ? BUFFER_TO_BUFFER_CHAR : BUFFER_TO_ARRAY_CHAR) : (toBuffer ? ARRAY_TO_BUFFER_CHAR : CHAR);
            }
            case SHORT: {
                return fromBuffer ? (toBuffer ? BUFFER_TO_BUFFER_SHORT : BUFFER_TO_ARRAY_SHORT) : (toBuffer ? ARRAY_TO_BUFFER_SHORT : SHORT);
            }
            case INT: {
                return fromBuffer ? (toBuffer ? BUFFER_TO_BUFFER_INT : BUFFER_TO_ARRAY_INT) : (toBuffer ? ARRAY_TO_BUFFER_INT : INT);
            }
            case LONG: {
                return fromBuffer ? (toBuffer ? BUFFER_TO_BUFFER_LONG : BUFFER_TO_ARRAY_LONG) : (toBuffer ? ARRAY_TO_BUFFER_LONG : LONG);
            }
            case FLOAT: {
                return fromBuffer ? (toBuffer ? BUFFER_TO_BUFFER_FLOAT : BUFFER_TO_ARRAY_FLOAT) : (toBuffer ? ARRAY_TO_BUFFER_FLOAT : FLOAT);
            }
            case DOUBLE: {
                return fromBuffer ? (toBuffer ? BUFFER_TO_BUFFER_DOUBLE : BUFFER_TO_ARRAY_DOUBLE) : (toBuffer ? ARRAY_TO_BUFFER_DOUBLE : DOUBLE);
            }
        }
        throw new IllegalArgumentException();
    }

    public static PrimitiveType primitiveTypeForClass(Class<?> clz) {
        if (clz.equals(boolean[].class)) {
            return PrimitiveType.BOOLEAN;
        }
        if (clz.equals(byte[].class) || clz.equals(ByteBuffer.class)) {
            return PrimitiveType.BYTE;
        }
        if (clz.equals(char[].class) || clz.equals(CharBuffer.class)) {
            return PrimitiveType.CHAR;
        }
        if (clz.equals(short[].class) || clz.equals(ShortBuffer.class)) {
            return PrimitiveType.SHORT;
        }
        if (clz.equals(int[].class) || clz.equals(IntBuffer.class)) {
            return PrimitiveType.INT;
        }
        if (clz.equals(long[].class) || clz.equals(LongBuffer.class)) {
            return PrimitiveType.LONG;
        }
        if (clz.equals(float[].class) || clz.equals(FloatBuffer.class)) {
            return PrimitiveType.FLOAT;
        }
        if (clz.equals(double[].class) || clz.equals(DoubleBuffer.class)) {
            return PrimitiveType.DOUBLE;
        }
        throw new IllegalArgumentException();
    }

    public static MemCopy<?, ?> forClasses(Class<?> srcClass, Class<?> destClass) {
        PrimitiveType primitiveType = MemCopy.primitiveTypeForClass(srcClass);
        if (!MemCopy.primitiveTypeForClass(destClass).equals((Object)primitiveType)) {
            throw new IllegalArgumentException("primitive types for src and dest do not match");
        }
        boolean fromBuffer = Buffer.class.isAssignableFrom(srcClass);
        boolean toBuffer = Buffer.class.isAssignableFrom(destClass);
        return MemCopy.forPrimitiveType(primitiveType, fromBuffer, toBuffer);
    }

    public static class MemCopyDoubleBufferToBuffer
    implements MemCopy<DoubleBuffer, DoubleBuffer> {
        @Override
        public void copyForward(DoubleBuffer src, int srcPos, DoubleBuffer dest, int destPos, int length) {
            src.limit(srcPos + length);
            src.position(srcPos);
            dest.position(destPos);
            dest.put(src);
        }

        @Override
        public void copyReverse(DoubleBuffer src, int srcPos, DoubleBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src.get(srcPos - i));
            }
        }

        @Override
        public void copyValue(DoubleBuffer src, int srcPos, DoubleBuffer dest, int destPos, int length) {
            double val = src.get(srcPos);
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(DoubleBuffer src, int srcPos, DoubleBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src.get(srcPos + i));
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, DoubleBuffer src, int srcPos, int srcStep, DoubleBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, DoubleBuffer src, int[] srcStrides, int srcPos, DoubleBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyDoubleArrayToBuffer
    implements MemCopy<double[], DoubleBuffer> {
        @Override
        public void copyForward(double[] src, int srcPos, DoubleBuffer dest, int destPos, int length) {
            dest.position(destPos);
            dest.put(src, srcPos, length);
        }

        @Override
        public void copyReverse(double[] src, int srcPos, DoubleBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src[srcPos - i]);
            }
        }

        @Override
        public void copyValue(double[] src, int srcPos, DoubleBuffer dest, int destPos, int length) {
            double val = src[srcPos];
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(double[] src, int srcPos, DoubleBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src[srcPos + i]);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, double[] src, int srcPos, int srcStep, DoubleBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, double[] src, int[] srcStrides, int srcPos, DoubleBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyDoubleBufferToArray
    implements MemCopy<DoubleBuffer, double[]> {
        @Override
        public void copyForward(DoubleBuffer src, int srcPos, double[] dest, int destPos, int length) {
            src.position(srcPos);
            src.get(dest, destPos, length);
        }

        @Override
        public void copyReverse(DoubleBuffer src, int srcPos, double[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src.get(srcPos - i);
            }
        }

        @Override
        public void copyValue(DoubleBuffer src, int srcPos, double[] dest, int destPos, int length) {
            double val = src.get(srcPos);
            Arrays.fill(dest, destPos, destPos + length, val);
        }

        @Override
        public void copyStrided(DoubleBuffer src, int srcPos, double[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src.get(srcPos + i);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, DoubleBuffer src, int srcPos, int srcStep, double[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, DoubleBuffer src, int[] srcStrides, int srcPos, double[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyDouble
    implements MemCopy<double[], double[]> {
        @Override
        public void copyForward(double[] src, int srcPos, double[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(double[] src, int srcPos, double[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(double[] src, int srcPos, double[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(double[] src, int srcPos, double[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, double[] src, int srcPos, int srcStep, double[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, double[] src, int[] srcStrides, int srcPos, double[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyFloatBufferToBuffer
    implements MemCopy<FloatBuffer, FloatBuffer> {
        @Override
        public void copyForward(FloatBuffer src, int srcPos, FloatBuffer dest, int destPos, int length) {
            src.limit(srcPos + length);
            src.position(srcPos);
            dest.position(destPos);
            dest.put(src);
        }

        @Override
        public void copyReverse(FloatBuffer src, int srcPos, FloatBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src.get(srcPos - i));
            }
        }

        @Override
        public void copyValue(FloatBuffer src, int srcPos, FloatBuffer dest, int destPos, int length) {
            float val = src.get(srcPos);
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(FloatBuffer src, int srcPos, FloatBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src.get(srcPos + i));
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, FloatBuffer src, int srcPos, int srcStep, FloatBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, FloatBuffer src, int[] srcStrides, int srcPos, FloatBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyFloatArrayToBuffer
    implements MemCopy<float[], FloatBuffer> {
        @Override
        public void copyForward(float[] src, int srcPos, FloatBuffer dest, int destPos, int length) {
            dest.position(destPos);
            dest.put(src, srcPos, length);
        }

        @Override
        public void copyReverse(float[] src, int srcPos, FloatBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src[srcPos - i]);
            }
        }

        @Override
        public void copyValue(float[] src, int srcPos, FloatBuffer dest, int destPos, int length) {
            float val = src[srcPos];
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(float[] src, int srcPos, FloatBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src[srcPos + i]);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, float[] src, int srcPos, int srcStep, FloatBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, float[] src, int[] srcStrides, int srcPos, FloatBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyFloatBufferToArray
    implements MemCopy<FloatBuffer, float[]> {
        @Override
        public void copyForward(FloatBuffer src, int srcPos, float[] dest, int destPos, int length) {
            src.position(srcPos);
            src.get(dest, destPos, length);
        }

        @Override
        public void copyReverse(FloatBuffer src, int srcPos, float[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src.get(srcPos - i);
            }
        }

        @Override
        public void copyValue(FloatBuffer src, int srcPos, float[] dest, int destPos, int length) {
            float val = src.get(srcPos);
            Arrays.fill(dest, destPos, destPos + length, val);
        }

        @Override
        public void copyStrided(FloatBuffer src, int srcPos, float[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src.get(srcPos + i);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, FloatBuffer src, int srcPos, int srcStep, float[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, FloatBuffer src, int[] srcStrides, int srcPos, float[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyFloat
    implements MemCopy<float[], float[]> {
        @Override
        public void copyForward(float[] src, int srcPos, float[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(float[] src, int srcPos, float[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(float[] src, int srcPos, float[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(float[] src, int srcPos, float[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, float[] src, int srcPos, int srcStep, float[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, float[] src, int[] srcStrides, int srcPos, float[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyLongBufferToBuffer
    implements MemCopy<LongBuffer, LongBuffer> {
        @Override
        public void copyForward(LongBuffer src, int srcPos, LongBuffer dest, int destPos, int length) {
            src.limit(srcPos + length);
            src.position(srcPos);
            dest.position(destPos);
            dest.put(src);
        }

        @Override
        public void copyReverse(LongBuffer src, int srcPos, LongBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src.get(srcPos - i));
            }
        }

        @Override
        public void copyValue(LongBuffer src, int srcPos, LongBuffer dest, int destPos, int length) {
            long val = src.get(srcPos);
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(LongBuffer src, int srcPos, LongBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src.get(srcPos + i));
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, LongBuffer src, int srcPos, int srcStep, LongBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, LongBuffer src, int[] srcStrides, int srcPos, LongBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyLongArrayToBuffer
    implements MemCopy<long[], LongBuffer> {
        @Override
        public void copyForward(long[] src, int srcPos, LongBuffer dest, int destPos, int length) {
            dest.position(destPos);
            dest.put(src, srcPos, length);
        }

        @Override
        public void copyReverse(long[] src, int srcPos, LongBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src[srcPos - i]);
            }
        }

        @Override
        public void copyValue(long[] src, int srcPos, LongBuffer dest, int destPos, int length) {
            long val = src[srcPos];
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(long[] src, int srcPos, LongBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src[srcPos + i]);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, long[] src, int srcPos, int srcStep, LongBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, long[] src, int[] srcStrides, int srcPos, LongBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyLongBufferToArray
    implements MemCopy<LongBuffer, long[]> {
        @Override
        public void copyForward(LongBuffer src, int srcPos, long[] dest, int destPos, int length) {
            src.position(srcPos);
            src.get(dest, destPos, length);
        }

        @Override
        public void copyReverse(LongBuffer src, int srcPos, long[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src.get(srcPos - i);
            }
        }

        @Override
        public void copyValue(LongBuffer src, int srcPos, long[] dest, int destPos, int length) {
            long val = src.get(srcPos);
            Arrays.fill(dest, destPos, destPos + length, val);
        }

        @Override
        public void copyStrided(LongBuffer src, int srcPos, long[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src.get(srcPos + i);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, LongBuffer src, int srcPos, int srcStep, long[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, LongBuffer src, int[] srcStrides, int srcPos, long[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyLong
    implements MemCopy<long[], long[]> {
        @Override
        public void copyForward(long[] src, int srcPos, long[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(long[] src, int srcPos, long[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(long[] src, int srcPos, long[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(long[] src, int srcPos, long[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, long[] src, int srcPos, int srcStep, long[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, long[] src, int[] srcStrides, int srcPos, long[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyIntBufferToBuffer
    implements MemCopy<IntBuffer, IntBuffer> {
        @Override
        public void copyForward(IntBuffer src, int srcPos, IntBuffer dest, int destPos, int length) {
            src.limit(srcPos + length);
            src.position(srcPos);
            dest.position(destPos);
            dest.put(src);
        }

        @Override
        public void copyReverse(IntBuffer src, int srcPos, IntBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src.get(srcPos - i));
            }
        }

        @Override
        public void copyValue(IntBuffer src, int srcPos, IntBuffer dest, int destPos, int length) {
            int val = src.get(srcPos);
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(IntBuffer src, int srcPos, IntBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src.get(srcPos + i));
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, IntBuffer src, int srcPos, int srcStep, IntBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, IntBuffer src, int[] srcStrides, int srcPos, IntBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyIntArrayToBuffer
    implements MemCopy<int[], IntBuffer> {
        @Override
        public void copyForward(int[] src, int srcPos, IntBuffer dest, int destPos, int length) {
            dest.position(destPos);
            dest.put(src, srcPos, length);
        }

        @Override
        public void copyReverse(int[] src, int srcPos, IntBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src[srcPos - i]);
            }
        }

        @Override
        public void copyValue(int[] src, int srcPos, IntBuffer dest, int destPos, int length) {
            int val = src[srcPos];
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(int[] src, int srcPos, IntBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src[srcPos + i]);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, int[] src, int srcPos, int srcStep, IntBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, int[] src, int[] srcStrides, int srcPos, IntBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyIntBufferToArray
    implements MemCopy<IntBuffer, int[]> {
        @Override
        public void copyForward(IntBuffer src, int srcPos, int[] dest, int destPos, int length) {
            src.position(srcPos);
            src.get(dest, destPos, length);
        }

        @Override
        public void copyReverse(IntBuffer src, int srcPos, int[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src.get(srcPos - i);
            }
        }

        @Override
        public void copyValue(IntBuffer src, int srcPos, int[] dest, int destPos, int length) {
            int val = src.get(srcPos);
            Arrays.fill(dest, destPos, destPos + length, val);
        }

        @Override
        public void copyStrided(IntBuffer src, int srcPos, int[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src.get(srcPos + i);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, IntBuffer src, int srcPos, int srcStep, int[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, IntBuffer src, int[] srcStrides, int srcPos, int[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyInt
    implements MemCopy<int[], int[]> {
        @Override
        public void copyForward(int[] src, int srcPos, int[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(int[] src, int srcPos, int[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(int[] src, int srcPos, int[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(int[] src, int srcPos, int[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, int[] src, int srcPos, int srcStep, int[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, int[] src, int[] srcStrides, int srcPos, int[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyShortBufferToBuffer
    implements MemCopy<ShortBuffer, ShortBuffer> {
        @Override
        public void copyForward(ShortBuffer src, int srcPos, ShortBuffer dest, int destPos, int length) {
            src.limit(srcPos + length);
            src.position(srcPos);
            dest.position(destPos);
            dest.put(src);
        }

        @Override
        public void copyReverse(ShortBuffer src, int srcPos, ShortBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src.get(srcPos - i));
            }
        }

        @Override
        public void copyValue(ShortBuffer src, int srcPos, ShortBuffer dest, int destPos, int length) {
            short val = src.get(srcPos);
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(ShortBuffer src, int srcPos, ShortBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src.get(srcPos + i));
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, ShortBuffer src, int srcPos, int srcStep, ShortBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, ShortBuffer src, int[] srcStrides, int srcPos, ShortBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyShortArrayToBuffer
    implements MemCopy<short[], ShortBuffer> {
        @Override
        public void copyForward(short[] src, int srcPos, ShortBuffer dest, int destPos, int length) {
            dest.position(destPos);
            dest.put(src, srcPos, length);
        }

        @Override
        public void copyReverse(short[] src, int srcPos, ShortBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src[srcPos - i]);
            }
        }

        @Override
        public void copyValue(short[] src, int srcPos, ShortBuffer dest, int destPos, int length) {
            short val = src[srcPos];
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(short[] src, int srcPos, ShortBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src[srcPos + i]);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, short[] src, int srcPos, int srcStep, ShortBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, short[] src, int[] srcStrides, int srcPos, ShortBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyShortBufferToArray
    implements MemCopy<ShortBuffer, short[]> {
        @Override
        public void copyForward(ShortBuffer src, int srcPos, short[] dest, int destPos, int length) {
            src.position(srcPos);
            src.get(dest, destPos, length);
        }

        @Override
        public void copyReverse(ShortBuffer src, int srcPos, short[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src.get(srcPos - i);
            }
        }

        @Override
        public void copyValue(ShortBuffer src, int srcPos, short[] dest, int destPos, int length) {
            short val = src.get(srcPos);
            Arrays.fill(dest, destPos, destPos + length, val);
        }

        @Override
        public void copyStrided(ShortBuffer src, int srcPos, short[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src.get(srcPos + i);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, ShortBuffer src, int srcPos, int srcStep, short[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, ShortBuffer src, int[] srcStrides, int srcPos, short[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyShort
    implements MemCopy<short[], short[]> {
        @Override
        public void copyForward(short[] src, int srcPos, short[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(short[] src, int srcPos, short[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(short[] src, int srcPos, short[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(short[] src, int srcPos, short[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, short[] src, int srcPos, int srcStep, short[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, short[] src, int[] srcStrides, int srcPos, short[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyCharBufferToBuffer
    implements MemCopy<CharBuffer, CharBuffer> {
        @Override
        public void copyForward(CharBuffer src, int srcPos, CharBuffer dest, int destPos, int length) {
            src.limit(srcPos + length);
            src.position(srcPos);
            dest.position(destPos);
            dest.put(src);
        }

        @Override
        public void copyReverse(CharBuffer src, int srcPos, CharBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src.get(srcPos - i));
            }
        }

        @Override
        public void copyValue(CharBuffer src, int srcPos, CharBuffer dest, int destPos, int length) {
            char val = src.get(srcPos);
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(CharBuffer src, int srcPos, CharBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src.get(srcPos + i));
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, CharBuffer src, int srcPos, int srcStep, CharBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, CharBuffer src, int[] srcStrides, int srcPos, CharBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyCharArrayToBuffer
    implements MemCopy<char[], CharBuffer> {
        @Override
        public void copyForward(char[] src, int srcPos, CharBuffer dest, int destPos, int length) {
            dest.position(destPos);
            dest.put(src, srcPos, length);
        }

        @Override
        public void copyReverse(char[] src, int srcPos, CharBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src[srcPos - i]);
            }
        }

        @Override
        public void copyValue(char[] src, int srcPos, CharBuffer dest, int destPos, int length) {
            char val = src[srcPos];
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(char[] src, int srcPos, CharBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src[srcPos + i]);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, char[] src, int srcPos, int srcStep, CharBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, char[] src, int[] srcStrides, int srcPos, CharBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyCharBufferToArray
    implements MemCopy<CharBuffer, char[]> {
        @Override
        public void copyForward(CharBuffer src, int srcPos, char[] dest, int destPos, int length) {
            src.position(srcPos);
            src.get(dest, destPos, length);
        }

        @Override
        public void copyReverse(CharBuffer src, int srcPos, char[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src.get(srcPos - i);
            }
        }

        @Override
        public void copyValue(CharBuffer src, int srcPos, char[] dest, int destPos, int length) {
            char val = src.get(srcPos);
            Arrays.fill(dest, destPos, destPos + length, val);
        }

        @Override
        public void copyStrided(CharBuffer src, int srcPos, char[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src.get(srcPos + i);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, CharBuffer src, int srcPos, int srcStep, char[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, CharBuffer src, int[] srcStrides, int srcPos, char[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyChar
    implements MemCopy<char[], char[]> {
        @Override
        public void copyForward(char[] src, int srcPos, char[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(char[] src, int srcPos, char[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(char[] src, int srcPos, char[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(char[] src, int srcPos, char[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, char[] src, int srcPos, int srcStep, char[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, char[] src, int[] srcStrides, int srcPos, char[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyByteBufferToBuffer
    implements MemCopy<ByteBuffer, ByteBuffer> {
        @Override
        public void copyForward(ByteBuffer src, int srcPos, ByteBuffer dest, int destPos, int length) {
            src.limit(srcPos + length);
            src.position(srcPos);
            dest.position(destPos);
            dest.put(src);
        }

        @Override
        public void copyReverse(ByteBuffer src, int srcPos, ByteBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src.get(srcPos - i));
            }
        }

        @Override
        public void copyValue(ByteBuffer src, int srcPos, ByteBuffer dest, int destPos, int length) {
            byte val = src.get(srcPos);
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(ByteBuffer src, int srcPos, ByteBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src.get(srcPos + i));
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, ByteBuffer src, int srcPos, int srcStep, ByteBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, ByteBuffer src, int[] srcStrides, int srcPos, ByteBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyByteArrayToBuffer
    implements MemCopy<byte[], ByteBuffer> {
        @Override
        public void copyForward(byte[] src, int srcPos, ByteBuffer dest, int destPos, int length) {
            dest.position(destPos);
            dest.put(src, srcPos, length);
        }

        @Override
        public void copyReverse(byte[] src, int srcPos, ByteBuffer dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, src[srcPos - i]);
            }
        }

        @Override
        public void copyValue(byte[] src, int srcPos, ByteBuffer dest, int destPos, int length) {
            byte val = src[srcPos];
            for (int i = 0; i < length; ++i) {
                dest.put(destPos + i, val);
            }
        }

        @Override
        public void copyStrided(byte[] src, int srcPos, ByteBuffer dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest.put(destPos + i * destStride, src[srcPos + i]);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, byte[] src, int srcPos, int srcStep, ByteBuffer dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, byte[] src, int[] srcStrides, int srcPos, ByteBuffer dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyByteBufferToArray
    implements MemCopy<ByteBuffer, byte[]> {
        @Override
        public void copyForward(ByteBuffer src, int srcPos, byte[] dest, int destPos, int length) {
            src.position(srcPos);
            src.get(dest, destPos, length);
        }

        @Override
        public void copyReverse(ByteBuffer src, int srcPos, byte[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src.get(srcPos - i);
            }
        }

        @Override
        public void copyValue(ByteBuffer src, int srcPos, byte[] dest, int destPos, int length) {
            byte val = src.get(srcPos);
            Arrays.fill(dest, destPos, destPos + length, val);
        }

        @Override
        public void copyStrided(ByteBuffer src, int srcPos, byte[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src.get(srcPos + i);
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, ByteBuffer src, int srcPos, int srcStep, byte[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, ByteBuffer src, int[] srcStrides, int srcPos, byte[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyByte
    implements MemCopy<byte[], byte[]> {
        @Override
        public void copyForward(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(byte[] src, int srcPos, byte[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, byte[] src, int srcPos, int srcStep, byte[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, byte[] src, int[] srcStrides, int srcPos, byte[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }

    public static class MemCopyBoolean
    implements MemCopy<boolean[], boolean[]> {
        @Override
        public void copyForward(boolean[] src, int srcPos, boolean[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(boolean[] src, int srcPos, boolean[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(boolean[] src, int srcPos, boolean[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(boolean[] src, int srcPos, boolean[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, boolean[] src, int srcPos, int srcStep, boolean[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }

        @Override
        public void copyNDRangeRecursive(int d, boolean[] src, int[] srcStrides, int srcPos, boolean[] dest, int[] destStrides, int destPos, int[] size) {
            int len = size[d];
            if (d > 0) {
                int stride_src = srcStrides[d];
                int stride_dst = destStrides[d];
                for (int i = 0; i < len; ++i) {
                    this.copyNDRangeRecursive(d - 1, src, srcStrides, srcPos + i * stride_src, dest, destStrides, destPos + i * stride_dst, size);
                }
            } else {
                this.copyForward(src, srcPos, dest, destPos, len);
            }
        }
    }
}

