/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.io;

import java.util.Arrays;

public class InputTriggerDescription {
    private String[] triggers;
    private String action;
    private String[] contexts;

    public InputTriggerDescription(String[] triggers, String action, String ... contexts) {
        this.triggers = triggers;
        this.action = action;
        this.setContexts(contexts);
    }

    public InputTriggerDescription() {
    }

    public String toString() {
        int i;
        String s = "( trigger  = [";
        if (this.triggers != null) {
            for (i = 0; i < this.triggers.length; ++i) {
                s = s + "\"" + this.triggers[i] + "\"" + (i == this.triggers.length - 1 ? "" : ", ");
            }
        }
        s = s + "]\n";
        s = s + "  action   = \"" + this.action + "\"\n";
        s = s + "  contexts = [";
        if (this.contexts != null) {
            for (i = 0; i < this.contexts.length; ++i) {
                s = s + "\"" + this.contexts[i] + "\"" + (i == this.contexts.length - 1 ? "" : ", ");
            }
        }
        s = s + "] )\n";
        return s;
    }

    public String[] getTriggers() {
        return this.triggers;
    }

    public String getAction() {
        return this.action;
    }

    public String[] getContexts() {
        return this.contexts;
    }

    public void setTriggers(String[] triggers) {
        this.triggers = triggers;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setContexts(String[] contexts) {
        this.contexts = contexts == null || contexts.length == 1 && contexts[0].isEmpty() ? new String[0] : contexts;
    }

    public void addTrigger(String trigger) {
        if (!Arrays.asList(this.triggers).contains(trigger)) {
            this.triggers = Arrays.copyOf(this.triggers, this.triggers.length + 1);
            this.triggers[this.triggers.length - 1] = trigger;
        }
    }
}

