/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour;

import gnu.trove.TIntCollection;
import gnu.trove.map.hash.TIntLongHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import org.scijava.ui.behaviour.AbstractMouseAndKeyHandler;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.DragBehaviour;
import org.scijava.ui.behaviour.GlobalKeyEventDispatcher;
import org.scijava.ui.behaviour.KeyPressedManager;
import org.scijava.ui.behaviour.ScrollBehaviour;

public class MouseAndKeyHandler
extends AbstractMouseAndKeyHandler
implements KeyListener,
MouseListener,
MouseWheelListener,
MouseMotionListener,
FocusListener {
    private static final int OSX_META_LEFT_CLICK = 20;
    private static final int OSX_ALT_LEFT_CLICK = 24;
    private static final int OSX_ALT_RIGHT_CLICK = 12;
    private final GlobalKeyEventDispatcher globalKeys = GlobalKeyEventDispatcher.getInstance();
    private final TIntSet pressedKeys = new TIntHashSet(5, 0.5f, -1);
    private final TIntLongHashMap keyPressTimes = new TIntLongHashMap(100, 0.5f, -1, -1L);
    private int mouseX;
    private int mouseY;
    private final ArrayList<AbstractMouseAndKeyHandler.BehaviourEntry<DragBehaviour>> activeButtonDrags = new ArrayList();
    private final ArrayList<AbstractMouseAndKeyHandler.BehaviourEntry<DragBehaviour>> activeKeyDrags = new ArrayList();
    private KeyPressedManager keypressManager = null;
    private KeyPressedManager.KeyPressedReceiver receiver = null;

    private int getMask(InputEvent e) {
        int modifiersEx;
        int modifiers = e.getModifiers();
        int mask = modifiersEx = e.getModifiersEx();
        mask = this.globalKeys.shiftPressed() ? (mask |= 0x40) : (mask &= 0xFFFFFFBF);
        mask = this.globalKeys.metaPressed() ? (mask |= 0x100) : (mask &= 0xFFFFFEFF);
        if (this.globalKeys.winPressed()) {
            mask |= 0x400000;
        }
        if (e.getID() != 507 && e.getID() != 502) {
            if ((modifiers & 0x10) != 0) {
                mask |= 0x400;
            }
            if ((modifiers & 8) != 0) {
                mask |= 0x800;
            }
            if ((modifiers & 4) != 0) {
                mask |= 0x1000;
            }
        }
        if (modifiers == 20) {
            mask &= 0xFFFFEFFF;
        }
        if (modifiers == 24) {
            mask &= 0xFFFFF7FF;
        }
        if (modifiers == 12) {
            mask &= 0xFFFFF7FF;
        }
        if (e instanceof MouseEvent && ((MouseEvent)e).getClickCount() > 1) {
            mask |= 0x100000;
        }
        if (e instanceof MouseWheelEvent) {
            mask |= 0x200000;
        }
        return mask;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.update();
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        for (AbstractMouseAndKeyHandler.BehaviourEntry<DragBehaviour> drag : this.activeButtonDrags) {
            drag.behaviour().drag(this.mouseX, this.mouseY);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.update();
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        for (AbstractMouseAndKeyHandler.BehaviourEntry<DragBehaviour> drag : this.activeKeyDrags) {
            drag.behaviour().drag(this.mouseX, this.mouseY);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.update();
        int mask = this.getMask(e);
        int x = e.getX();
        int y = e.getY();
        double wheelRotation = e.getPreciseWheelRotation();
        boolean exShiftMask = (e.getModifiersEx() & 0x40) != 0;
        boolean isHorizontal = !this.globalKeys.shiftPressed() && exShiftMask;
        for (AbstractMouseAndKeyHandler.BehaviourEntry scroll : this.scrolls) {
            if (!scroll.buttons().matches(mask, this.globalKeys.pressedKeys())) continue;
            ((ScrollBehaviour)scroll.behaviour()).scroll(wheelRotation, isHorizontal, x, y);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.update();
        int mask = this.getMask(e);
        int x = e.getX();
        int y = e.getY();
        int clickMask = mask & 0xFFEFFFFF;
        for (AbstractMouseAndKeyHandler.BehaviourEntry click : this.buttonClicks) {
            if (!click.buttons().matches(mask, this.globalKeys.pressedKeys()) && (clickMask == mask || !click.buttons().matches(clickMask, this.globalKeys.pressedKeys()))) continue;
            ((ClickBehaviour)click.behaviour()).click(x, y);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.update();
        int mask = this.getMask(e);
        int x = e.getX();
        int y = e.getY();
        for (AbstractMouseAndKeyHandler.BehaviourEntry drag : this.buttonDrags) {
            if (!drag.buttons().matches(mask, this.globalKeys.pressedKeys())) continue;
            ((DragBehaviour)drag.behaviour()).init(x, y);
            this.activeButtonDrags.add(drag);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.update();
        int x = e.getX();
        int y = e.getY();
        int mask = this.getMask(e);
        ArrayList<AbstractMouseAndKeyHandler.BehaviourEntry<DragBehaviour>> ended = new ArrayList<AbstractMouseAndKeyHandler.BehaviourEntry<DragBehaviour>>();
        for (AbstractMouseAndKeyHandler.BehaviourEntry<DragBehaviour> drag : this.activeButtonDrags) {
            if (drag.buttons().matchesSubset(mask, this.globalKeys.pressedKeys())) continue;
            drag.behaviour().end(x, y);
            ended.add(drag);
        }
        this.activeButtonDrags.removeAll(ended);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.update();
        if (this.keypressManager != null) {
            this.keypressManager.activate(this.receiver);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.update();
        if (this.keypressManager != null) {
            this.keypressManager.deactivate(this.receiver);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.update();
        if (e.getKeyCode() != 0 && e.getKeyCode() != 16 && e.getKeyCode() != 157 && e.getKeyCode() != 524 && e.getKeyCode() != 18 && e.getKeyCode() != 17 && e.getKeyCode() != 65406) {
            boolean inserted = this.pressedKeys.add(e.getKeyCode());
            int mask = this.getMask(e);
            boolean doubleClick = false;
            if (inserted) {
                long lastPressTime = this.keyPressTimes.get(e.getKeyCode());
                if (lastPressTime != -1L && e.getWhen() - lastPressTime < (long)DOUBLE_CLICK_INTERVAL) {
                    doubleClick = true;
                }
                this.keyPressTimes.put(e.getKeyCode(), e.getWhen());
            }
            if (this.keypressManager != null) {
                this.keypressManager.handleKeyPressed(this.receiver, mask, doubleClick, this.globalKeys.pressedKeys());
            } else {
                this.handleKeyPressed(mask, doubleClick, this.globalKeys.pressedKeys(), false);
            }
        }
    }

    public void setKeypressManager(KeyPressedManager keypressManager, final Runnable focus) {
        this.keypressManager = keypressManager;
        this.receiver = new KeyPressedManager.KeyPressedReceiver(){

            @Override
            public void handleKeyPressed(KeyPressedManager.KeyPressedReceiver origin, int mask, boolean doubleClick, TIntSet pressedKeys) {
                if (MouseAndKeyHandler.this.handleKeyPressed(mask, doubleClick, pressedKeys, true)) {
                    focus.run();
                }
                MouseAndKeyHandler.this.handleKeyPressed(mask, doubleClick, pressedKeys, false);
            }
        };
    }

    public void setKeypressManager(KeyPressedManager keypressManager, Component focusableOwner) {
        this.setKeypressManager(keypressManager, () -> {
            if (!focusableOwner.isFocusOwner()) {
                focusableOwner.requestFocus();
            }
        });
    }

    private boolean handleKeyPressed(int mask, boolean doubleClick, TIntSet pressedKeys, boolean dryRun) {
        this.update();
        int doubleClickMask = mask | 0x100000;
        boolean triggered = false;
        for (AbstractMouseAndKeyHandler.BehaviourEntry drag : this.keyDrags) {
            if (this.activeKeyDrags.contains(drag) || !drag.buttons().matches(mask, pressedKeys) && (!doubleClick || !drag.buttons().matches(doubleClickMask, pressedKeys))) continue;
            if (dryRun) {
                return true;
            }
            triggered = true;
            ((DragBehaviour)drag.behaviour()).init(this.mouseX, this.mouseY);
            this.activeKeyDrags.add(drag);
        }
        for (AbstractMouseAndKeyHandler.BehaviourEntry click : this.keyClicks) {
            if (!click.buttons().matches(mask, pressedKeys) && (!doubleClick || !click.buttons().matches(doubleClickMask, pressedKeys))) continue;
            if (dryRun) {
                return true;
            }
            triggered = true;
            ((ClickBehaviour)click.behaviour()).click(this.mouseX, this.mouseY);
        }
        return triggered;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.update();
        if (e.getKeyCode() != 0 && e.getKeyCode() != 16 && e.getKeyCode() != 157 && e.getKeyCode() != 524 && e.getKeyCode() != 18 && e.getKeyCode() != 17 && e.getKeyCode() != 65406) {
            this.pressedKeys.remove(e.getKeyCode());
            int mask = this.getMask(e);
            ArrayList<AbstractMouseAndKeyHandler.BehaviourEntry<DragBehaviour>> ended = new ArrayList<AbstractMouseAndKeyHandler.BehaviourEntry<DragBehaviour>>();
            for (AbstractMouseAndKeyHandler.BehaviourEntry<DragBehaviour> drag : this.activeKeyDrags) {
                if (drag.buttons().matchesSubset(mask, this.globalKeys.pressedKeys())) continue;
                drag.behaviour().end(this.mouseX, this.mouseY);
                ended.add(drag);
            }
            this.activeKeyDrags.removeAll(ended);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.pressedKeys.clear();
        this.pressedKeys.addAll((TIntCollection)this.globalKeys.pressedKeys());
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.pressedKeys.clear();
    }
}

