/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class GlobalKeyEventDispatcher
implements KeyEventDispatcher {
    private final TIntSet pressedKeys = new TIntHashSet(5, 0.5f, -1);
    private boolean shiftPressed = false;
    private boolean metaPressed = false;
    private boolean winPressed = false;
    private static final GlobalKeyEventDispatcher instance = new GlobalKeyEventDispatcher();
    private static KeyEvent probeEvent = new KeyEvent(new Component(){}, 401, 0L, 0, 0, 'a');
    private static boolean probeInstalled = false;
    private static final PropertyChangeListener clearOnApplicationFocusGained = new PropertyChangeListener(){
        private long focuslosttime;

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            long t = System.currentTimeMillis();
            if (evt.getNewValue() == null) {
                this.focuslosttime = t;
            } else if (evt.getOldValue() == null && t - this.focuslosttime > 3L) {
                instance.shiftPressed = false;
                instance.metaPressed = false;
                instance.winPressed = false;
                instance.pressedKeys.clear();
            }
        }
    };

    public static GlobalKeyEventDispatcher getInstance() {
        GlobalKeyEventDispatcher.install();
        return instance;
    }

    public TIntSet pressedKeys() {
        return this.pressedKeys;
    }

    public boolean shiftPressed() {
        return this.shiftPressed;
    }

    public boolean metaPressed() {
        return this.metaPressed;
    }

    public boolean winPressed() {
        return this.winPressed;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        int id = e.getID();
        if (id == 401) {
            if (e == probeEvent) {
                probeInstalled = true;
                return true;
            }
            this.keyPressed(e);
        } else if (id == 402) {
            this.keyReleased(e);
        }
        return false;
    }

    private void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.shiftPressed = true;
        } else if (e.getKeyCode() == 157) {
            this.metaPressed = true;
        } else if (e.getKeyCode() == 524) {
            this.winPressed = true;
        } else if (e.getKeyCode() != 0 && e.getKeyCode() != 18 && e.getKeyCode() != 17 && e.getKeyCode() != 65406) {
            this.pressedKeys.add(e.getKeyCode());
        }
    }

    private void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 16) {
            this.shiftPressed = false;
        } else if (e.getKeyCode() == 157) {
            this.metaPressed = false;
        } else if (e.getKeyCode() == 524) {
            this.winPressed = false;
        } else if (e.getKeyCode() != 0 && e.getKeyCode() != 18 && e.getKeyCode() != 17 && e.getKeyCode() != 65406) {
            this.pressedKeys.remove(e.getKeyCode());
        }
    }

    private GlobalKeyEventDispatcher() {
    }

    private static void install() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        probeInstalled = false;
        focusManager.dispatchEvent(probeEvent);
        if (!probeInstalled) {
            focusManager.addKeyEventDispatcher(instance);
            focusManager.addPropertyChangeListener("activeWindow", clearOnApplicationFocusGained);
        }
    }
}

