/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.CompressionAdapter;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.LinkedAttributePathToken;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5URI;

public interface GsonUtils {
    public static Gson registerGson(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter((Type)((Object)DataType.class), new DataType.JsonAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(Compression.class, CompressionAdapter.getJsonAdapter());
        gsonBuilder.disableHtmlEscaping();
        return gsonBuilder.create();
    }

    public static JsonElement readAttributes(Reader reader, Gson gson) throws IOException {
        JsonElement json = gson.fromJson(reader, JsonElement.class);
        return json;
    }

    public static <T> T readAttribute(JsonElement root, String normalizedAttributePath, Class<T> cls, Gson gson) throws JsonSyntaxException, NumberFormatException, ClassCastException {
        return GsonUtils.readAttribute(root, normalizedAttributePath, TypeToken.get(cls).getType(), gson);
    }

    public static <T> T readAttribute(JsonElement root, String normalizedAttributePath, Type type, Gson gson) throws JsonSyntaxException, NumberFormatException, ClassCastException {
        JsonElement attribute = GsonUtils.getAttribute(root, normalizedAttributePath);
        return GsonUtils.parseAttributeElement(attribute, gson, type);
    }

    public static <T> T parseAttributeElement(JsonElement attribute, Gson gson, Type type) throws JsonSyntaxException, NumberFormatException, ClassCastException {
        block10: {
            Class clazz;
            if (attribute == null) {
                return null;
            }
            Class clazz2 = clazz = type instanceof Class ? (Class)type : null;
            if (clazz != null && clazz.isAssignableFrom(HashMap.class)) {
                Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
                Map retMap = (Map)gson.fromJson(attribute, mapType);
                return (T)retMap;
            }
            if (attribute instanceof JsonArray) {
                JsonArray array = attribute.getAsJsonArray();
                try {
                    T retArray = GsonUtils.getJsonAsArray(gson, array, type);
                    if (retArray != null) {
                        return retArray;
                    }
                }
                catch (JsonSyntaxException e) {
                    if (type != String.class) break block10;
                    return (T)gson.toJson(attribute);
                }
            }
        }
        try {
            Object parsedResult = gson.fromJson(attribute, type);
            if (parsedResult == null) {
                throw new ClassCastException("Cannot parse json as type " + type.getTypeName());
            }
            return parsedResult;
        }
        catch (JsonSyntaxException e) {
            if (type == String.class) {
                return (T)gson.toJson(attribute);
            }
            throw e;
        }
    }

    public static JsonElement getAttribute(JsonElement root, String normalizedAttributePath) {
        String[] pathParts = normalizedAttributePath.split("(?<!\\\\)/");
        for (int i = 0; i < pathParts.length; ++i) {
            String pathPart = pathParts[i];
            if (pathPart.isEmpty()) continue;
            String pathPartWithoutEscapeCharacters = pathPart.replaceAll("\\\\/", "/").replaceAll("\\\\\\[", "[");
            if (root instanceof JsonObject && root.getAsJsonObject().get(pathPartWithoutEscapeCharacters) != null) {
                JsonObject jsonObject = root.getAsJsonObject();
                root = jsonObject.get(pathPartWithoutEscapeCharacters);
                continue;
            }
            Matcher matcher = N5URI.ARRAY_INDEX.matcher(pathPart);
            if (root != null && root.isJsonArray() && matcher.matches()) {
                JsonArray jsonArray;
                int index = Integer.parseInt(matcher.group().replace("[", "").replace("]", ""));
                if (index >= (jsonArray = root.getAsJsonArray()).size()) {
                    return null;
                }
                root = jsonArray.get(index);
                continue;
            }
            return null;
        }
        return root;
    }

    public static Map<String, Class<?>> listAttributes(JsonElement root) throws N5Exception.N5IOException {
        if (root == null) {
            return new HashMap();
        }
        if (!root.isJsonObject()) {
            throw new N5Exception("JsonElement found, but was not JsonObject");
        }
        HashMap attributes = new HashMap();
        root.getAsJsonObject().entrySet().forEach(entry -> {
            Class<Object> clazz;
            String key = (String)entry.getKey();
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (jsonElement.isJsonNull()) {
                clazz = null;
            } else if (jsonElement.isJsonPrimitive()) {
                clazz = GsonUtils.classForJsonPrimitive((JsonPrimitive)jsonElement);
            } else if (jsonElement.isJsonArray()) {
                JsonArray jsonArray = (JsonArray)jsonElement;
                Class arrayElementClass = Object.class;
                if (jsonArray.size() > 0) {
                    JsonElement firstElement = jsonArray.get(0);
                    if (firstElement.isJsonPrimitive()) {
                        arrayElementClass = GsonUtils.classForJsonPrimitive(firstElement.getAsJsonPrimitive());
                        for (int i = 1; i < jsonArray.size() && arrayElementClass != Object.class; ++i) {
                            JsonElement element = jsonArray.get(i);
                            if (element.isJsonPrimitive()) {
                                Class<?> nextArrayElementClass = GsonUtils.classForJsonPrimitive(element.getAsJsonPrimitive());
                                if (nextArrayElementClass == arrayElementClass) continue;
                                if (nextArrayElementClass == Double.TYPE && arrayElementClass == Long.TYPE) {
                                    arrayElementClass = Double.TYPE;
                                    continue;
                                }
                                arrayElementClass = Object.class;
                                break;
                            }
                            arrayElementClass = Object.class;
                            break;
                        }
                    }
                    clazz = Array.newInstance(arrayElementClass, 0).getClass();
                } else {
                    clazz = Object[].class;
                }
            } else {
                clazz = Object.class;
            }
            attributes.put(key, clazz);
        });
        return attributes;
    }

    public static <T> T getJsonAsArray(Gson gson, JsonArray array, Class<T> cls) {
        return GsonUtils.getJsonAsArray(gson, array, TypeToken.get(cls).getType());
    }

    public static <T> T getJsonAsArray(Gson gson, JsonArray array, Type type) {
        Class clazz;
        Class clazz2 = clazz = type instanceof Class ? (Class)type : null;
        if (type == boolean[].class) {
            boolean[] retArray = new boolean[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                Boolean value = gson.fromJson(array.get(i), Boolean.TYPE);
                retArray[i] = value;
            }
            return (T)retArray;
        }
        if (type == double[].class) {
            double[] retArray = new double[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                double value;
                retArray[i] = value = gson.fromJson(array.get(i), Double.TYPE).doubleValue();
            }
            return (T)retArray;
        }
        if (type == float[].class) {
            float[] retArray = new float[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                float value;
                retArray[i] = value = gson.fromJson(array.get(i), Float.TYPE).floatValue();
            }
            return (T)retArray;
        }
        if (type == long[].class) {
            long[] retArray = new long[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                long value;
                retArray[i] = value = gson.fromJson(array.get(i), Long.TYPE).longValue();
            }
            return (T)retArray;
        }
        if (type == short[].class) {
            short[] retArray = new short[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                short value;
                retArray[i] = value = gson.fromJson(array.get(i), Short.TYPE).shortValue();
            }
            return (T)retArray;
        }
        if (type == int[].class) {
            int[] retArray = new int[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                int value;
                retArray[i] = value = gson.fromJson(array.get(i), Integer.TYPE).intValue();
            }
            return (T)retArray;
        }
        if (type == byte[].class) {
            byte[] retArray = new byte[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                byte value;
                retArray[i] = value = gson.fromJson(array.get(i), Byte.TYPE).byteValue();
            }
            return (T)retArray;
        }
        if (type == char[].class) {
            char[] retArray = new char[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                char value;
                retArray[i] = value = gson.fromJson(array.get(i), Character.TYPE).charValue();
            }
            return (T)retArray;
        }
        if (clazz != null && clazz.isArray()) {
            Class<?> componentCls = clazz.getComponentType();
            Object[] clsArray = (Object[])Array.newInstance(componentCls, array.size());
            for (int i = 0; i < array.size(); ++i) {
                clsArray[i] = gson.fromJson(array.get(i), componentCls);
            }
            return (T)clsArray;
        }
        return null;
    }

    public static Class<?> classForJsonPrimitive(JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isBoolean()) {
            return Boolean.TYPE;
        }
        if (jsonPrimitive.isNumber()) {
            Number number = jsonPrimitive.getAsNumber();
            if ((double)number.longValue() == number.doubleValue()) {
                return Long.TYPE;
            }
            return Double.TYPE;
        }
        if (jsonPrimitive.isString()) {
            return String.class;
        }
        return Object.class;
    }

    public static <T> T removeAttribute(Writer writer, JsonElement root, String normalizedAttributePath, Class<T> cls, Gson gson) throws JsonSyntaxException, NumberFormatException, ClassCastException, IOException {
        T removed = GsonUtils.removeAttribute(root, normalizedAttributePath, cls, gson);
        if (removed != null) {
            GsonUtils.writeAttributes(writer, root, gson);
        }
        return removed;
    }

    public static boolean removeAttribute(Writer writer, JsonElement root, String normalizedAttributePath, Gson gson) throws JsonSyntaxException, NumberFormatException, ClassCastException, IOException {
        JsonElement removed = GsonUtils.removeAttribute(root, normalizedAttributePath, JsonElement.class, gson);
        if (removed != null) {
            GsonUtils.writeAttributes(writer, root, gson);
            return true;
        }
        return false;
    }

    public static <T> T removeAttribute(JsonElement root, String normalizedAttributePath, Class<T> cls, Gson gson) throws JsonSyntaxException, NumberFormatException, ClassCastException {
        T attribute = GsonUtils.readAttribute(root, normalizedAttributePath, cls, gson);
        if (attribute != null) {
            GsonUtils.removeAttribute(root, normalizedAttributePath);
        }
        return attribute;
    }

    public static JsonElement removeAttribute(JsonElement root, String normalizedAttributePath) {
        String[] pathParts = normalizedAttributePath.split("(?<!\\\\)/");
        for (int i = 0; i < pathParts.length; ++i) {
            String pathPart = pathParts[i];
            if (pathPart.isEmpty()) continue;
            String pathPartWithoutEscapeCharacters = pathPart.replaceAll("\\\\/", "/").replaceAll("\\\\\\[", "[");
            if (root instanceof JsonObject && root.getAsJsonObject().get(pathPartWithoutEscapeCharacters) != null) {
                JsonObject jsonObject = root.getAsJsonObject();
                root = jsonObject.get(pathPartWithoutEscapeCharacters);
                if (i != pathParts.length - 1) continue;
                jsonObject.remove(pathPartWithoutEscapeCharacters);
                continue;
            }
            Matcher matcher = N5URI.ARRAY_INDEX.matcher(pathPart);
            if (root != null && root.isJsonArray() && matcher.matches()) {
                JsonArray jsonArray;
                int index = Integer.parseInt(matcher.group().replace("[", "").replace("]", ""));
                if (index >= (jsonArray = root.getAsJsonArray()).size()) {
                    return null;
                }
                root = jsonArray.get(index);
                if (i != pathParts.length - 1) continue;
                jsonArray.remove(index);
                continue;
            }
            return null;
        }
        return root;
    }

    public static <T> void writeAttribute(Writer writer, JsonElement root, String normalizedAttributePath, T attribute, Gson gson) throws IOException {
        root = GsonUtils.insertAttribute(root, normalizedAttributePath, attribute, gson);
        GsonUtils.writeAttributes(writer, root, gson);
    }

    public static <T> void writeAttributes(Writer writer, JsonElement root, Gson gson) throws IOException {
        gson.toJson(root, (Appendable)writer);
        writer.flush();
    }

    public static JsonElement insertAttributes(JsonElement root, Map<String, ?> attributes, Gson gson) {
        for (Map.Entry<String, ?> attribute : attributes.entrySet()) {
            root = GsonUtils.insertAttribute(root, N5URI.normalizeAttributePath(attribute.getKey()), attribute.getValue(), gson);
        }
        return root;
    }

    public static <T> JsonElement insertAttribute(JsonElement root, String normalizedAttributePath, T attribute, Gson gson) {
        LinkedAttributePathToken<?> pathToken = N5URI.getAttributePathTokens(normalizedAttributePath);
        if (pathToken == null) {
            return gson.toJsonTree(attribute);
        }
        JsonElement json = root;
        while (pathToken != null) {
            boolean rootOverriden;
            JsonElement parent = pathToken.setAndCreateParentElement(json);
            boolean bl = rootOverriden = json == root && parent != json;
            if (root == null || rootOverriden) {
                root = parent;
            }
            json = pathToken.writeChild(gson, attribute);
            pathToken = pathToken.next();
        }
        return root;
    }
}

