/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import org.janelia.saalfeldlab.n5.Bzip2Compression;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.GzipCompression;
import org.janelia.saalfeldlab.n5.Lz4Compression;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.XzCompression;

public class DatasetAttributes
implements Serializable {
    private static final long serialVersionUID = -4521467080388947553L;
    public static final String DIMENSIONS_KEY = "dimensions";
    public static final String BLOCK_SIZE_KEY = "blockSize";
    public static final String DATA_TYPE_KEY = "dataType";
    public static final String COMPRESSION_KEY = "compression";
    protected static final String compressionTypeKey = "compressionType";
    private final long[] dimensions;
    private final int[] blockSize;
    private final DataType dataType;
    private final Compression compression;

    public DatasetAttributes(long[] dimensions, int[] blockSize, DataType dataType, Compression compression) {
        this.dimensions = dimensions;
        this.blockSize = blockSize;
        this.dataType = dataType;
        this.compression = compression;
    }

    public long[] getDimensions() {
        return this.dimensions;
    }

    public int getNumDimensions() {
        return this.dimensions.length;
    }

    public int[] getBlockSize() {
        return this.blockSize;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public HashMap<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(DIMENSIONS_KEY, this.dimensions);
        map.put(BLOCK_SIZE_KEY, this.blockSize);
        map.put(DATA_TYPE_KEY, (Object)this.dataType);
        map.put(COMPRESSION_KEY, this.compression);
        return map;
    }

    static DatasetAttributes from(long[] dimensions, DataType dataType, int[] blockSize, Compression compression, String compressionVersion0Name) {
        if (blockSize == null) {
            blockSize = Arrays.stream(dimensions).mapToInt(a -> (int)a).toArray();
        }
        if (compression == null) {
            switch (compressionVersion0Name) {
                case "raw": {
                    compression = new RawCompression();
                    break;
                }
                case "gzip": {
                    compression = new GzipCompression();
                    break;
                }
                case "bzip2": {
                    compression = new Bzip2Compression();
                    break;
                }
                case "lz4": {
                    compression = new Lz4Compression();
                    break;
                }
                case "xz": {
                    compression = new XzCompression();
                }
            }
        }
        return new DatasetAttributes(dimensions, blockSize, dataType, compression);
    }
}

