/*
 * Decompiled with CFR 0.152.
 */
package stitching;

import stitching.FloatArray;

public class FloatArray3D
extends FloatArray {
    public final int width;
    public final int height;
    public final int depth;

    public FloatArray3D(float[] data, int width, int height, int depth) {
        this.data = data;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public FloatArray3D(int width, int height, int depth) {
        this.data = new float[width * height * depth];
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    @Override
    public FloatArray3D clone() {
        FloatArray3D clone = new FloatArray3D(this.width, this.height, this.depth);
        System.arraycopy(this.data, 0, clone.data, 0, this.data.length);
        return clone;
    }

    public int getPos(int x, int y, int z) {
        return x + this.width * (y + z * this.height);
    }

    public float get(int x, int y, int z) {
        return this.data[this.getPos(x, y, z)];
    }

    public float getMirror(int x, int y, int z) {
        int dir;
        int tmp;
        if (x >= this.width) {
            x = this.width - (x - this.width + 2);
        }
        if (y >= this.height) {
            y = this.height - (y - this.height + 2);
        }
        if (z >= this.depth) {
            z = this.depth - (z - this.depth + 2);
        }
        if (x < 0) {
            tmp = 0;
            dir = 1;
            while (x < 0) {
                if ((tmp += dir) == this.width - 1 || tmp == 0) {
                    dir *= -1;
                }
                ++x;
            }
            x = tmp;
        }
        if (y < 0) {
            tmp = 0;
            dir = 1;
            while (y < 0) {
                if ((tmp += dir) == this.height - 1 || tmp == 0) {
                    dir *= -1;
                }
                ++y;
            }
            y = tmp;
        }
        if (z < 0) {
            tmp = 0;
            dir = 1;
            while (z < 0) {
                if ((tmp += dir) == this.depth - 1 || tmp == 0) {
                    dir *= -1;
                }
                ++z;
            }
            z = tmp;
        }
        return this.data[this.getPos(x, y, z)];
    }

    public float getZero(int x, int y, int z) {
        if (x >= this.width) {
            return 0.0f;
        }
        if (y >= this.height) {
            return 0.0f;
        }
        if (z >= this.depth) {
            return 0.0f;
        }
        if (x < 0) {
            return 0.0f;
        }
        if (y < 0) {
            return 0.0f;
        }
        if (z < 0) {
            return 0.0f;
        }
        return this.data[this.getPos(x, y, z)];
    }

    public void set(float value, int x, int y, int z) {
        this.data[this.getPos((int)x, (int)y, (int)z)] = value;
    }
}

