/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching;

import ij.ImagePlus;
import mpicbg.models.Model;
import mpicbg.stitching.ImagePlusTimePoint;

public class ComparePair {
    final ImagePlusTimePoint impA;
    final ImagePlusTimePoint impB;
    float crossCorrelation;
    boolean validOverlap;
    float[] relativeShift;

    public ComparePair(ImagePlusTimePoint impA, ImagePlusTimePoint impB) {
        this.impA = impA;
        this.impB = impB;
        this.validOverlap = true;
    }

    public ImagePlusTimePoint getTile1() {
        return this.impA;
    }

    public ImagePlusTimePoint getTile2() {
        return this.impB;
    }

    public ImagePlus getImagePlus1() {
        return this.impA.getImagePlus();
    }

    public ImagePlus getImagePlus2() {
        return this.impB.getImagePlus();
    }

    public int getTimePoint1() {
        return this.impA.getTimePoint();
    }

    public int getTimePoint2() {
        return this.impB.getTimePoint();
    }

    public Model<?> getModel1() {
        return this.impA.getModel();
    }

    public Model<?> getModel2() {
        return this.impB.getModel();
    }

    public void setCrossCorrelation(float r) {
        this.crossCorrelation = r;
    }

    public float getCrossCorrelation() {
        return this.crossCorrelation;
    }

    public void setRelativeShift(float[] relativeShift) {
        this.relativeShift = relativeShift;
    }

    public float[] getRelativeShift() {
        return this.relativeShift;
    }

    public void setIsValidOverlap(boolean state) {
        this.validOverlap = state;
    }

    public boolean getIsValidOverlap() {
        return this.validOverlap;
    }
}

