/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.mosaic.Projector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ProjectorTest
extends TestCase {
    private static final double eps = 1.0E-10;

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(ProjectorTest.class);
        TestResult result = TestRunner.run((Test)suite);
        if (!result.wasSuccessful()) {
            ProjectorTest.fail((String)"Tests failed.");
        }
    }

    public void testMergeA() {
        Projector pa = new Projector(0.0, 1.0);
        Projector pb = new Projector(0.0, 1.0);
        pa.merge(pb);
        Projector expected = new Projector(0.0, 1.0);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMergeB() {
        Projector pa = new Projector(0.0, 1.0);
        Projector pb = new Projector(1.0, 0.0);
        pa.merge(pb);
        Projector expected = new Projector(0.0, 1.0);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMergeC() {
        Projector pa = new Projector(1.0, 0.0);
        Projector pb = new Projector(0.0, 1.0);
        pa.merge(pb);
        Projector expected = new Projector(1.0, 0.0);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMergeD() {
        Projector pa = new Projector(1.0, 0.0);
        Projector pb = new Projector(1.0, 0.0);
        pa.merge(pb);
        Projector expected = new Projector(1.0, 0.0);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMergeE() {
        Projector pa = new Projector(10.0, 0.0);
        Projector pb = new Projector(1.0, 11.0);
        pa.merge(pb);
        Projector expected = new Projector(11.0, 0.0);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMergeF() {
        Projector pa = new Projector(10.0, 5.0);
        Projector pb = new Projector(1.0, 11.0);
        pa.merge(pb);
        Projector expected = new Projector(11.0, 1.0);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMergeG() {
        Projector pa = new Projector(1.0, 11.0);
        Projector pb = new Projector(10.0, 0.0);
        pa.merge(pb);
        Projector expected = new Projector(0.0, 11.0);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMergeH() {
        Projector pa = new Projector(1.5, 1.4);
        Projector pb = new Projector(1.0, 2.0);
        pa.merge(pb);
        Projector expected = new Projector(2.0, 1.0);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMerge1() {
        Projector pa = new Projector(10.0, 20.0, 0.1, 0.8);
        Projector pb = new Projector(10.0, 20.0, 0.0, 1.0);
        pa.merge(pb);
        Projector expected = new Projector(10.0, 20.0, 0.1, 0.8);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMerge1r() {
        Projector pa = new Projector(10.0, 20.0, 0.0, 1.0);
        Projector pb = new Projector(10.0, 20.0, 0.1, 0.8);
        pa.merge(pb);
        Projector expected = new Projector(10.0, 20.0, 0.1, 0.8);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMerge2() {
        Projector pa = new Projector(10.0, 20.0, 0.1, 0.8);
        Projector pb = new Projector(20.0, 10.0, 0.0, 1.0);
        pa.merge(pb);
        Projector expected = new Projector(10.0, 20.0, 0.1, 0.8);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMerge2r() {
        Projector pa = new Projector(20.0, 10.0, 0.0, 1.0);
        Projector pb = new Projector(10.0, 20.0, 0.1, 0.8);
        pa.merge(pb);
        Projector expected = new Projector(20.0, 10.0, 0.2, 0.9);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMerge3() {
        Projector pa = new Projector(10.0, 20.0, 0.0, 1.0);
        Projector pb = new Projector(20.0, 10.0, 0.1, 0.8);
        pa.merge(pb);
        Projector expected = new Projector(10.0, 20.0, 0.2, 0.9);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testMerge3r() {
        Projector pa = new Projector(20.0, 10.0, 0.1, 0.8);
        Projector pb = new Projector(10.0, 20.0, 0.0, 1.0);
        pa.merge(pb);
        Projector expected = new Projector(20.0, 10.0, 0.1, 0.8);
        ProjectorTest.assertVeryClose(expected, pa);
    }

    public void testAsserting() {
        try {
            assert (false);
            ProjectorTest.fail((String)"Assertions not enabled!");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    private static void assertVeryClose(Projector expected, Projector actual) {
        boolean success = true;
        success &= Math.abs(expected.u0() - actual.u0()) <= 1.0E-10;
        success &= Math.abs(expected.u1() - actual.u1()) <= 1.0E-10;
        success &= Math.abs(expected.v0() - actual.v0()) <= 1.0E-10;
        if (!(success &= Math.abs(expected.v1() - actual.v1()) <= 1.0E-10)) {
            ProjectorTest.fail((String)("Expected: <" + expected + "> but was:<" + actual + ">"));
        }
    }
}

