/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.icp;

import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.Callable;
import mpicbg.icp.ICP;
import mpicbg.models.AbstractModel;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.TranslationModel3D;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import net.imglib2.util.Util;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.process.interestpointregistration.Detection;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.TransformationModel;
import spim.process.interestpointregistration.icp.IterativeClosestPointParameters;

public class IterativeClosestPointPairwise
implements Callable<PairwiseMatch> {
    final PairwiseMatch pair;
    final TransformationModel model;
    final IterativeClosestPointParameters ip;
    final String comparison;

    public IterativeClosestPointPairwise(PairwiseMatch pair, TransformationModel model, String comparison, IterativeClosestPointParameters ip) {
        this.pair = pair;
        this.ip = ip;
        this.model = model;
        this.comparison = comparison;
    }

    @Override
    public PairwiseMatch call() {
        ArrayList<Detection> listA = new ArrayList<Detection>();
        ArrayList<Detection> listB = new ArrayList<Detection>();
        for (InterestPoint interestPoint : this.pair.getListA()) {
            listA.add(new Detection(interestPoint.getId(), interestPoint.getL()));
        }
        for (InterestPoint interestPoint : this.pair.getListB()) {
            listB.add(new Detection(interestPoint.getId(), interestPoint.getL()));
        }
        AbstractModel model = this.model.getModel();
        if (listA.size() < model.getMinNumMatches() || listB.size() < model.getMinNumMatches()) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): " + this.comparison + ": Not enough detections to match (" + model.getMinNumMatches() + " required per list, |listA|= " + listA.size() + ", |listB|= " + listB.size() + ")");
            this.pair.setCandidates(new ArrayList<PointMatchGeneric<Detection>>());
            this.pair.setInliers(new ArrayList<PointMatchGeneric<Detection>>(), Double.NaN);
            return this.pair;
        }
        for (Detection d : listA) {
            d.setUseW(true);
        }
        for (Detection d : listB) {
            d.setUseW(true);
        }
        ICP iCP = new ICP(listA, listB, (float)this.ip.getMaxDistance());
        int i = 0;
        double lastAvgError = 0.0;
        int lastNumCorresponding = 0;
        boolean converged = false;
        do {
            try {
                iCP.runICPIteration((Model<?>)model, (Model<?>)model);
            }
            catch (NotEnoughDataPointsException e) {
                IterativeClosestPointPairwise.failWith("ICP", "NotEnoughDataPointsException", this.pair, (Exception)((Object)e));
                return this.pair;
            }
            catch (IllDefinedDataPointsException e) {
                IterativeClosestPointPairwise.failWith("ICP", "IllDefinedDataPointsException", this.pair, (Exception)((Object)e));
                return this.pair;
            }
            catch (NoSuitablePointsException e) {
                IterativeClosestPointPairwise.failWith("ICP", "NoSuitablePointsException", this.pair, e);
                return this.pair;
            }
            if (lastNumCorresponding == iCP.getNumPointMatches() && lastAvgError == iCP.getAverageError()) {
                converged = true;
            }
            lastNumCorresponding = iCP.getNumPointMatches();
            lastAvgError = iCP.getAverageError();
            System.out.println(i + ": " + iCP.getNumPointMatches() + " matches, avg error [px] " + iCP.getAverageError() + ", max error [px] " + iCP.getMaximalError());
        } while (!converged && ++i < this.ip.getMaxNumIterations());
        ArrayList<PointMatchGeneric<Detection>> inliers = new ArrayList<PointMatchGeneric<Detection>>();
        for (PointMatch pm : iCP.getPointMatches()) {
            inliers.add(new PointMatchGeneric<Detection>((Detection)pm.getP1(), (Detection)pm.getP2()));
        }
        this.pair.setCandidates(inliers);
        this.pair.setInliers(inliers, iCP.getAverageError());
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): " + this.comparison + ": Found " + iCP.getNumPointMatches() + " matches, avg error [px] " + iCP.getAverageError() + " after " + i + " iterations");
        return this.pair;
    }

    public static void failWith(String algo, String exType, PairwiseMatch pair, Exception e) {
        IOFunctions.println(algo + " failed with " + exType + " matching TP=" + pair.getViewIdA().getTimePointId() + ", ViewSetup=" + pair.getViewIdA().getViewSetupId() + " to TP=" + pair.getViewIdB().getTimePointId() + ", ViewSetup=" + pair.getViewIdB().getViewSetupId() + ": " + e);
        pair.setCandidates(new ArrayList<PointMatchGeneric<Detection>>());
        pair.setInliers(new ArrayList<PointMatchGeneric<Detection>>(), Double.NaN);
    }

    public static void main(String[] args) throws Exception {
        int i;
        ArrayList<Detection> listA = new ArrayList<Detection>();
        ArrayList<Detection> listB = new ArrayList<Detection>();
        listA.add(new Detection(0, new double[]{10.0, 10.0, 0.0}));
        listB.add(new Detection(0, new double[]{11.0, 13.0, 0.0}));
        Random rnd = new Random(43534L);
        float maxError = 4.0f;
        for (i = 0; i < 5; ++i) {
            float x = rnd.nextFloat() * 10000.0f + 150.0f;
            float y = rnd.nextFloat() * 10000.0f + 150.0f;
            listA.add(new Detection(i, new double[]{x, y, 0.0}));
            listB.add(new Detection(i, new double[]{x + 2.0f, y + 4.0f, 0.0}));
        }
        for (i = 0; i < listA.size(); ++i) {
            ((Detection)((Object)listA.get(i))).setUseW(true);
            ((Detection)((Object)listB.get(i))).setUseW(true);
            IOFunctions.println(Util.printCoordinates((double[])((Detection)((Object)listA.get(i))).getL()) + " >>> " + Util.printCoordinates((double[])((Detection)((Object)listB.get(i))).getL()) + ", d=" + Point.distance((Point)((Point)listA.get(i)), (Point)((Point)listB.get(i))));
        }
        ICP icp = new ICP(listA, listB, 4.0);
        TranslationModel3D model = new TranslationModel3D();
        int i2 = 0;
        double lastAvgError = 0.0;
        int lastNumCorresponding = 0;
        boolean converged = false;
        do {
            System.out.println("\n" + i2);
            System.out.println("lastModel: " + model.toString());
            try {
                icp.runICPIteration((Model<?>)model, (Model<?>)model);
            }
            catch (NotEnoughDataPointsException e) {
                throw new NotEnoughDataPointsException((Throwable)e);
            }
            catch (IllDefinedDataPointsException e) {
                throw new IllDefinedDataPointsException((Throwable)e);
            }
            catch (NoSuitablePointsException e) {
                throw new NoSuitablePointsException(e.toString());
            }
            System.out.println("newModel: " + model.toString());
            System.out.println("lastError: " + lastAvgError + ", lastNumCorresponding: " + lastNumCorresponding);
            System.out.println("thisError: " + icp.getAverageError() + ", thisNumCorresponding: " + icp.getAverageError());
            if (lastNumCorresponding == icp.getNumPointMatches() && lastAvgError == icp.getAverageError()) {
                converged = true;
            }
            lastNumCorresponding = icp.getNumPointMatches();
            lastAvgError = icp.getAverageError();
            System.out.println(i2 + ": " + icp.getNumPointMatches() + " matches, avg error [px] " + icp.getAverageError() + ", max error [px] " + icp.getMaximalError());
        } while (!converged && ++i2 < 100);
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Found " + icp.getNumPointMatches() + " matches, avg error [px] " + icp.getAverageError() + " after " + i2 + " iterations");
    }
}

