/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration.geometrichashing;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import net.imglib2.util.Pair;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.process.interestpointregistration.Detection;
import spim.process.interestpointregistration.PairwiseMatch;
import spim.process.interestpointregistration.RANSAC;
import spim.process.interestpointregistration.RANSACParameters;
import spim.process.interestpointregistration.TransformationModel;
import spim.process.interestpointregistration.geometrichashing.GeometricHasher;
import spim.process.interestpointregistration.geometrichashing.GeometricHashingParameters;

public class GeometricHashingPairwise
implements Callable<PairwiseMatch> {
    final PairwiseMatch pair;
    final TransformationModel model;
    final RANSACParameters rp;
    final GeometricHashingParameters gp;
    final String comparison;

    public GeometricHashingPairwise(PairwiseMatch pair, TransformationModel model, String comparison, RANSACParameters rp, GeometricHashingParameters gp) {
        this.pair = pair;
        this.rp = rp;
        this.gp = gp;
        this.model = model;
        this.comparison = comparison;
    }

    public GeometricHashingPairwise(PairwiseMatch pair, TransformationModel model, String comparison, RANSACParameters rp) {
        this(pair, model, comparison, rp, new GeometricHashingParameters());
    }

    public GeometricHashingPairwise(PairwiseMatch pair, TransformationModel model, String comparison) {
        this(pair, model, comparison, new RANSACParameters(), new GeometricHashingParameters());
    }

    @Override
    public PairwiseMatch call() {
        GeometricHasher hasher = new GeometricHasher();
        ArrayList<Detection> listA = new ArrayList<Detection>();
        ArrayList<Detection> listB = new ArrayList<Detection>();
        for (InterestPoint i : this.pair.getListA()) {
            listA.add(new Detection(i.getId(), i.getL()));
        }
        for (InterestPoint i : this.pair.getListB()) {
            listB.add(new Detection(i.getId(), i.getL()));
        }
        if (listA.size() < 4 || listB.size() < 4) {
            IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): " + this.comparison + ": Not enough detections to match (4 required per list, |listA|= " + listA.size() + ", |listB|= " + listB.size() + ")");
            this.pair.setCandidates(new ArrayList<PointMatchGeneric<Detection>>());
            this.pair.setInliers(new ArrayList<PointMatchGeneric<Detection>>(), Double.NaN);
            return this.pair;
        }
        ArrayList<PointMatchGeneric<Detection>> candidates = hasher.extractCorrespondenceCandidates(listA, listB, this.gp.getDifferenceThreshold(), this.gp.getRatioOfDistance(), this.gp.getUseAssociatedBeads());
        this.pair.setCandidates(candidates);
        ArrayList<PointMatchGeneric<Detection>> inliers = new ArrayList<PointMatchGeneric<Detection>>();
        Pair<String, Double> result = RANSAC.computeRANSAC(candidates, inliers, this.model.getModel(), this.rp.getMaxEpsilon(), this.rp.getMinInlierRatio(), this.rp.getMinInlierFactor(), this.rp.getNumIterations());
        this.pair.setInliers(inliers, (Double)result.getB());
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): " + this.comparison + ": " + (String)result.getA());
        return this.pair;
    }
}

