/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointdetection;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.registration.bead.laplace.LaPlaceFunctions;
import mpicbg.spim.segmentation.SimplePeak;
import net.imglib2.img.Img;
import net.imglib2.util.Util;
import spim.Threads;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.process.cuda.CUDADevice;
import spim.process.cuda.CUDASeparableConvolution;
import spim.process.fusion.FusionHelper;
import spim.process.interestpointdetection.DifferenceOfGaussianCUDA;
import spim.process.interestpointdetection.DifferenceOfGaussianNewPeakFinder;
import spim.process.interestpointdetection.Localization;

public class ProcessDOG {
    public static ArrayList<InterestPoint> compute(CUDASeparableConvolution cuda, List<CUDADevice> deviceList, boolean accurateCUDA, double percentGPUMem, Image<FloatType> img, Img<net.imglib2.type.numeric.real.FloatType> imglib2img, float sigma, float threshold, int localization, double imageSigmaX, double imageSigmaY, double imageSigmaZ, boolean findMin, boolean findMax, double minIntensity, double maxIntensity, boolean keepIntensity) {
        ArrayList<InterestPoint> finalPeaks;
        float max;
        float min;
        float initialSigma = sigma;
        float minPeakValue = threshold;
        float minInitialPeakValue = localization == 0 ? minPeakValue : threshold / 10.0f;
        if (Double.isNaN(minIntensity) || Double.isNaN(maxIntensity) || Double.isInfinite(minIntensity) || Double.isInfinite(maxIntensity) || minIntensity == maxIntensity) {
            float[] minmax = FusionHelper.minMax(imglib2img);
            min = minmax[0];
            max = minmax[1];
        } else {
            min = (float)minIntensity;
            max = (float)maxIntensity;
        }
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): min intensity = " + min + ", max intensity = " + max);
        FusionHelper.normalizeImage(imglib2img, min, max);
        float k = LaPlaceFunctions.computeK(4);
        float K_MIN1_INV = LaPlaceFunctions.computeKWeight(k);
        int steps = 3;
        float[] sigmaStepsX = LaPlaceFunctions.computeSigma(3, k, initialSigma);
        float[] sigmaStepsDiffX = LaPlaceFunctions.computeSigmaDiff(sigmaStepsX, (float)imageSigmaX);
        float[] sigmaStepsY = LaPlaceFunctions.computeSigma(3, k, initialSigma);
        float[] sigmaStepsDiffY = LaPlaceFunctions.computeSigmaDiff(sigmaStepsY, (float)imageSigmaY);
        float[] sigmaStepsZ = LaPlaceFunctions.computeSigma(3, k, initialSigma);
        float[] sigmaStepsDiffZ = LaPlaceFunctions.computeSigmaDiff(sigmaStepsZ, (float)imageSigmaZ);
        double[] sigma1 = new double[]{sigmaStepsDiffX[0], sigmaStepsDiffY[0], sigmaStepsDiffZ[0]};
        double[] sigma2 = new double[]{sigmaStepsDiffX[1], sigmaStepsDiffY[1], sigmaStepsDiffZ[1]};
        DifferenceOfGaussianNewPeakFinder dog = deviceList == null ? new DifferenceOfGaussianNewPeakFinder(img, (OutOfBoundsStrategyFactory<FloatType>)new OutOfBoundsStrategyMirrorFactory(), sigma1, sigma2, minInitialPeakValue, K_MIN1_INV) : new DifferenceOfGaussianCUDA(cuda, percentGPUMem, deviceList, img, imglib2img, accurateCUDA, sigma1, sigma2, minInitialPeakValue, K_MIN1_INV);
        dog.setComputeConvolutionsParalell(false);
        dog.setNumThreads(Threads.numThreads());
        if (localization == 1) {
            dog.setKeepDoGImage(true);
        } else {
            dog.setKeepDoGImage(false);
        }
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): computing difference-of-gausian (sigma=" + initialSigma + ", threshold=" + minPeakValue + ", sigma1=" + Util.printCoordinates((double[])sigma1) + ", sigma2=" + Util.printCoordinates((double[])sigma2) + ")");
        if (deviceList == null) {
            IOFunctions.println(new Date(System.currentTimeMillis()) + ": Computing DoG image (CPU).");
        } else {
            IOFunctions.println(new Date(System.currentTimeMillis()) + ": Computing DoG image (GPU).");
        }
        dog.process();
        ArrayList<SimplePeak> peaks = dog.getSimplePeaks();
        if (localization == 0) {
            finalPeaks = Localization.noLocalization(peaks, findMin, findMax, keepIntensity);
        } else if (localization == 1) {
            finalPeaks = Localization.computeQuadraticLocalization(peaks, (Image<FloatType>)dog.getDoGImage(), findMin, findMax, minPeakValue, keepIntensity);
            dog.getDoGImage().close();
        } else {
            finalPeaks = Localization.computeGaussLocalization(peaks, null, sigma, findMin, findMax, minPeakValue, keepIntensity);
        }
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + "): Found " + finalPeaks.size() + " peaks.");
        dog = null;
        System.gc();
        return finalPeaks;
    }
}

