/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.deconvolution;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Pair;
import net.imglib2.util.RealSum;
import net.imglib2.util.ValuePair;
import net.imglib2.view.Views;
import spim.process.fusion.ImagePortion;

public class FirstIteration
implements Callable<Pair<RealSum, Long>> {
    final ImagePortion portion;
    final RandomAccessibleInterval<FloatType> psi;
    final ArrayList<RandomAccessibleInterval<FloatType>> imgs;
    final IterableInterval<FloatType> psiIterable;
    final ArrayList<IterableInterval<FloatType>> iterableImgs;
    final RealSum realSum;
    boolean compatibleIteration;

    public FirstIteration(ImagePortion portion, RandomAccessibleInterval<FloatType> psi, ArrayList<RandomAccessibleInterval<FloatType>> imgs) {
        this.portion = portion;
        this.psi = psi;
        this.imgs = imgs;
        this.psiIterable = Views.iterable(psi);
        this.iterableImgs = new ArrayList();
        this.realSum = new RealSum();
        this.compatibleIteration = true;
        for (RandomAccessibleInterval<FloatType> img : imgs) {
            IterableInterval imgIterable = Views.iterable(img);
            if (!this.psiIterable.iterationOrder().equals(imgIterable.iterationOrder())) {
                this.compatibleIteration = false;
            }
            this.iterableImgs.add((IterableInterval<FloatType>)imgIterable);
        }
    }

    @Override
    public Pair<RealSum, Long> call() throws Exception {
        Cursor psiCursor = this.psiIterable.localizingCursor();
        psiCursor.jumpFwd(this.portion.getStartPosition());
        int m = this.iterableImgs.size();
        long count = 0L;
        if (this.compatibleIteration) {
            ArrayList<Cursor<FloatType>> cursorImgs = new ArrayList<Cursor<FloatType>>();
            for (IterableInterval<FloatType> img : this.iterableImgs) {
                Cursor imgCursor = img.cursor();
                imgCursor.jumpFwd(this.portion.getStartPosition());
                cursorImgs.add(imgCursor);
            }
            int j = 0;
            while ((long)j < this.portion.getLoopSize()) {
                if (FirstIteration.compatibleLoop((Cursor<FloatType>)psiCursor, cursorImgs, this.realSum, m) > 0) {
                    ++count;
                }
                ++j;
            }
        } else {
            ArrayList<RandomAccess<FloatType>> randomAccessImgs = new ArrayList<RandomAccess<FloatType>>();
            for (RandomAccessibleInterval<FloatType> img : this.imgs) {
                randomAccessImgs.add(img.randomAccess());
            }
            int j = 0;
            while ((long)j < this.portion.getLoopSize()) {
                if (FirstIteration.incompatibleLoop((Cursor<FloatType>)psiCursor, randomAccessImgs, this.realSum, m) > 0) {
                    ++count;
                }
                ++j;
            }
        }
        return new ValuePair((Object)this.realSum, (Object)new Long(count));
    }

    private static final int compatibleLoop(Cursor<FloatType> psiCursor, ArrayList<Cursor<FloatType>> cursorImgs, RealSum realSum, int m) {
        double sum = 0.0;
        int count = 0;
        for (int j = 0; j < m; ++j) {
            double i = ((FloatType)cursorImgs.get(j).next()).get();
            if (!(i > 0.0)) continue;
            sum += i;
            ++count;
        }
        if (count > 0) {
            double i = sum / (double)count;
            realSum.add(i);
            ((FloatType)psiCursor.next()).set((float)count);
        } else {
            ((FloatType)psiCursor.next()).set(0.0f);
        }
        return count;
    }

    private static final int incompatibleLoop(Cursor<FloatType> psiCursor, ArrayList<RandomAccess<FloatType>> randomAccessImgs, RealSum realSum, int m) {
        FloatType p = (FloatType)psiCursor.next();
        double sum = 0.0;
        int count = 0;
        for (int j = 0; j < m; ++j) {
            RandomAccess<FloatType> randomAccessImg = randomAccessImgs.get(j);
            randomAccessImg.setPosition(psiCursor);
            double i = ((FloatType)randomAccessImg.get()).get();
            if (!(i > 0.0)) continue;
            sum += i;
            ++count;
        }
        if (count > 0) {
            double i = sum / (double)count;
            realSum.add(i);
            p.set((float)count);
        } else {
            p.set(0.0f);
        }
        return count;
    }
}

