/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.deconvolution;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.Opener;
import ij.process.ImageProcessor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalRealInterval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.array.ArrayLocalizingCursor;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public class ExtractPSF<T extends RealType<T> & NativeType<T>> {
    protected final HashMap<ViewId, ArrayImg<T, ?>> pointSpreadFunctions = new HashMap();
    protected final HashMap<ViewId, ArrayImg<T, ?>> originalPSFs = new HashMap();
    protected final ArrayList<ViewId> viewIds = new ArrayList();
    final HashMap<ViewId, ViewId> mapViewIds = new HashMap();

    public HashMap<ViewId, ViewId> getViewIdMapping() {
        return this.mapViewIds;
    }

    public HashMap<ViewId, ArrayImg<T, ?>> getPSFMap() {
        return this.pointSpreadFunctions;
    }

    public ArrayImg<T, ?> getTransformedPSF(ViewId viewId) {
        if (this.pointSpreadFunctions.containsKey(viewId)) {
            return this.pointSpreadFunctions.get(viewId);
        }
        if (this.mapViewIds.containsKey(viewId)) {
            return this.pointSpreadFunctions.get(this.mapViewIds.get(viewId));
        }
        throw new RuntimeException("Cannot find PSF for tpid: " + viewId.getTimePointId() + ", setupid=" + viewId.getViewSetupId());
    }

    public HashMap<ViewId, ArrayImg<T, ?>> getInputCalibrationPSFs() {
        return this.originalPSFs;
    }

    public ArrayList<ViewId> getViewIdsForPSFs() {
        return this.viewIds;
    }

    public static <S extends RealType<S>> Img<S> computeMaxProjection(Img<S> avgPSF, int minDim) {
        return ExtractPSF.computeMaxProjection(avgPSF, avgPSF.factory(), minDim);
    }

    public static <S extends RealType<S>> Img<S> computeMaxProjection(RandomAccessibleInterval<S> avgPSF, ImgFactory<S> factory, int minDim) {
        long[] dimensions = new long[avgPSF.numDimensions()];
        avgPSF.dimensions(dimensions);
        if (minDim < 0) {
            long minSize = dimensions[0];
            minDim = 0;
            for (int d = 0; d < dimensions.length; ++d) {
                if (avgPSF.dimension(d) >= minSize) continue;
                minSize = avgPSF.dimension(d);
                minDim = d;
            }
        }
        long[] projDim = new long[dimensions.length - 1];
        int dim = 0;
        long sizeProjection = 0L;
        for (int d = 0; d < dimensions.length; ++d) {
            if (d != minDim) {
                projDim[dim++] = dimensions[d];
                continue;
            }
            sizeProjection = dimensions[d];
        }
        Img proj = factory.create(projDim, Views.iterable(avgPSF).firstElement());
        RandomAccess psfIterator = avgPSF.randomAccess();
        Cursor projIterator = proj.localizingCursor();
        int[] tmp = new int[avgPSF.numDimensions()];
        while (projIterator.hasNext()) {
            projIterator.fwd();
            dim = 0;
            for (int d = 0; d < dimensions.length; ++d) {
                if (d == minDim) continue;
                tmp[d] = projIterator.getIntPosition(dim++);
            }
            tmp[minDim] = -1;
            double maxValue = -1.7976931348623157E308;
            psfIterator.setPosition(tmp);
            int i = 0;
            while ((long)i < sizeProjection) {
                psfIterator.fwd(minDim);
                double value = ((RealType)psfIterator.get()).getRealDouble();
                if (value > maxValue) {
                    maxValue = value;
                }
                ++i;
            }
            ((RealType)projIterator.get()).setReal(maxValue);
        }
        return proj;
    }

    public Img<T> computeAverageTransformedPSF() {
        long[] maxSize = this.computeMaxDimTransformedPSF();
        int numDimensions = maxSize.length;
        IJ.log((String)("maxSize: " + Util.printCoordinates((long[])maxSize)));
        Img someImg = (Img)this.pointSpreadFunctions.values().iterator().next();
        Img avgPSF = someImg.factory().create(maxSize, someImg.firstElement());
        long[] avgCenter = new long[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            avgCenter[d] = avgPSF.dimension(d) / 2L;
        }
        for (ViewId viewId : this.getViewIdsForPSFs()) {
            int d;
            Img psf = (Img)this.pointSpreadFunctions.get(viewId);
            OutOfBounds avgCursor = Views.extendZero((RandomAccessibleInterval)avgPSF).randomAccess();
            Cursor psfCursor = psf.localizingCursor();
            long[] loc = new long[numDimensions];
            long[] psfCenter = new long[numDimensions];
            for (d = 0; d < numDimensions; ++d) {
                psfCenter[d] = psf.dimension(d) / 2L;
            }
            while (psfCursor.hasNext()) {
                psfCursor.fwd();
                psfCursor.localize(loc);
                for (d = 0; d < numDimensions; ++d) {
                    loc[d] = psfCenter[d] - loc[d] + avgCenter[d];
                }
                avgCursor.setPosition(loc);
                ((RealType)avgCursor.get()).add(psfCursor.get());
            }
        }
        return avgPSF;
    }

    public Img<T> computeAveragePSF() {
        Img someImg = (Img)this.originalPSFs.values().iterator().next();
        Img avgOriginalPSF = someImg.factory().create((Dimensions)someImg, someImg.firstElement());
        try {
            for (ViewId viewId : this.getViewIdsForPSFs()) {
                Img psf = (Img)this.originalPSFs.get(viewId);
                Cursor cursor = psf.cursor();
                for (RealType t : avgOriginalPSF) {
                    t.add(cursor.next());
                }
            }
        }
        catch (Exception e) {
            IOFunctions.println("Input PSFs were most likely of different size ... not computing average image in original scale.");
            e.printStackTrace();
        }
        return avgOriginalPSF;
    }

    public void extractNextImg(RandomAccessibleInterval<T> img, ViewId viewId, AffineTransform3D model, ArrayList<double[]> locations, long[] psfSize) {
        IOFunctions.println("PSF size: " + Util.printCoordinates((long[])psfSize));
        ArrayImg<T, ?> originalPSF = ExtractPSF.extractPSFLocal(img, locations, psfSize);
        ExtractPSF.normalize(originalPSF);
        ArrayImg<T, ?> psf = ExtractPSF.transformPSF(originalPSF, model);
        this.viewIds.add(viewId);
        this.pointSpreadFunctions.put(viewId, psf);
        this.originalPSFs.put(viewId, originalPSF);
    }

    private static <T extends RealType<T>> void normalize(IterableInterval<T> img) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (RealType t : img) {
            double v = t.getRealDouble();
            if (v < min) {
                min = v;
            }
            if (!(v > max)) continue;
            max = v;
        }
        for (RealType t : img) {
            t.setReal((t.getRealDouble() - min) / (max - min));
        }
    }

    protected static <T extends RealType<T> & NativeType<T>> ArrayImg<T, ?> transformPSF(RandomAccessibleInterval<T> psf, AffineTransform3D model) {
        int d;
        int numDimensions = psf.numDimensions();
        FinalRealInterval minMaxDim = model.estimateBounds(psf);
        double[] size = new double[numDimensions];
        long[] newSize = new long[numDimensions];
        double[] offset = new double[numDimensions];
        double[] center = new double[numDimensions];
        double[] tmp = new double[numDimensions];
        for (d = 0; d < numDimensions; ++d) {
            center[d] = psf.dimension(d) / 2L;
        }
        model.apply(center, tmp);
        for (d = 0; d < numDimensions; ++d) {
            size[d] = minMaxDim.realMax(d) - minMaxDim.realMin(d);
            newSize[d] = (int)size[d] + 1;
            if (newSize[d] % 2L == 0L) {
                int n = d;
                newSize[n] = newSize[n] + 1L;
            }
            offset[d] = tmp[d] - (double)(newSize[d] / 2L);
        }
        return ExtractPSF.transform(psf, model, newSize, offset);
    }

    protected static <T extends RealType<T> & NativeType<T>> ArrayImg<T, ?> extractPSFLocal(RandomAccessibleInterval<T> img, ArrayList<double[]> locations, long[] size) {
        int numDimensions = size.length;
        ArrayImg psf = new ArrayImgFactory().create(size, (NativeType)Views.iterable(img).firstElement());
        RealRandomAccess interpolator = Views.interpolate((EuclideanSpace)Views.extendPeriodic(img), (InterpolatorFactory)new NLinearInterpolatorFactory()).realRandomAccess();
        ArrayLocalizingCursor psfCursor = psf.localizingCursor();
        long[] sizeHalf = (long[])size.clone();
        int d = 0;
        while (d < numDimensions) {
            int n = d++;
            sizeHalf[n] = sizeHalf[n] / 2L;
        }
        int[] tmpI = new int[size.length];
        double[] tmpD = new double[size.length];
        for (double[] position : locations) {
            psfCursor.reset();
            while (psfCursor.hasNext()) {
                psfCursor.fwd();
                psfCursor.localize(tmpI);
                for (int d2 = 0; d2 < numDimensions; ++d2) {
                    tmpD[d2] = (double)((long)tmpI[d2] - sizeHalf[d2]) + position[d2];
                }
                interpolator.setPosition(tmpD);
                ((RealType)psfCursor.get()).add(interpolator.get());
            }
        }
        return psf;
    }

    public static <T extends RealType<T> & NativeType<T>> ArrayImg<T, ?> transform(RandomAccessibleInterval<T> image, AffineTransform3D transformIn, long[] newDim, double[] offset) {
        int numDimensions = image.numDimensions();
        AffineTransform3D transform = transformIn.inverse();
        ArrayImg transformed = new ArrayImgFactory().create(newDim, (NativeType)Views.iterable(image).firstElement());
        ArrayLocalizingCursor transformedIterator = transformed.localizingCursor();
        RealRandomAccess interpolator = Views.interpolate((EuclideanSpace)Views.extendZero(image), (InterpolatorFactory)new NLinearInterpolatorFactory()).realRandomAccess();
        double[] tmp1 = new double[numDimensions];
        double[] tmp2 = new double[numDimensions];
        while (transformedIterator.hasNext()) {
            transformedIterator.fwd();
            for (int d = 0; d < numDimensions; ++d) {
                tmp1[d] = (double)transformedIterator.getIntPosition(d) + offset[d];
            }
            transform.apply(tmp1, tmp2);
            interpolator.setPosition(tmp2);
            ((RealType)transformedIterator.get()).set((Type)interpolator.get());
        }
        return transformed;
    }

    public static <T extends RealType<T>> Img<T> makeSameSize(Img<T> img, long[] sizeIn) {
        long[] size = (long[])sizeIn.clone();
        double min = Double.MAX_VALUE;
        for (RealType f : img) {
            min = Math.min(min, f.getRealDouble());
        }
        Img square = img.factory().create(size, img.firstElement());
        Cursor squareCursor = square.localizingCursor();
        RealType minT = (RealType)((RealType)img.firstElement()).createVariable();
        minT.setReal(min);
        OutOfBounds inputCursor = Views.extendValue(img, (Type)minT).randomAccess();
        while (squareCursor.hasNext()) {
            squareCursor.fwd();
            squareCursor.localize(size);
            for (int d = 0; d < img.numDimensions(); ++d) {
                size[d] = size[d] - square.dimension(d) / 2L + img.dimension(d) / 2L;
            }
            inputCursor.setPosition(size);
            ((RealType)squareCursor.get()).set((Type)inputCursor.get());
        }
        return square;
    }

    public static <T extends Type<T>> long[] commonSize(List<Img<T>> images) {
        if (images == null || images.size() == 0) {
            return null;
        }
        long[] size = new long[images.get(0).numDimensions()];
        images.get(0).dimensions(size);
        for (Img<T> image : images) {
            for (int d = 0; d < image.numDimensions(); ++d) {
                size[d] = Math.max(size[d], image.dimension(d));
            }
        }
        return size;
    }

    public long[] computeMaxDimTransformedPSF() {
        int numDimensions = 3;
        long[] maxSize = new long[3];
        for (Img img : this.pointSpreadFunctions.values()) {
            for (int d = 0; d < 3; ++d) {
                maxSize[d] = Math.max(maxSize[d], img.dimension(d));
            }
        }
        return maxSize;
    }

    public static <T extends RealType<T> & NativeType<T>> ExtractPSF<T> loadAndTransformPSFs(ArrayList<Pair<Pair<Angle, Illumination>, String>> filenames, ArrayList<ViewDescription> viewDesc, T type, HashMap<ViewId, AffineTransform3D> models) {
        ExtractPSF<T> extractPSF = new ExtractPSF<T>();
        for (ViewDescription vd : viewDesc) {
            ArrayImg<T, ?> psf;
            File file = ExtractPSF.getFileNameForViewId(vd, filenames);
            IOFunctions.println("Loading PSF file '" + file.getAbsolutePath());
            ImagePlus imp = new Opener().openImage(file.getAbsolutePath());
            if (imp == null) {
                throw new RuntimeException("Could not load '" + file + "' using ImageJ (should be a TIFF file).");
            }
            ImageStack stack = imp.getStack();
            int width = imp.getWidth();
            int sizeZ = imp.getNSlices();
            ArrayImg psfImage = new ArrayImgFactory().create(new long[]{width, imp.getHeight(), sizeZ}, (NativeType<T>)type);
            for (int z = 0; z < sizeZ; ++z) {
                Cursor cursor = Views.iterable((RandomAccessibleInterval)Views.hyperSlice((RandomAccessibleInterval)psfImage, (int)2, (long)z)).localizingCursor();
                ImageProcessor ip = stack.getProcessor(z + 1);
                while (cursor.hasNext()) {
                    cursor.fwd();
                    ((RealType)cursor.get()).setReal(ip.getf(cursor.getIntPosition(0) + cursor.getIntPosition(1) * width));
                }
            }
            if (models != null) {
                IOFunctions.println("Transforming PSF for viewid " + vd.getViewSetupId() + ", file=" + file.getName());
                psf = ExtractPSF.transformPSF(psfImage, models.get(vd));
            } else {
                IOFunctions.println("PSF for viewid " + vd.getViewSetupId() + ", file=" + file.getName() + " will not be transformed.");
                psf = psfImage.copy();
            }
            extractPSF.viewIds.add((ViewId)vd);
            extractPSF.pointSpreadFunctions.put((ViewId)vd, psf);
            extractPSF.originalPSFs.put((ViewId)vd, psfImage);
        }
        return extractPSF;
    }

    protected static File getFileNameForViewId(ViewDescription vd, ArrayList<Pair<Pair<Angle, Illumination>, String>> filenames) {
        for (Pair<Pair<Angle, Illumination>, String> pair : filenames) {
            if (((Angle)((Pair)pair.getA()).getA()).getId() != ((ViewSetup)vd.getViewSetup()).getAngle().getId() || ((Illumination)((Pair)pair.getA()).getB()).getId() != ((ViewSetup)vd.getViewSetup()).getIllumination().getId()) continue;
            return new File((String)pair.getB());
        }
        return null;
    }
}

