/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.interestpoints;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.TextFileAccess;
import spim.fiji.spimdata.interestpoints.CorrespondingInterestPoints;
import spim.fiji.spimdata.interestpoints.InterestPoint;

public class InterestPointList {
    File baseDir;
    File file;
    List<InterestPoint> interestPoints;
    List<CorrespondingInterestPoints> correspondingInterestPoints;
    String parameters;

    public InterestPointList(File baseDir, File file) {
        this.baseDir = baseDir;
        this.file = file;
        this.interestPoints = null;
        this.correspondingInterestPoints = null;
        this.parameters = "";
    }

    public List<InterestPoint> getInterestPoints() {
        return this.interestPoints;
    }

    public List<CorrespondingInterestPoints> getCorrespondingInterestPoints() {
        return this.correspondingInterestPoints;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getFile() {
        return this.file;
    }

    public String getParameters() {
        return this.parameters;
    }

    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public void setInterestPoints(List<InterestPoint> list) {
        this.interestPoints = list;
    }

    public void setCorrespondingInterestPoints(List<CorrespondingInterestPoints> list) {
        this.correspondingInterestPoints = list;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public String getInterestPointsExt() {
        return ".ip.txt";
    }

    public String getCorrespondencesExt() {
        return ".corr.txt";
    }

    public boolean saveInterestPoints() {
        List<InterestPoint> list = this.getInterestPoints();
        if (list == null) {
            return false;
        }
        try {
            File dir = new File(this.getBaseDir(), this.getFile().getParent());
            if (!dir.exists()) {
                IOFunctions.println("Creating directory: " + dir);
                dir.mkdirs();
            }
            PrintWriter out = TextFileAccess.openFileWriteEx(new File(this.getBaseDir(), this.getFile().toString() + this.getInterestPointsExt()));
            out.println("id\tx\ty\tz");
            for (InterestPoint p : list) {
                out.println(p.getId() + "\t" + p.getL()[0] + "\t" + p.getL()[1] + "\t" + p.getL()[2]);
            }
            out.close();
            return true;
        }
        catch (IOException e) {
            IOFunctions.println("InterestPointList.saveInterestPoints(): " + e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveCorrespondingInterestPoints() {
        List<CorrespondingInterestPoints> list = this.getCorrespondingInterestPoints();
        if (list == null) {
            return false;
        }
        try {
            File dir = new File(this.getBaseDir(), this.getFile().getParent());
            if (!dir.exists()) {
                IOFunctions.println("Creating directory: " + dir);
                dir.mkdirs();
            }
            PrintWriter out = TextFileAccess.openFileWriteEx(new File(this.getBaseDir(), this.getFile().toString() + this.getCorrespondencesExt()));
            out.println("id\tcorresponding_timepoint_id\tcorresponding_viewsetup_id\tcorresponding_label\tcorresponding_id");
            for (CorrespondingInterestPoints p : list) {
                out.println(p.getDetectionId() + "\t" + p.getCorrespondingViewId().getTimePointId() + "\t" + p.getCorrespondingViewId().getViewSetupId() + "\t" + p.getCorrespodingLabel() + "\t" + p.getCorrespondingDetectionId());
            }
            out.close();
            return true;
        }
        catch (IOException e) {
            IOFunctions.println("InterestPointList.saveCorrespondingInterestPoints(): " + e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadCorrespondingInterestPoints() {
        try {
            this.correspondingInterestPoints = new ArrayList<CorrespondingInterestPoints>();
            BufferedReader in = TextFileAccess.openFileReadEx(new File(this.getBaseDir(), this.getFile().toString() + this.getCorrespondencesExt()));
            while (!in.readLine().startsWith("id")) {
            }
            while (in.ready()) {
                String[] p = in.readLine().split("\t");
                CorrespondingInterestPoints cip = new CorrespondingInterestPoints(Integer.parseInt(p[0].trim()), new ViewId(Integer.parseInt(p[1].trim()), Integer.parseInt(p[2].trim())), p[3], Integer.parseInt(p[4].trim()));
                this.correspondingInterestPoints.add(cip);
            }
            in.close();
            return true;
        }
        catch (IOException e) {
            System.out.println("InterestPointList.loadCorrespondingInterestPoints(): " + e);
            return false;
        }
    }

    public boolean loadInterestPoints() {
        try {
            this.interestPoints = new ArrayList<InterestPoint>();
            BufferedReader in = TextFileAccess.openFileReadEx(new File(this.getBaseDir(), this.getFile().toString() + this.getInterestPointsExt()));
            while (!in.readLine().startsWith("id")) {
            }
            while (in.ready()) {
                String[] p = in.readLine().split("\t");
                InterestPoint point = new InterestPoint(Integer.parseInt(p[0].trim()), new double[]{Double.parseDouble(p[1].trim()), Double.parseDouble(p[2].trim()), Double.parseDouble(p[3].trim())});
                this.interestPoints.add(point);
            }
            in.close();
            return true;
        }
        catch (IOException e) {
            IOFunctions.println("InterestPointList.loadInterestPoints(): " + e);
            e.printStackTrace();
            return false;
        }
    }
}

