/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import java.io.File;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.type.NativeType;
import org.jdom2.Content;
import org.jdom2.Element;
import spim.fiji.spimdata.imgloaders.LightSheetZ1ImgLoader;

@ImgLoaderIo(format="spimreconstruction.lightsheetz1", type=LightSheetZ1ImgLoader.class)
public class XmlIoLightSheetZ1ImgLoader
implements XmlIoBasicImgLoader<LightSheetZ1ImgLoader> {
    public static final String DIRECTORY_TAG = "imagedirectory";
    public static final String MASTER_FILE_TAG = "masterfile";
    public static final String IMGLIB2CONTAINER_PATTERN_TAG = "imglib2container";

    public Element toXml(LightSheetZ1ImgLoader imgLoader, File basePath) {
        Element elem = new Element("ImageLoader");
        elem.setAttribute("format", this.getClass().getAnnotation(ImgLoaderIo.class).format());
        elem.addContent((Content)XmlHelpers.pathElement((String)DIRECTORY_TAG, (File)imgLoader.getCZIFile().getParentFile(), (File)basePath));
        elem.addContent((Content)XmlHelpers.textElement((String)MASTER_FILE_TAG, (String)imgLoader.getCZIFile().getName()));
        elem.addContent((Content)XmlHelpers.textElement((String)IMGLIB2CONTAINER_PATTERN_TAG, (String)imgLoader.getImgFactory().getClass().getSimpleName()));
        return elem;
    }

    public LightSheetZ1ImgLoader fromXml(Element elem, File basePath, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        try {
            ArrayImgFactory imgFactory;
            File path = XmlHelpers.loadPath((Element)elem, (String)DIRECTORY_TAG, (File)basePath);
            String masterFile = XmlHelpers.getText((Element)elem, (String)MASTER_FILE_TAG);
            String container = XmlHelpers.getText((Element)elem, (String)IMGLIB2CONTAINER_PATTERN_TAG);
            if (container == null) {
                System.out.println("WARNING: No Img implementation defined in XML, using ArrayImg.");
                imgFactory = new ArrayImgFactory();
            } else if (container.toLowerCase().contains("cellimg")) {
                imgFactory = new CellImgFactory(new int[]{256});
            } else if (container.toLowerCase().contains("arrayimg")) {
                imgFactory = new ArrayImgFactory();
            } else if (container.toLowerCase().contains("planarimg")) {
                imgFactory = new PlanarImgFactory();
            } else {
                imgFactory = new ArrayImgFactory();
                System.out.println("WARNING: Unknown Img implementation defined in XML:'" + container + "', using ArrayImg.");
            }
            return new LightSheetZ1ImgLoader(new File(path, masterFile), (ImgFactory<? extends NativeType<?>>)imgFactory, sequenceDescription);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

