/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.explorer.registration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mpicbg.spim.data.generic.sequence.BasicViewDescription;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.registration.ViewTransform;
import mpicbg.spim.data.registration.ViewTransformAffine;
import net.imglib2.realtransform.AffineTransform3D;
import spim.fiji.spimdata.explorer.registration.RegistrationExplorer;
import spim.fiji.spimdata.explorer.registration.RegistrationTableModel;

public class RegistrationExplorerPanel
extends JPanel {
    private static final long serialVersionUID = -3767947754096099774L;
    final RegistrationExplorer<?, ?> explorer;
    protected JTable table;
    protected RegistrationTableModel tableModel;
    protected JLabel label;
    protected ArrayList<ViewTransform> cache = new ArrayList();

    public RegistrationExplorerPanel(ViewRegistrations viewRegistrations, RegistrationExplorer<?, ?> explorer) {
        this.explorer = explorer;
        this.initComponent(viewRegistrations);
    }

    public RegistrationTableModel getTableModel() {
        return this.tableModel;
    }

    public JTable getTable() {
        return this.table;
    }

    public void updateViewDescription(BasicViewDescription<?> vd) {
        if (vd != null && this.label != null) {
            this.label.setText("View Description --- Timepoint: " + vd.getTimePointId() + ", View Setup Id: " + vd.getViewSetupId());
        }
        if (vd == null) {
            this.label.setText("No or multiple View Descriptions selected");
        }
        this.tableModel.updateViewDescription(vd);
        if (this.table.getSelectedRowCount() == 0) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void initComponent(ViewRegistrations viewRegistrations) {
        this.tableModel = new RegistrationTableModel(viewRegistrations, this);
        this.table = new JTable();
        this.table.setModel(this.tableModel);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.setSelectionMode(1);
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        for (int column = 0; column < this.tableModel.getColumnCount(); ++column) {
            this.table.getColumnModel().getColumn(column).setCellRenderer(centerRenderer);
        }
        this.table.setPreferredScrollableViewportSize(new Dimension(1020, 300));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(300);
        for (int i = 1; i < this.table.getColumnCount(); ++i) {
            this.table.getColumnModel().getColumn(i).setPreferredWidth(100);
        }
        Font f = this.table.getFont();
        this.table.setFont(new Font(f.getName(), f.getStyle(), 11));
        this.setLayout(new BorderLayout());
        this.label = new JLabel("View Description --- ");
        this.add((Component)this.label, "North");
        this.add((Component)new JScrollPane(this.table), "Center");
        this.addPopupMenu(this.table);
    }

    protected void copySelection() {
        this.cache.clear();
        if (this.table.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this.table, "Nothing selected");
            return;
        }
        BasicViewDescription<?> vd = this.tableModel.getCurrentViewDescription();
        if (vd == null) {
            JOptionPane.showMessageDialog(this.table, "No active viewdescription.");
            return;
        }
        ViewRegistration vr = this.tableModel.getViewRegistrations().getViewRegistration(vd);
        for (int row : this.table.getSelectedRows()) {
            this.cache.add(RegistrationExplorerPanel.duplicate((ViewTransform)vr.getTransformList().get(row)));
            System.out.println("Copied row " + ((ViewTransform)vr.getTransformList().get(row)).getName());
        }
    }

    protected void pasteSelection(int type) {
        int i;
        int insertAt;
        if (this.cache.size() == 0) {
            JOptionPane.showMessageDialog(this.table, "Nothing copied so far.");
            return;
        }
        if (this.table.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this.table, "Nothing selected.");
            return;
        }
        BasicViewDescription<?> vd = this.tableModel.getCurrentViewDescription();
        if (vd == null) {
            JOptionPane.showMessageDialog(this.table, "No active viewdescription.");
            return;
        }
        ViewRegistration vr = this.tableModel.getViewRegistrations().getViewRegistration(vd);
        int[] selectedRows = this.table.getSelectedRows();
        Arrays.sort(selectedRows);
        if (type == 0) {
            insertAt = selectedRows[0];
        } else if (type == 1) {
            insertAt = selectedRows[0];
            for (int i2 = selectedRows[selectedRows.length - 1]; i2 >= selectedRows[0]; --i2) {
                vr.getTransformList().remove(i2);
            }
        } else {
            insertAt = selectedRows[selectedRows.length - 1] + 1;
        }
        ArrayList newList = new ArrayList();
        for (i = 0; i < insertAt; ++i) {
            newList.add(vr.getTransformList().get(i));
        }
        for (i = 0; i < this.cache.size(); ++i) {
            newList.add(RegistrationExplorerPanel.duplicate(this.cache.get(i)));
        }
        for (i = insertAt; i < vr.getTransformList().size(); ++i) {
            newList.add(vr.getTransformList().get(i));
        }
        vr.getTransformList().clear();
        vr.getTransformList().addAll(newList);
        vr.updateModel();
        this.tableModel.fireTableDataChanged();
    }

    protected static ViewTransform duplicate(ViewTransform vt) {
        AffineTransform3D t = new AffineTransform3D();
        t.set(vt.asAffine3D().getRowPackedCopy());
        return new ViewTransformAffine(vt.getName(), t);
    }

    protected static ViewTransform newName(ViewTransform vt, String name) {
        AffineTransform3D t = new AffineTransform3D();
        t.set(vt.asAffine3D().getRowPackedCopy());
        return new ViewTransformAffine(name, t);
    }

    protected static ViewTransform newMatrixEntry(ViewTransform vt, double value, int index) {
        AffineTransform3D t = new AffineTransform3D();
        double[] m = vt.asAffine3D().getRowPackedCopy();
        m[index] = value;
        t.set(m);
        return new ViewTransformAffine(vt.getName(), t);
    }

    protected void delete() {
        if (this.table.getSelectedRowCount() == 0) {
            JOptionPane.showMessageDialog(this.table, "Nothing selected.");
            return;
        }
        BasicViewDescription<?> vd = this.tableModel.getCurrentViewDescription();
        if (vd == null) {
            JOptionPane.showMessageDialog(this.table, "No active viewdescription.");
            return;
        }
        int[] selectedRows = this.table.getSelectedRows();
        Arrays.sort(selectedRows);
        ViewRegistration vr = this.tableModel.getViewRegistrations().getViewRegistration(vd);
        for (int i = selectedRows[selectedRows.length - 1]; i >= selectedRows[0]; --i) {
            vr.getTransformList().remove(i);
        }
        if (vr.getTransformList().isEmpty()) {
            vr.getTransformList().add(new ViewTransformAffine(null, new AffineTransform3D()));
        }
        vr.updateModel();
        this.tableModel.fireTableDataChanged();
    }

    protected void addPopupMenu(JTable table) {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyItem = new JMenuItem("Copy");
        JMenuItem deleteItem = new JMenuItem("Delete");
        JMenuItem pasteBeforeItem = new JMenuItem("Paste before selection");
        JMenuItem pasteAndRepaceItem = new JMenuItem("Paste and replace selection");
        JMenuItem pasteAfterItem = new JMenuItem("Paste after selection");
        copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationExplorerPanel.this.copySelection();
            }
        });
        pasteBeforeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationExplorerPanel.this.pasteSelection(0);
            }
        });
        pasteAndRepaceItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationExplorerPanel.this.pasteSelection(1);
            }
        });
        pasteAfterItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationExplorerPanel.this.pasteSelection(2);
            }
        });
        deleteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RegistrationExplorerPanel.this.delete();
                System.out.println("Right-click performed on table and choose DELETE");
            }
        });
        popupMenu.add(copyItem);
        popupMenu.add(pasteBeforeItem);
        popupMenu.add(pasteAndRepaceItem);
        popupMenu.add(pasteAfterItem);
        popupMenu.add(deleteItem);
        table.setComponentPopupMenu(popupMenu);
    }
}

