/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.XmlIoAbstractSpimData;
import mpicbg.spim.data.generic.sequence.XmlIoAbstractSequenceDescription;
import mpicbg.spim.data.registration.XmlIoViewRegistrations;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.XmlIoSequenceDescription;
import mpicbg.spim.io.IOFunctions;
import org.jdom2.Content;
import org.jdom2.Element;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.boundingbox.BoundingBoxes;
import spim.fiji.spimdata.boundingbox.XmlIoBoundingBoxes;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;
import spim.fiji.spimdata.interestpoints.XmlIoViewInterestPoints;

public class XmlIoSpimData2
extends XmlIoAbstractSpimData<SequenceDescription, SpimData2> {
    final XmlIoViewInterestPoints xmlViewsInterestPoints = new XmlIoViewInterestPoints();
    final XmlIoBoundingBoxes xmlBoundingBoxes;
    String clusterExt;
    String lastFileName;
    public static int numBackups = 5;

    public XmlIoSpimData2(String clusterExt) {
        super(SpimData2.class, (XmlIoAbstractSequenceDescription)new XmlIoSequenceDescription(), new XmlIoViewRegistrations());
        this.handledTags.add(this.xmlViewsInterestPoints.getTag());
        this.xmlBoundingBoxes = new XmlIoBoundingBoxes();
        this.handledTags.add(this.xmlBoundingBoxes.getTag());
        this.clusterExt = clusterExt;
    }

    public void setClusterExt(String clusterExt) {
        this.clusterExt = clusterExt;
    }

    public void save(SpimData2 spimData, String xmlFilename) throws SpimDataException {
        if (this.clusterExt != null && this.clusterExt.length() > 0) {
            xmlFilename = xmlFilename.toLowerCase().endsWith(".xml") ? xmlFilename.substring(0, xmlFilename.length() - 4) + "." + this.clusterExt + xmlFilename.substring(xmlFilename.length() - 4, xmlFilename.length()) : xmlFilename + this.clusterExt + ".xml";
        }
        this.lastFileName = xmlFilename;
        if (new File(xmlFilename).exists()) {
            int maxExistingBackup = 0;
            int i = 1;
            while (i < numBackups && new File(xmlFilename + "~" + i).exists()) {
                maxExistingBackup = i++;
            }
            try {
                for (i = maxExistingBackup; i >= 1; --i) {
                    XmlIoSpimData2.copyFile(new File(xmlFilename + "~" + i), new File(xmlFilename + "~" + (i + 1)));
                }
                XmlIoSpimData2.copyFile(new File(xmlFilename), new File(xmlFilename + "~1"));
            }
            catch (IOException e) {
                IOFunctions.println("Could not save backup of XML file: " + e);
                e.printStackTrace();
            }
        }
        super.save((AbstractSpimData)spimData, xmlFilename);
    }

    public String lastFileName() {
        return this.lastFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyFile(File inputFile, File outputFile) throws IOException {
        FileInputStream input = null;
        OutputStream output = null;
        try {
            int bytesRead;
            input = new FileInputStream(inputFile);
            output = new FileOutputStream(outputFile);
            byte[] buf = new byte[65536];
            while ((bytesRead = ((InputStream)input).read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (input != null) {
                ((InputStream)input).close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    public SpimData2 fromXml(Element root, File xmlFile) throws SpimDataException {
        ViewInterestPoints viewsInterestPoints;
        SpimData2 spimData = (SpimData2)super.fromXml(root, xmlFile);
        SequenceDescription seq = (SequenceDescription)spimData.getSequenceDescription();
        Element elem = root.getChild(this.xmlViewsInterestPoints.getTag());
        if (elem == null) {
            viewsInterestPoints = new ViewInterestPoints();
            viewsInterestPoints.createViewInterestPoints(seq.getViewDescriptions());
        } else {
            viewsInterestPoints = this.xmlViewsInterestPoints.fromXml(elem, spimData.getBasePath(), seq.getViewDescriptions());
        }
        spimData.setViewsInterestPoints(viewsInterestPoints);
        elem = root.getChild(this.xmlBoundingBoxes.getTag());
        BoundingBoxes boundingBoxes = elem == null ? new BoundingBoxes() : this.xmlBoundingBoxes.fromXml(elem);
        spimData.setBoundingBoxes(boundingBoxes);
        return spimData;
    }

    public Element toXml(SpimData2 spimData, File xmlFileDirectory) throws SpimDataException {
        Element root = super.toXml((AbstractSpimData)spimData, xmlFileDirectory);
        root.addContent((Content)this.xmlViewsInterestPoints.toXml(spimData.getViewInterestPoints()));
        root.addContent((Content)this.xmlBoundingBoxes.toXml(spimData.getBoundingBoxes()));
        return root;
    }
}

