/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin;

import ij.ImageJ;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.img.Img;
import net.imglib2.img.imageplus.ImagePlusImgFactory;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.view.Views;
import spim.fiji.plugin.Interest_Point_Registration;
import spim.fiji.plugin.queryXML.LoadParseQueryXML;
import spim.fiji.plugin.util.GUIHelper;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.interestpoints.CorrespondingInterestPoints;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.process.fusion.export.DisplayImage;
import spim.process.interestpointregistration.ChannelProcess;

public class Visualize_Detections
implements PlugIn {
    public static String[] detectionsChoice = new String[]{"All detections", "Corresponding detections"};
    public static int defaultDetections = 0;
    public static double defaultDownsample = 1.0;
    public static boolean defaultDisplayInput = false;

    public void run(String arg0) {
        LoadParseQueryXML result = new LoadParseQueryXML();
        if (!result.queryXML("visualize detections", true, false, true, true)) {
            return;
        }
        ArrayList<ViewId> viewIds = SpimData2.getAllViewIdsSorted((SpimData)result.getData(), result.getViewSetupsToProcess(), result.getTimePointsToProcess());
        Params params = Visualize_Detections.queryDetails((SpimData2)((Object)result.getData()), viewIds);
        if (params != null) {
            Visualize_Detections.visualize((SpimData2)((Object)result.getData()), viewIds, params.channelsToProcess, params.detections, params.downsample, params.displayInput);
        }
    }

    public static Params queryDetails(SpimData2 spimData, List<ViewId> viewIds) {
        List channels = ((SequenceDescription)spimData.getSequenceDescription()).getAllChannelsOrdered();
        int nAllChannels = ((SequenceDescription)spimData.getSequenceDescription()).getAllChannelsOrdered().size();
        GenericDialog gd = new GenericDialog("Choose segmentations to display");
        if (Interest_Point_Registration.defaultChannelLabels == null || Interest_Point_Registration.defaultChannelLabels.length != nAllChannels) {
            Interest_Point_Registration.defaultChannelLabels = new int[nAllChannels];
        }
        ArrayList<String[]> channelLabels = new ArrayList<String[]>();
        int j = 0;
        for (Object channel : channels) {
            String[] labels = Interest_Point_Registration.getAllInterestPointLabelsForChannel(spimData, viewIds, (Channel)channel, "visualize");
            if (labels == null) {
                return null;
            }
            if (Interest_Point_Registration.defaultChannelLabels[j] >= labels.length) {
                Interest_Point_Registration.defaultChannelLabels[j] = 0;
            }
            String ch = channel.getName().replace(' ', '_');
            gd.addChoice("Interest_points_channel_" + ch, labels, labels[Interest_Point_Registration.defaultChannelLabels[j++]]);
            channelLabels.add(labels);
        }
        gd.addChoice("Display", detectionsChoice, detectionsChoice[defaultDetections]);
        gd.addNumericField("Downsample_detections_rendering", defaultDownsample, 2, 4, "times");
        gd.addCheckbox("Display_input_images", defaultDisplayInput);
        GUIHelper.addWebsite(gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        ArrayList<ChannelProcess> channelsToProcess = new ArrayList<ChannelProcess>();
        j = 0;
        for (Channel channel : channels) {
            Interest_Point_Registration.defaultChannelLabels[j] = gd.getNextChoiceIndex();
            int channelChoice = Interest_Point_Registration.defaultChannelLabels[j];
            if (channelChoice < ((String[])channelLabels.get(j)).length - 1) {
                String label = ((String[])channelLabels.get(j))[channelChoice];
                if (label.contains(" (WARNING: Only available for ")) {
                    label = label.substring(0, label.indexOf(" (WARNING: Only available for "));
                }
                channelsToProcess.add(new ChannelProcess(channel, label));
            }
            ++j;
        }
        if (channelsToProcess.size() == 0) {
            IOFunctions.println("No channels selected. Quitting.");
            return null;
        }
        for (ChannelProcess c : channelsToProcess) {
            IOFunctions.println("displaying channel: " + c.getChannel().getId() + " label: '" + c.getLabel() + "'");
        }
        int detections = defaultDetections = gd.getNextChoiceIndex();
        double downsample = defaultDownsample = gd.getNextNumber();
        boolean displayInput = defaultDisplayInput = gd.getNextBoolean();
        return new Params(channelsToProcess, detections, downsample, displayInput);
    }

    public static void visualize(SpimData2 spimData, List<ViewId> viewIds, ArrayList<ChannelProcess> channelsToProcess, int detections, double downsample, boolean displayInput) {
        DisplayImage di = new DisplayImage();
        for (ViewId viewId : viewIds) {
            for (ChannelProcess c : channelsToProcess) {
                FinalInterval interval;
                ViewDescription vd = ((SequenceDescription)spimData.getSequenceDescription()).getViewDescription(viewId.getTimePointId(), viewId.getViewSetupId());
                if (!vd.isPresent() || ((ViewSetup)vd.getViewSetup()).getChannel().getId() != c.getChannel().getId()) continue;
                String name = "TP" + vd.getTimePointId() + "_Ch" + c.getChannel().getName() + "(label='" + c.getLabel() + "')_ill" + ((ViewSetup)vd.getViewSetup()).getIllumination().getName() + "_angle" + ((ViewSetup)vd.getViewSetup()).getAngle().getName();
                if (displayInput) {
                    RandomAccessibleInterval img = ((ImgLoader)((SequenceDescription)spimData.getSequenceDescription()).getImgLoader()).getSetupImgLoader(vd.getViewSetupId()).getImage(vd.getTimePointId(), new ImgLoaderHint[0]);
                    di.exportImage(img, name);
                    interval = img;
                } else if (!((ViewSetup)vd.getViewSetup()).hasSize()) {
                    IOFunctions.println("Cannot load image dimensions from XML for " + name + ", using min/max of all detections instead.");
                    interval = null;
                } else {
                    interval = new FinalInterval(((ViewSetup)vd.getViewSetup()).getSize());
                }
                di.exportImage(Visualize_Detections.renderSegmentations(spimData, viewId, c.getLabel(), detections, (Interval)interval, downsample), "seg of " + name);
            }
        }
    }

    protected static Img<UnsignedShortType> renderSegmentations(SpimData2 data, ViewId viewId, String label, int detections, Interval interval, double downsample) {
        InterestPointList ipl = data.getViewInterestPoints().getViewInterestPointLists(viewId).getInterestPointList(label);
        if (ipl.getInterestPoints() == null) {
            ipl.loadInterestPoints();
        }
        if (interval == null) {
            int n = ipl.getInterestPoints().get(0).getL().length;
            long[] min = new long[n];
            long[] max = new long[n];
            for (int d = 0; d < n; ++d) {
                min[d] = Math.round(ipl.getInterestPoints().get(0).getL()[d]) - 1L;
                max[d] = Math.round(ipl.getInterestPoints().get(0).getL()[d]) + 1L;
            }
            for (InterestPoint ip : ipl.getInterestPoints()) {
                for (int d = 0; d < n; ++d) {
                    min[d] = Math.min(min[d], Math.round(ip.getL()[d]) - 1L);
                    max[d] = Math.max(max[d], Math.round(ip.getL()[d]) + 1L);
                }
            }
            interval = new FinalInterval(min, max);
        }
        long[] min = new long[interval.numDimensions()];
        long[] max = new long[interval.numDimensions()];
        for (int d = 0; d < interval.numDimensions(); ++d) {
            min[d] = Math.round((double)interval.min(d) / downsample);
            max[d] = Math.round((double)interval.max(d) / downsample);
        }
        interval = new FinalInterval(min, max);
        Img s = new ImagePlusImgFactory().create((Dimensions)interval, (Object)new UnsignedShortType());
        OutOfBounds r = Views.extendZero((RandomAccessibleInterval)s).randomAccess();
        int n = s.numDimensions();
        long[] tmp = new long[n];
        if (detections == 0) {
            IOFunctions.println("Visualizing " + ipl.getInterestPoints().size() + " detections.");
            for (InterestPoint ip : ipl.getInterestPoints()) {
                for (int i = 0; i < n; ++i) {
                    tmp[i] = Math.round(ip.getL()[i] / downsample);
                }
                r.setPosition(tmp);
                ((UnsignedShortType)r.get()).set(65535);
            }
        } else {
            HashMap<Integer, InterestPoint> map = new HashMap<Integer, InterestPoint>();
            for (InterestPoint interestPoint : ipl.getInterestPoints()) {
                map.put(interestPoint.getId(), interestPoint);
            }
            if (ipl.getCorrespondingInterestPoints() == null && !ipl.loadCorrespondingInterestPoints()) {
                IOFunctions.println("No corresponding detections available, the dataset was not registered using these detections.");
                return s;
            }
            IOFunctions.println("Visualizing " + ipl.getCorrespondingInterestPoints().size() + " corresponding detections.");
            for (CorrespondingInterestPoints correspondingInterestPoints : ipl.getCorrespondingInterestPoints()) {
                for (int d = 0; d < n; ++d) {
                    tmp[d] = Math.round(((InterestPoint)((Object)map.get(correspondingInterestPoints.getDetectionId()))).getL()[d] / downsample);
                }
                r.setPosition(tmp);
                ((UnsignedShortType)r.get()).set(65535);
            }
        }
        try {
            Gauss3.gauss((double[])new double[]{2.0, 2.0, 2.0}, (RandomAccessible)Views.extendZero((RandomAccessibleInterval)s), (RandomAccessibleInterval)s);
        }
        catch (Exception e) {
            IOFunctions.println("Gaussian Convolution of detections failed: " + e);
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            IOFunctions.println("Gaussian Convolution of detections failed due to out of memory, just showing plain image: " + e);
        }
        return s;
    }

    public static void main(String[] args) {
        new ImageJ();
        new Visualize_Detections().run(null);
    }

    public static class Params {
        public final ArrayList<ChannelProcess> channelsToProcess;
        public final int detections;
        public final double downsample;
        public final boolean displayInput;

        public Params(ArrayList<ChannelProcess> channelsToProcess, int detections, double downsample, boolean displayInput) {
            this.channelsToProcess = channelsToProcess;
            this.detections = detections;
            this.downsample = downsample;
            this.displayInput = displayInput;
        }
    }
}

