/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.vis3d;

import ij.ImageJ;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import mpicbg.models.AffineModel3D;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.ConfigurationParserGeneral;
import mpicbg.spim.io.ConfigurationParserSPIM;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.ProgramConfiguration;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.io.TextFileAccess;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import mpicbg.spim.registration.bead.Bead;
import mpicbg.spim.registration.bead.BeadIdentification;
import mpicbg.spim.registration.bead.BeadRegistration;
import mpicbg.spim.vis3d.VisualizationSketchTikZ;
import spim.vecmath.Color3f;

public class VisualizeBeads {
    final SPIMConfiguration config;
    final ArrayList<ViewDataBeads> views;
    final ViewStructure viewStructure;
    public static final Color3f backgroundColor = new Color3f(1.0f, 1.0f, 1.0f);
    public static final Color3f foregroundColor = new Color3f(0.5f, 0.5f, 0.59f);
    public static final Color3f beadColor = new Color3f(0.0f, 0.0f, 0.0f);
    public static final float beadSize = 3.0f;
    public static final Color3f boundingBoxColor = new Color3f(0.7f, 0.7f, 0.85f);
    public static final Color3f imagingBoxColor = new Color3f(1.0f, 0.0f, 0.25f);
    public static final Font statusbarFont = new Font("Cambria", 0, 12);

    public VisualizeBeads(SPIMConfiguration config) {
        this.config = config;
        this.viewStructure = ViewStructure.initViewStructure(config, 0, new AffineModel3D(), "ViewStructure Timepoint 0", config.debugLevelInt);
        this.views = this.viewStructure.getViews();
        for (ViewDataBeads view : this.viewStructure.getViews()) {
            view.loadDimensions();
            view.loadSegmentation();
            view.loadRegistration();
        }
        this.writeSketchTikZ("src/templates/beadimage-1.sk", "src/templates/allViewsWorm.sk");
    }

    protected void writeSketchTikZ(String template, String output) {
        BeadRegistration.concatenateAxialScaling(this.views, this.viewStructure.getDebugLevel());
        float factor = 0.005f;
        boolean reachedInsertPosition = false;
        try {
            BufferedReader in = TextFileAccess.openFileRead(template);
            PrintWriter out = TextFileAccess.openFileWrite(output);
            while (in.ready() && !reachedInsertPosition) {
                String line = in.readLine();
                if (line.contains("%<--for Java-->")) {
                    reachedInsertPosition = true;
                    continue;
                }
                out.println(line);
            }
            int num = this.views.size();
            for (int i = 0; i < num; ++i) {
                out.println(VisualizationSketchTikZ.drawView(this.views.get(i), 0.005f));
                out.println(VisualizationSketchTikZ.drawBeads(this.views.get(i).getBeadStructure().getBeadList(), this.views.get(i).getTransform3D(), "Bead", 0.005f));
            }
            out.println(this.drawAllFalseCorrespondences(this.views, 0.005f));
            out.println(this.drawAllRANSACCorrespondences(this.views, 0.005f));
            while (in.ready()) {
                String line = in.readLine();
                out.println(line);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            IOFunctions.printErr("Error reading/writing template or output file: " + e);
            return;
        }
        System.exit(0);
    }

    protected String drawFalseCorrespondences(ViewDataBeads view, ViewDataBeads correspondingView, float factor) {
        ArrayList<Bead> beads = view.getBeadStructure().getBeadList();
        ArrayList<Bead> correspondences = new ArrayList<Bead>();
        for (Bead bead : beads) {
            boolean isDescriptorCorrespondingBead = false;
            boolean isRANSACCorrespondingBead = false;
            ArrayList correspondingRANSACBeads = bead.getRANSACCorrespondence();
            for (BeadIdentification correspondingBead : correspondingRANSACBeads) {
                if (correspondingBead.getViewID() != correspondingView.getID()) continue;
                isRANSACCorrespondingBead = true;
            }
            ArrayList correspondingDescriptorBeads = bead.getDescriptorCorrespondence();
            for (BeadIdentification correspondingBead : correspondingDescriptorBeads) {
                if (correspondingBead.getViewID() != correspondingView.getID()) continue;
                isDescriptorCorrespondingBead = true;
            }
            if (!isDescriptorCorrespondingBead || isRANSACCorrespondingBead) continue;
            correspondences.add(bead);
        }
        return VisualizationSketchTikZ.drawBeads(correspondences, view.getTransform3D(), "FalseBead", factor);
    }

    protected String drawRANSACCorrespondences(ViewDataBeads view, ViewDataBeads correspondingView, float factor) {
        ArrayList<Bead> beads = view.getBeadStructure().getBeadList();
        ArrayList<Bead> correspondences = new ArrayList<Bead>();
        for (Bead bead : beads) {
            ArrayList correspondingBeads = bead.getRANSACCorrespondence();
            boolean isCorrespondingBead = false;
            for (BeadIdentification correspondingBead : correspondingBeads) {
                if (correspondingBead.getViewID() != correspondingView.getID()) continue;
                isCorrespondingBead = true;
            }
            if (!isCorrespondingBead) continue;
            correspondences.add(bead);
        }
        return VisualizationSketchTikZ.drawBeads(correspondences, view.getTransform3D(), "RansacBead", factor);
    }

    protected String drawAllRANSACCorrespondences(ArrayList<ViewDataBeads> views, float factor) {
        String insert = "";
        ArrayList<int[]> comparePairs = new ArrayList<int[]>();
        for (int viewA = 0; viewA < views.size() - 1; ++viewA) {
            int viewB = viewA + 1;
            while (viewB < views.size()) {
                comparePairs.add(new int[]{viewA, viewB++});
            }
        }
        for (int[] pair : comparePairs) {
            ViewDataBeads viewA = views.get(pair[0]);
            ViewDataBeads viewB = views.get(pair[1]);
            ArrayList<Bead> beads = viewA.getBeadStructure().getBeadList();
            ArrayList<Bead> correspondences = new ArrayList<Bead>();
            for (Bead bead : beads) {
                ArrayList correspondingBeads = bead.getRANSACCorrespondence();
                boolean isCorrespondingBead = false;
                for (BeadIdentification correspondingBead : correspondingBeads) {
                    if (correspondingBead.getViewID() != viewB.getID()) continue;
                    isCorrespondingBead = true;
                }
                if (!isCorrespondingBead) continue;
                correspondences.add(bead);
            }
            insert = insert + VisualizationSketchTikZ.drawBeads(correspondences, viewA.getTransform3D(), "RansacBead", factor);
        }
        return insert;
    }

    protected String drawAllFalseCorrespondences(ArrayList<ViewDataBeads> views, float factor) {
        String insert = "";
        ArrayList<int[]> comparePairs = new ArrayList<int[]>();
        for (int viewA = 0; viewA < views.size() - 1; ++viewA) {
            int viewB = viewA + 1;
            while (viewB < views.size()) {
                comparePairs.add(new int[]{viewA, viewB++});
            }
        }
        for (int[] pair : comparePairs) {
            ViewDataBeads viewA = views.get(pair[0]);
            ViewDataBeads viewB = views.get(pair[1]);
            ArrayList<Bead> beads = viewA.getBeadStructure().getBeadList();
            ArrayList<Bead> correspondences = new ArrayList<Bead>();
            for (Bead bead : beads) {
                boolean isDescriptorCorrespondingBead = false;
                boolean isRANSACCorrespondingBead = false;
                ArrayList correspondingRANSACBeads = bead.getRANSACCorrespondence();
                for (BeadIdentification correspondingBead : correspondingRANSACBeads) {
                    if (correspondingBead.getViewID() != viewB.getID()) continue;
                    isRANSACCorrespondingBead = true;
                }
                ArrayList correspondingDescriptorBeads = bead.getDescriptorCorrespondence();
                for (BeadIdentification correspondingBead : correspondingDescriptorBeads) {
                    if (correspondingBead.getViewID() != viewB.getID()) continue;
                    isDescriptorCorrespondingBead = true;
                }
                if (!isDescriptorCorrespondingBead || isRANSACCorrespondingBead) continue;
                correspondences.add(bead);
            }
            insert = insert + VisualizationSketchTikZ.drawBeads(correspondences, viewA.getTransform3D(), "FalseBead", factor);
        }
        return insert;
    }

    protected String drawPointDescriptorCorrespondences(ViewDataBeads view, ViewDataBeads correspondingView, float factor) {
        ArrayList<Bead> beads = view.getBeadStructure().getBeadList();
        ArrayList<Bead> correspondences = new ArrayList<Bead>();
        for (Bead bead : beads) {
            ArrayList correspondingBeads = bead.getDescriptorCorrespondence();
            boolean isCorrespondingBead = false;
            for (BeadIdentification correspondingBead : correspondingBeads) {
                if (correspondingBead.getViewID() != correspondingView.getID()) continue;
                isCorrespondingBead = true;
            }
            if (!isCorrespondingBead) continue;
            correspondences.add(bead);
        }
        return VisualizationSketchTikZ.drawBeads(correspondences, view.getTransform3D(), "CorrespondingBead", factor);
    }

    public static void main(String[] args) {
        ProgramConfiguration conf = null;
        try {
            conf = ConfigurationParserGeneral.parseFile("config/configuration.txt");
        }
        catch (Exception e) {
            IOFunctions.printErr("Cannot open configuration file: " + e);
            e.printStackTrace();
            return;
        }
        System.getProperties().setProperty("plugins.dir", conf.pluginsDir);
        String[] params = new String[]{"-ijpath " + conf.pluginsDir};
        ImageJ.main((String[])params);
        SPIMConfiguration config = null;
        try {
            config = ConfigurationParserSPIM.parseFile("spimconfig/configuration.txt");
            config.printProperties();
        }
        catch (ConfigurationParserException e) {
            e.printStackTrace();
            System.exit(0);
        }
        new VisualizeBeads(config);
    }
}

