/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.detection.descriptor;

import fiji.util.KDTree;
import fiji.util.NNearestNeighborSearch;
import fiji.util.node.Leaf;
import java.util.ArrayList;
import mpicbg.models.Point;
import mpicbg.pointdescriptor.LocalCoordinateSystemPointDescriptor;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import mpicbg.spim.registration.detection.DetectionView;
import mpicbg.spim.registration.detection.descriptor.CorrespondenceExtraction;

public class CoordSystem3d<T extends DetectionView<?, T>>
implements CorrespondenceExtraction<T> {
    @Override
    public ArrayList<PointMatchGeneric<T>> extractCorrespondenceCandidates(ArrayList<T> nodeListA, ArrayList<T> nodeListB, double differenceThreshold, double ratioOfDistance, boolean useAssociatedBeads) {
        int numNeighbors = 3;
        KDTree tree1 = new KDTree(nodeListA);
        KDTree tree2 = new KDTree(nodeListB);
        ArrayList<LocalCoordinateSystemPointDescriptor<T>> descriptors1 = CoordSystem3d.createLocalCoordinateSystemPointDescriptors(tree1, nodeListA, 3, false);
        ArrayList<LocalCoordinateSystemPointDescriptor<T>> descriptors2 = CoordSystem3d.createLocalCoordinateSystemPointDescriptors(tree2, nodeListB, 3, false);
        KDTree lookUpTree2 = new KDTree(descriptors2);
        NNearestNeighborSearch nnsearch = new NNearestNeighborSearch(lookUpTree2);
        ArrayList<PointMatchGeneric<T>> correspondences = new ArrayList<PointMatchGeneric<T>>();
        this.computeMatching(descriptors1, nnsearch, correspondences, differenceThreshold, ratioOfDistance);
        return correspondences;
    }

    protected void computeMatching(ArrayList<LocalCoordinateSystemPointDescriptor<T>> descriptors1, NNearestNeighborSearch<LocalCoordinateSystemPointDescriptor<T>> nnsearch2, ArrayList<PointMatchGeneric<T>> correspondences, double differenceThreshold, double ratioOfDistance) {
        for (LocalCoordinateSystemPointDescriptor<T> descriptorA : descriptors1) {
            LocalCoordinateSystemPointDescriptor[] matches = (LocalCoordinateSystemPointDescriptor[])nnsearch2.findNNearestNeighbors(descriptorA, 2);
            double best = descriptorA.descriptorDistance(matches[0]);
            double secondBest = descriptorA.descriptorDistance(matches[1]);
            if (!(best < differenceThreshold) || !(best * ratioOfDistance <= secondBest)) continue;
            DetectionView detectionA = (DetectionView)((Object)descriptorA.getBasisPoint());
            DetectionView detectionB = (DetectionView)((Object)matches[0].getBasisPoint());
            detectionA.addPointDescriptorCorrespondence(detectionB, 1.0);
            detectionB.addPointDescriptorCorrespondence(detectionA, 1.0);
            correspondences.add(new PointMatchGeneric<DetectionView>(detectionA, detectionB, 1.0));
        }
    }

    public static <P extends Point> ArrayList<LocalCoordinateSystemPointDescriptor<P>> createLocalCoordinateSystemPointDescriptors(KDTree<P> tree, ArrayList<P> basisPoints, int numNeighbors, boolean normalize) {
        NNearestNeighborSearch nnsearch = new NNearestNeighborSearch(tree);
        ArrayList<LocalCoordinateSystemPointDescriptor<P>> descriptors = new ArrayList<LocalCoordinateSystemPointDescriptor<P>>();
        for (Point point : basisPoints) {
            ArrayList<Point> neighbors = new ArrayList<Point>();
            Point[] neighborList = (Point[])nnsearch.findNNearestNeighbors((Leaf)point, numNeighbors + 1);
            for (int n = 1; n < neighborList.length; ++n) {
                neighbors.add(neighborList[n]);
            }
            try {
                descriptors.add(new LocalCoordinateSystemPointDescriptor<Point>(point, neighbors, normalize));
            }
            catch (NoSuitablePointsException e) {
                e.printStackTrace();
            }
        }
        return descriptors;
    }
}

