/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.bead.error;

import java.util.ArrayList;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.bead.Bead;
import mpicbg.spim.registration.bead.BeadIdentification;
import mpicbg.spim.registration.bead.error.ViewErrorPairWise;

public class ViewErrorStatistics {
    final ViewDataBeads view;
    final ArrayList<ViewErrorPairWise> connectedViews;

    public ViewErrorStatistics(ViewDataBeads view) {
        this.view = view;
        this.connectedViews = new ArrayList();
        for (ViewDataBeads otherView : view.getViewStructure().getViews()) {
            if (otherView == view) continue;
            this.connectedViews.add(new ViewErrorPairWise(otherView));
        }
    }

    public double getViewSpecificError(ViewDataBeads otherView) {
        boolean foundView = false;
        for (ViewErrorPairWise viewError : this.connectedViews) {
            if (viewError.getView() != otherView) continue;
            return viewError.getAvgError();
        }
        if (!foundView && this.view.getViewStructure().getDebugLevel() <= 2) {
            IOFunctions.println("ViewErrorStatistics.getViewSpecificError(): Warning! " + otherView + " is not part of the structure of my view " + this.view);
        }
        return -1.0;
    }

    public void resetViewSpecificError(ViewDataBeads otherView) {
        boolean foundView = false;
        for (ViewErrorPairWise viewError : this.connectedViews) {
            if (viewError.getView() != otherView) continue;
            viewError.setConnected(false);
            viewError.setAvgError(-1.0);
            foundView = true;
        }
        if (!foundView && this.view.getViewStructure().getDebugLevel() <= 2) {
            IOFunctions.println("ViewErrorStatistics.setViewSpecificError(): Warning! " + otherView + " is not part of the structure of my view " + this.view);
        }
    }

    public void setViewSpecificError(ViewDataBeads otherView, double error) {
        boolean foundView = false;
        for (ViewErrorPairWise viewError : this.connectedViews) {
            if (viewError.getView() != otherView) continue;
            viewError.setConnected(true);
            viewError.setAvgError(error);
            foundView = true;
        }
        if (!foundView && this.view.getViewStructure().getDebugLevel() <= 2) {
            IOFunctions.println("ViewErrorStatistics.setViewSpecificError(): Warning! " + otherView + " is not part of the structure of my view " + this.view);
        }
    }

    public void setViewConnected(ViewDataBeads otherView, boolean newStatus) {
        boolean foundView = false;
        for (ViewErrorPairWise viewError : this.connectedViews) {
            if (viewError.getView() != otherView) continue;
            viewError.setConnected(newStatus);
            foundView = true;
        }
        if (!foundView && this.view.getViewStructure().getDebugLevel() <= 2) {
            IOFunctions.println("ViewErrorStatistics.setViewConnected(): Warning! " + otherView + " is not part of the structure of my view " + this.view);
        }
    }

    public void setViewError(ViewDataBeads otherView, double error) {
        boolean foundView = false;
        for (ViewErrorPairWise viewError : this.connectedViews) {
            if (viewError.getView() != otherView) continue;
            viewError.setAvgError(error);
            foundView = true;
        }
        if (!foundView && this.view.getViewStructure().getDebugLevel() <= 2) {
            IOFunctions.println("ViewErrorStatistics.setViewError(): Warning! " + otherView + " is not part of the structure of my view " + this.view);
        }
    }

    public int getNumTrueCorrespondencePairs(ViewDataBeads otherView) {
        boolean partOfViewStructure = false;
        if (this.view.getViewStructure().getViews().contains(otherView)) {
            partOfViewStructure = true;
        }
        if (!partOfViewStructure && this.view.getViewStructure().getDebugLevel() <= 2) {
            IOFunctions.println("ViewErrorStatistics.getNumTrueCorrespondencePairs(): Warning! " + otherView + " is not part of the structure of my view " + this.view);
        }
        int otherViewID = otherView.getID();
        int numCorrespondences = 0;
        for (Bead bead : this.view.getBeadStructure().getBeadList()) {
            for (BeadIdentification beadIdentification : bead.getRANSACCorrespondence()) {
                if (beadIdentification.getViewID() != otherViewID) continue;
                ++numCorrespondences;
            }
        }
        return numCorrespondences;
    }

    public int getNumCandidatePairs(ViewDataBeads otherView) {
        boolean partOfViewStructure = false;
        if (this.view.getViewStructure().getViews().contains(otherView)) {
            partOfViewStructure = true;
        }
        if (!partOfViewStructure && this.view.getViewStructure().getDebugLevel() <= 2) {
            IOFunctions.println("ViewErrorStatistics.getNumCandidatePaires(): Warning! " + otherView + " is not part of the structure of my view " + this.view);
        }
        int otherViewID = otherView.getID();
        int numCorrespondences = 0;
        for (Bead bead : this.view.getBeadStructure().getBeadList()) {
            for (BeadIdentification beadIdentification : bead.getDescriptorCorrespondence()) {
                if (beadIdentification.getViewID() != otherViewID) continue;
                ++numCorrespondences;
            }
        }
        return numCorrespondences;
    }

    public int getNumDetections() {
        return this.view.getBeadStructure().getBeadList().size();
    }

    public int getNumDetectionsWithCandidates() {
        int numCandidates = 0;
        for (Bead bead : this.view.getBeadStructure().getBeadList()) {
            if (bead.getDescriptorCorrespondence().size() <= 0) continue;
            ++numCandidates;
        }
        return numCandidates;
    }

    public int getNumCandidatePairs() {
        int numCandidates = 0;
        for (Bead bead : this.view.getBeadStructure().getBeadList()) {
            numCandidates += bead.getDescriptorCorrespondence().size();
        }
        return numCandidates;
    }

    public int getNumTrueCorrespondencePairs() {
        int numCorrespondences = 0;
        for (Bead bead : this.view.getBeadStructure().getBeadList()) {
            numCorrespondences += bead.getRANSACCorrespondence().size();
        }
        return numCorrespondences;
    }

    public int getNumDetectionsWithTrueCorrespondences() {
        int numCorrespondences = 0;
        for (Bead bead : this.view.getBeadStructure().getBeadList()) {
            if (bead.getRANSACCorrespondence().size() <= 0) continue;
            ++numCorrespondences;
        }
        return numCorrespondences;
    }

    public double getAverageViewError() {
        double avgError = 0.0;
        int numConnectedViews = 0;
        for (ViewErrorPairWise error : this.connectedViews) {
            if (!error.isConnected()) continue;
            avgError += error.getAvgError();
            ++numConnectedViews;
        }
        if (numConnectedViews <= 0) {
            return -1.0;
        }
        return avgError / (double)numConnectedViews;
    }

    public int getNumConnectedViews() {
        int numConnectedViews = 0;
        for (ViewErrorPairWise error : this.connectedViews) {
            if (!error.isConnected()) continue;
            ++numConnectedViews;
        }
        return numConnectedViews;
    }
}

