/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.io;

import bdv.export.ProgressWriter;
import bdv.export.ProgressWriterConsole;
import ij.IJ;
import ij.ImageJ;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.AffineModel3D;
import mpicbg.models.RigidModel3D;
import mpicbg.models.TranslationModel3D;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.ConfigurationParserGeneral;
import mpicbg.spim.io.ConfigurationParserSPIM;
import mpicbg.spim.io.ProgramConfiguration;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.io.TextFileAccess;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.bead.Bead;
import mpicbg.spim.registration.bead.BeadIdentification;
import mpicbg.spim.registration.segmentation.NucleiConfiguration;
import mpicbg.spim.registration.segmentation.Nucleus;
import mpicbg.spim.registration.segmentation.NucleusIdentification;
import net.imglib2.util.Util;
import spim.fiji.plugin.resave.ProgressWriterIJ;

public class IOFunctions {
    public static boolean printIJLog = true;
    private static ProgressWriterIJ progressWriterIJ = new ProgressWriterIJ();
    private static ProgressWriterConsole progressWriterConsole = new ProgressWriterConsole();

    protected IOFunctions() {
    }

    public static void printlnTS() {
        IOFunctions.printlnTS("");
    }

    public static void printlnTS(Object object) {
        IOFunctions.printlnTS(object.toString());
    }

    public static void printlnTS(String string) {
        IOFunctions.println(new Date(System.currentTimeMillis()) + ": " + string);
    }

    public static void println() {
        IOFunctions.println("");
    }

    public static void println(Object object) {
        IOFunctions.println(object.toString());
    }

    public static void println(String string) {
        if (printIJLog) {
            IJ.log((String)string);
        } else {
            System.out.println(string);
        }
    }

    public static void printErr() {
        IOFunctions.printErr("");
    }

    public static void printErr(Object object) {
        IOFunctions.printErr(object.toString());
    }

    public static void printErr(String string) {
        if (printIJLog) {
            IJ.error((String)string);
        } else {
            System.err.println(string);
        }
    }

    public static ProgressWriter getProgressWriter() {
        if (printIJLog) {
            return progressWriterIJ;
        }
        return progressWriterConsole;
    }

    public static void printlnSafe() {
        IOFunctions.printlnSafe("");
    }

    public static void printlnSafe(Object object) {
        IOFunctions.printlnSafe(object.toString());
    }

    public static void printlnSafe(String string) {
        if (printIJLog) {
            if (SwingUtilities.isEventDispatchThread()) {
                IJ.log((String)string);
            } else {
                SwingUtilities.invokeLater(() -> IJ.log((String)string));
            }
        } else {
            System.out.println(string);
        }
    }

    public static void printErrSafe() {
        IOFunctions.printErr("");
    }

    public static void printErrSafe(Object object) {
        IOFunctions.printErr(object.toString());
    }

    public static void printErrSafe(String string) {
        if (printIJLog) {
            if (SwingUtilities.isEventDispatchThread()) {
                IJ.error((String)string);
            } else {
                SwingUtilities.invokeLater(() -> IJ.error((String)string));
            }
        } else {
            System.err.println(string);
        }
    }

    public static SPIMConfiguration initSPIMProcessing() {
        return IOFunctions.initSPIMProcessing("config/configuration.txt", "spimconfig/configuration.txt");
    }

    public static SPIMConfiguration initSPIMProcessing(String configFile, String spimConfigFile) {
        SPIMConfiguration config = null;
        try {
            config = ConfigurationParserSPIM.parseFile(spimConfigFile);
            if (config.debugLevelInt <= 0) {
                config.printProperties();
            }
        }
        catch (ConfigurationParserException e) {
            IOFunctions.println("Cannot open SPIM configuration file: \n" + e);
            return null;
        }
        if (config.showImageJWindow) {
            ProgramConfiguration conf = null;
            try {
                conf = ConfigurationParserGeneral.parseFile(configFile);
            }
            catch (Exception e) {
                IOFunctions.println("Cannot open configuration file: \n" + e);
            }
            if (conf != null) {
                System.getProperties().setProperty("plugins.dir", conf.pluginsDir);
                String[] params = new String[]{"-ijpath " + conf.pluginsDir};
                ImageJ.main((String[])params);
            } else {
                String[] params = new String[]{"-ijpath ."};
                ImageJ.main((String[])params);
            }
        }
        return config;
    }

    public static String getShortName(String fileName) {
        String shortName = fileName;
        shortName = shortName.replace('\\', '/');
        while (shortName.contains("/")) {
            shortName = shortName.substring(shortName.indexOf("/") + 1, shortName.length());
        }
        return shortName;
    }

    public static boolean writeNuclei(ViewDataBeads view, Collection<Nucleus> nuclei, String directory) {
        String fileName = directory + view.getName() + ".nuclei.txt";
        try {
            PrintWriter out = TextFileAccess.openFileWriteEx(fileName);
            out.println("ID\tViewID\tLx\tLy\tLz\tWx\tWy\tWz\tWeight");
            for (Nucleus nucleus : nuclei) {
                out.print(nucleus.getID() + "\t" + nucleus.getViewID() + "\t");
                out.print(nucleus.getL()[0] + "\t" + nucleus.getL()[1] + "\t" + nucleus.getL()[2] + "\t");
                out.print(nucleus.getW()[0] + "\t" + nucleus.getW()[1] + "\t" + nucleus.getW()[2] + "\t");
                out.print(nucleus.getWeight() + "\t");
                out.println();
            }
            out.close();
            out = TextFileAccess.openFileWriteEx(directory + view.getName() + ".dim");
            out.println("image width: " + view.getImageSize()[0]);
            out.println("image height: " + view.getImageSize()[1]);
            out.println("image depth: " + view.getImageSize()[2]);
            out.close();
        }
        catch (IOException e) {
            IOFunctions.printErr("BeadDetection(): " + e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static ArrayList<Nucleus> readNuclei(ViewDataBeads view, String directory, NucleiConfiguration nConf) {
        int debugLevel = view.getViewStructure().getDebugLevel();
        ArrayList<Nucleus> nuclei = new ArrayList<Nucleus>();
        int countLine = 0;
        try {
            BufferedReader in = TextFileAccess.openFileRead(directory + view.getName() + ".nuclei.txt");
            in.readLine();
            boolean printedOnce = false;
            boolean viewIDupdated = false;
            while (in.ready()) {
                ++countLine;
                String line = in.readLine();
                String[] entries = line.split("\t");
                int beadID = Integer.parseInt(entries[0]);
                int viewID = Integer.parseInt(entries[1]);
                if (view.getID() != viewID && !viewIDupdated) {
                    if (debugLevel <= 2) {
                        IOFunctions.println("ViewID messed up, should be " + viewID + "(file) but is " + view.getID() + "(view). ViewID updated.");
                    }
                    view.setID(viewID);
                    viewIDupdated = true;
                } else if (view.getID() != viewID && viewIDupdated && !printedOnce) {
                    if (debugLevel <= 2) {
                        IOFunctions.println("ViewID messed up, should be " + viewID + "(file) but is " + view.getID() + "(view) and is changing throughout the file. We have to recompute the registration (WILL BE OVERWRITTEN).");
                    }
                    printedOnce = true;
                    nConf.readRegistration = false;
                }
                double[] l = new double[]{Double.parseDouble(entries[2]), Double.parseDouble(entries[3]), Double.parseDouble(entries[4])};
                double[] w = new double[]{Double.parseDouble(entries[5]), Double.parseDouble(entries[6]), Double.parseDouble(entries[7])};
                double weight = Double.parseDouble(entries[8]);
                Nucleus nucleus = new Nucleus(beadID, l, view);
                nucleus.setW(w);
                nucleus.setWeight(weight);
                nuclei.add(nucleus);
            }
            if (debugLevel <= 1) {
                IOFunctions.println("Read " + nuclei.size() + " nuclei for " + view);
            }
            in.close();
        }
        catch (Exception e) {
            if (debugLevel <= 2) {
                IOFunctions.println("IOFunctions.readNuclei(): " + e + " in view " + view.getName() + " of " + view.getViewStructure() + " in line " + countLine);
            }
            return null;
        }
        return nuclei;
    }

    public static boolean writeNucleiCorrespondences(ViewDataBeads view, String directory) {
        ArrayList nuclei = view.getNucleiStructure().getDetectionList();
        String fileName = directory + view.getName() + ".nuclei.corresponding.txt";
        try {
            PrintWriter out = TextFileAccess.openFileWriteEx(fileName);
            out.println("ID\tViewID\tWeight\tDescCorr\tRansacCorr\tICPCorr");
            for (Nucleus nucleus : nuclei) {
                out.print(nucleus.getID() + "\t" + nucleus.getViewID() + "\t");
                out.print(nucleus.getWeight() + "\t");
                for (NucleusIdentification descNucleus : nucleus.getDescriptorCorrespondence()) {
                    out.print(descNucleus.getNucleusID() + ":" + descNucleus.getViewID() + ";");
                }
                if (nucleus.getDescriptorCorrespondence().size() == 0) {
                    out.print("0\t");
                } else {
                    out.print("\t");
                }
                for (NucleusIdentification ransacNucleus : nucleus.getRANSACCorrespondence()) {
                    out.print(ransacNucleus.getNucleusID() + ":" + ransacNucleus.getViewID() + ";");
                }
                if (nucleus.getRANSACCorrespondence().size() == 0) {
                    out.print("0\t");
                } else {
                    out.print("\t");
                }
                for (NucleusIdentification icpNucleus : nucleus.getICPCorrespondence()) {
                    out.print(icpNucleus.getNucleusID() + ":" + icpNucleus.getViewID() + ";");
                }
                if (nucleus.getICPCorrespondence().size() == 0) {
                    out.print("0");
                }
                out.println();
            }
            out.close();
        }
        catch (IOException e) {
            IOFunctions.printErr("IOFunctions.writeNucleiCorrespondences(): " + e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean readNucleiCorrespondences(ViewDataBeads view, String directory) {
        return IOFunctions.readNucleiCorrespondences(view, directory, true);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean readNucleiCorrespondences(ViewDataBeads view, String directory, boolean removePreviousEntries) {
        int debugLevel = view.getViewStructure().getDebugLevel();
        if (removePreviousEntries) {
            for (Nucleus nucleus : view.getNucleiStructure().getNucleiList()) {
                nucleus.getDescriptorCorrespondence().clear();
                nucleus.getRANSACCorrespondence().clear();
                nucleus.getICPCorrespondence().clear();
            }
        }
        HashMap<Integer, Nucleus> lookupTable = new HashMap<Integer, Nucleus>();
        for (Nucleus nucleus : view.getNucleiStructure().getNucleiList()) {
            lookupTable.put((int)nucleus.getID(), nucleus);
        }
        int n = 0;
        try {
            BufferedReader in = TextFileAccess.openFileRead(directory + view.getName() + ".nuclei.corresponding.txt");
            in.readLine();
            boolean printedOnce = false;
            while (in.ready()) {
                String[] corr;
                String icpCorrespondences;
                String[] corr2;
                String ransacCorrespondences;
                String[] corr3;
                void var5_8;
                ++var5_8;
                String line = in.readLine();
                String[] entries = line.split("\t");
                int nucleusID = Integer.parseInt(entries[0]);
                int viewID = Integer.parseInt(entries[1]);
                if (view.getID() != viewID && !printedOnce) {
                    if (debugLevel <= 2) {
                        IOFunctions.println("ViewID messed up, should be " + viewID + "(file) but is " + view.getID() + "(view). We have to recompute the registration (WILL BE OVERWRITTEN).");
                    }
                    for (Nucleus nucleus : view.getNucleiStructure().getNucleiList()) {
                        nucleus.getDescriptorCorrespondence().clear();
                        nucleus.getRANSACCorrespondence().clear();
                        nucleus.getICPCorrespondence().clear();
                    }
                    return false;
                }
                Nucleus nucleus = (Nucleus)((Object)lookupTable.get(nucleusID));
                if (nucleus == null) {
                    if (debugLevel <= 2) {
                        IOFunctions.printErr("Cannot find nucleus " + nucleusID + ". We have to recompute the registration (WILL BE OVERWRITTEN).");
                    }
                    for (Nucleus n2 : view.getNucleiStructure().getNucleiList()) {
                        n2.getDescriptorCorrespondence().clear();
                        n2.getRANSACCorrespondence().clear();
                        n2.getICPCorrespondence().clear();
                    }
                    return false;
                }
                double weight = Double.parseDouble(entries[2]);
                nucleus.setWeight(weight);
                String descCorrespondences = entries[3].trim();
                if (descCorrespondences.length() > 2 && (corr3 = descCorrespondences.split(";")).length > 0) {
                    for (String entry : corr3) {
                        int corrNucleusID = Integer.parseInt(entry.substring(0, entry.indexOf(58)));
                        int corrViewID = Integer.parseInt(entry.substring(entry.indexOf(58) + 1, entry.length()));
                        ViewDataBeads correspondingView = view.getViewStructure().getViewFromID(corrViewID);
                        if (correspondingView == null) continue;
                        try {
                            nucleus.getDescriptorCorrespondence().add(new NucleusIdentification(corrNucleusID, correspondingView));
                        }
                        catch (Exception e) {
                            if (debugLevel <= 2) {
                                IOFunctions.printErr("Could not add descriptor correspondence " + nucleusID + ": " + e);
                            }
                            for (Nucleus n3 : view.getNucleiStructure().getNucleiList()) {
                                n3.getDescriptorCorrespondence().clear();
                                n3.getRANSACCorrespondence().clear();
                                n3.getICPCorrespondence().clear();
                            }
                            return false;
                        }
                    }
                }
                if ((ransacCorrespondences = entries[4].trim()).length() > 2 && (corr2 = ransacCorrespondences.split(";")).length > 0) {
                    for (String entry : corr2) {
                        int corrNucleusID = Integer.parseInt(entry.substring(0, entry.indexOf(58)));
                        int corrViewID = Integer.parseInt(entry.substring(entry.indexOf(58) + 1, entry.length()));
                        ViewDataBeads correspondingView = view.getViewStructure().getViewFromID(corrViewID);
                        if (correspondingView == null) continue;
                        try {
                            nucleus.getRANSACCorrespondence().add(new NucleusIdentification(corrNucleusID, correspondingView));
                        }
                        catch (Exception e) {
                            if (debugLevel <= 2) {
                                IOFunctions.printErr("Could not add ransac correspondence " + nucleusID + ": " + e);
                            }
                            for (Nucleus n4 : view.getNucleiStructure().getNucleiList()) {
                                n4.getDescriptorCorrespondence().clear();
                                n4.getRANSACCorrespondence().clear();
                                n4.getICPCorrespondence().clear();
                            }
                            return false;
                        }
                    }
                }
                if (entries.length <= 5 || (icpCorrespondences = entries[5].trim()).length() <= 2 || (corr = icpCorrespondences.split(";")).length <= 0) continue;
                for (String entry : corr) {
                    int corrNucleusID = Integer.parseInt(entry.substring(0, entry.indexOf(58)));
                    int corrViewID = Integer.parseInt(entry.substring(entry.indexOf(58) + 1, entry.length()));
                    ViewDataBeads correspondingView = view.getViewStructure().getViewFromID(corrViewID);
                    if (correspondingView == null) continue;
                    try {
                        nucleus.getICPCorrespondence().add(new NucleusIdentification(corrNucleusID, correspondingView));
                    }
                    catch (Exception e) {
                        if (debugLevel <= 2) {
                            IOFunctions.printErr("Could not add ICP correspondence " + nucleusID + ": " + e);
                        }
                        for (Nucleus n5 : view.getNucleiStructure().getNucleiList()) {
                            n5.getDescriptorCorrespondence().clear();
                            n5.getRANSACCorrespondence().clear();
                            n5.getICPCorrespondence().clear();
                        }
                        return false;
                    }
                }
            }
            int numDescriptorCorrespondences = 0;
            int numRANSACCorrespondences = 0;
            int numICPCorrespondences = 0;
            for (Nucleus nucleus : view.getNucleiStructure().getNucleiList()) {
                numDescriptorCorrespondences += nucleus.getDescriptorCorrespondence().size();
                numRANSACCorrespondences += nucleus.getRANSACCorrespondence().size();
                numICPCorrespondences += nucleus.getICPCorrespondence().size();
            }
            if (debugLevel <= 1) {
                IOFunctions.println("View " + view.getName() + " " + numRANSACCorrespondences + " RANSAC of " + numDescriptorCorrespondences + " DescriptorCorrespences, " + numICPCorrespondences + " ICP correspondences.");
            }
            in.close();
        }
        catch (Exception e) {
            if (debugLevel <= 2) {
                IOFunctions.println("IOFunctions.readNucleiCorrespondences(): " + e + " in view " + view.getName() + " of " + view.getViewStructure() + " in line " + n);
            }
            e.printStackTrace();
            for (Nucleus n6 : view.getNucleiStructure().getNucleiList()) {
                n6.getDescriptorCorrespondence().clear();
                n6.getRANSACCorrespondence().clear();
                n6.getICPCorrespondence().clear();
            }
            return false;
        }
        return true;
    }

    public static boolean writeSegmentation(ViewDataBeads view, String directory) {
        return IOFunctions.writeSegmentation(view.getBeadStructure().getBeadList(), view.getImageSize(), view.getName(), view.getID(), directory);
    }

    public static boolean writeSegmentation(ArrayList<Bead> beads, int[] imgSize, String viewName, int viewID, String directory) {
        String fileName = directory + viewName + ".beads.txt";
        try {
            PrintWriter out = TextFileAccess.openFileWriteEx(fileName);
            out.println("ID\tViewID\tLx\tLy\tLz\tWx\tWy\tWz\tWeight\tDescCorr\tRansacCorr");
            for (Bead bead : beads) {
                out.print(bead.getID() + "\t" + viewID + "\t");
                out.print(bead.getL()[0] + "\t" + bead.getL()[1] + "\t" + bead.getL()[2] + "\t");
                out.print(bead.getW()[0] + "\t" + bead.getW()[1] + "\t" + bead.getW()[2] + "\t");
                out.print(bead.getWeight() + "\t");
                for (BeadIdentification descBead : bead.getDescriptorCorrespondence()) {
                    out.print(descBead.getBeadID() + ":" + descBead.getViewID() + ";");
                }
                if (bead.getDescriptorCorrespondence().size() == 0) {
                    out.print("0\t");
                } else {
                    out.print("\t");
                }
                for (BeadIdentification ransacBead : bead.getRANSACCorrespondence()) {
                    out.print(ransacBead.getBeadID() + ":" + ransacBead.getViewID() + ";");
                }
                if (bead.getRANSACCorrespondence().size() == 0) {
                    out.print("0");
                }
                out.println();
            }
            out.close();
            if (imgSize != null) {
                out = TextFileAccess.openFileWriteEx(directory + viewName + ".dim");
                out.println("image width: " + imgSize[0]);
                out.println("image height: " + imgSize[1]);
                out.println("image depth: " + imgSize[2]);
                out.close();
            }
        }
        catch (IOException e) {
            IOFunctions.printErr("BeadDetection(): " + e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean readSegmentation(ViewDataBeads view, String directory, SPIMConfiguration conf) {
        boolean readSeg = true;
        int debugLevel = view.getViewStructure().getDebugLevel();
        int countLine = 0;
        try {
            BufferedReader in = TextFileAccess.openFileRead(directory + view.getName() + ".beads.txt");
            in.readLine();
            view.getBeadStructure().getBeadList().clear();
            boolean printedOnce = false;
            boolean viewIDupdated = false;
            while (in.ready()) {
                String ransacCorrespondences;
                int corrViewID;
                int corrBeadID;
                String[] corr;
                String descCorrespondences;
                ++countLine;
                String line = in.readLine();
                String[] entries = line.split("\t");
                int beadID = Integer.parseInt(entries[0]);
                int viewID = Integer.parseInt(entries[1]);
                if (view.getID() != viewID && !viewIDupdated) {
                    if (debugLevel <= 2) {
                        IOFunctions.println("ViewID messed up, should be " + viewID + "(file) but is " + view.getID() + "(view). ViewID updated.");
                    }
                    view.setID(viewID);
                    viewIDupdated = true;
                } else if (view.getID() != viewID && viewIDupdated && !printedOnce) {
                    if (debugLevel <= 2) {
                        IOFunctions.println("ViewID messed up, should be " + viewID + "(file) but is " + view.getID() + "(view) and is changing throughout the file. We have to recompute the registration (WILL BE OVERWRITTEN).");
                    }
                    if (conf != null) {
                        conf.readRegistration = false;
                        conf.writeRegistration = true;
                    }
                    printedOnce = true;
                }
                double[] l = new double[]{Double.parseDouble(entries[2]), Double.parseDouble(entries[3]), Double.parseDouble(entries[4])};
                double[] w = new double[]{Double.parseDouble(entries[5]), Double.parseDouble(entries[6]), Double.parseDouble(entries[7])};
                double weight = Double.parseDouble(entries[8]);
                Bead bead = new Bead(beadID, l, view);
                bead.setW(w);
                bead.setWeight(weight);
                if (entries.length >= 10 && (descCorrespondences = entries[9].trim()).length() > 2 && (corr = descCorrespondences.split(";")).length > 0) {
                    for (String entry : corr) {
                        corrBeadID = Integer.parseInt(entry.substring(0, entry.indexOf(58)));
                        corrViewID = Integer.parseInt(entry.substring(entry.indexOf(58) + 1, entry.length()));
                        try {
                            bead.getDescriptorCorrespondence().add(new BeadIdentification(corrBeadID, view.getViewStructure().getViewFromID(corrViewID)));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (entries.length >= 11 && (ransacCorrespondences = entries[10].trim()).length() > 2 && (corr = ransacCorrespondences.split(";")).length > 0) {
                    for (String entry : corr) {
                        corrBeadID = Integer.parseInt(entry.substring(0, entry.indexOf(58)));
                        corrViewID = Integer.parseInt(entry.substring(entry.indexOf(58) + 1, entry.length()));
                        try {
                            bead.getRANSACCorrespondence().add(new BeadIdentification(corrBeadID, view.getViewStructure().getViewFromID(corrViewID)));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                view.getBeadStructure().addDetection(bead);
            }
            if (debugLevel <= 1) {
                IOFunctions.println("Read " + view.getBeadStructure().getBeadList().size() + " beads for " + view);
            }
            in.close();
        }
        catch (Exception e) {
            if (debugLevel <= 2) {
                IOFunctions.println("IOFunctions.readSegmentation(): " + e + " in view " + view.getName() + " of " + view.getViewStructure() + " in line " + countLine);
            }
            readSeg = false;
            view.getBeadStructure().getBeadList().clear();
        }
        return readSeg;
    }

    public static boolean writeDim(ViewDataBeads view, String directory) {
        try {
            PrintWriter out = TextFileAccess.openFileWriteEx(directory + view.getName() + ".dim");
            out.println("image width: " + view.getImageSize()[0]);
            out.println("image height: " + view.getImageSize()[1]);
            out.println("image depth: " + view.getImageSize()[2]);
            out.close();
        }
        catch (IOException e) {
            IOFunctions.printErr("Cannot write dim file for " + view + ": " + e);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean readDim(ViewDataBeads view, String directory) {
        boolean readDim = true;
        try {
            int j;
            BufferedReader in = TextFileAccess.openFileRead(directory + view.getName() + ".dim");
            int[] imageSize = new int[3];
            for (j = 0; j < imageSize.length; ++j) {
                imageSize[j] = -1;
            }
            while (in.ready()) {
                String entry = in.readLine().trim();
                if (entry.startsWith("image width:")) {
                    imageSize[0] = Integer.parseInt(entry.substring(13, entry.length()).trim());
                    continue;
                }
                if (entry.startsWith("image height:")) {
                    imageSize[1] = Integer.parseInt(entry.substring(13, entry.length()).trim());
                    continue;
                }
                if (!entry.startsWith("image depth:")) continue;
                imageSize[2] = Integer.parseInt(entry.substring(13, entry.length()).trim());
            }
            in.close();
            for (j = 0; j < imageSize.length; ++j) {
                if (imageSize[j] != -1) continue;
                view.setImageSize(null);
                return false;
            }
            view.setImageSize(imageSize);
        }
        catch (Exception e) {
            IOFunctions.printErr("BeadDetection(): " + e);
            readDim = false;
            view.setImageSize(null);
        }
        return readDim;
    }

    public static boolean writeRegistration(ViewDataBeads view, String directory) {
        return IOFunctions.writeRegistration(view, directory, "");
    }

    public static boolean writeRegistration(ViewDataBeads view, String directory, String extension) {
        String fileName = directory + view.getName() + ".registration" + extension;
        if (view.getTile().getModel() != null) {
            try {
                PrintWriter out = TextFileAccess.openFileWrite(fileName);
                AbstractAffineModel3D model = (AbstractAffineModel3D)view.getTile().getModel();
                double[] m = model.getMatrix(null);
                out.println("m00: " + m[0]);
                out.println("m01: " + m[1]);
                out.println("m02: " + m[2]);
                out.println("m03: " + m[3]);
                out.println("m10: " + m[4]);
                out.println("m11: " + m[5]);
                out.println("m12: " + m[6]);
                out.println("m13: " + m[7]);
                out.println("m20: " + m[8]);
                out.println("m21: " + m[9]);
                out.println("m22: " + m[10]);
                out.println("m23: " + m[11]);
                out.println("m30: 0");
                out.println("m31: 0");
                out.println("m32: 0");
                out.println("m33: 1");
                out.println("model: " + model.getClass().getSimpleName());
                out.println("");
                out.println("minError: " + view.getViewStructure().getGlobalErrorStatistics().getMinAlignmentError());
                out.println("avgError: " + view.getViewStructure().getGlobalErrorStatistics().getAverageAlignmentError());
                out.println("maxError: " + view.getViewStructure().getGlobalErrorStatistics().getMaxAlignmentError());
                out.println("");
                out.println("z-scaling: " + view.getZStretching());
                out.println("Angle Specific Average Error: " + view.getViewErrorStatistics().getAverageViewError());
                out.println("Overlapping Views: " + view.getViewErrorStatistics().getNumConnectedViews());
                out.println("Num beads having true correspondences: " + view.getViewErrorStatistics().getNumDetectionsWithTrueCorrespondences());
                out.println("Sum of true correspondences pairs: " + view.getViewErrorStatistics().getNumTrueCorrespondencePairs());
                out.println("Num beads having correspondences candidates: " + view.getViewErrorStatistics().getNumDetectionsWithCandidates());
                out.println("Sum of correspondences candidates pairs: " + view.getViewErrorStatistics().getNumCandidatePairs());
                for (ViewDataBeads otherView : view.getViewStructure().getViews()) {
                    if (otherView == view) continue;
                    out.println("");
                    out.println(otherView.getName() + " - Average Error: " + view.getViewErrorStatistics().getViewSpecificError(otherView));
                    out.println(otherView.getName() + " - Bead Correspondences: " + view.getViewErrorStatistics().getNumCandidatePairs(otherView));
                    out.println(otherView.getName() + " - Ransac Correspondences: " + view.getViewErrorStatistics().getNumTrueCorrespondencePairs(otherView));
                }
                out.close();
            }
            catch (Exception e) {
                IOFunctions.printErr("Cannot write registration file: " + fileName + " because: " + e);
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static boolean readRegistration(ViewDataBeads view, String fileName) {
        AbstractAffineModel3D model = (AbstractAffineModel3D)view.getTile().getModel();
        double[] m = model.getMatrix(null);
        String savedModel = "AffineModel3D";
        boolean readReg = true;
        BufferedReader in = TextFileAccess.openFileRead(fileName);
        try {
            while (in.ready()) {
                String entry = in.readLine().trim();
                if (entry.startsWith("m00:")) {
                    m[0] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m01:")) {
                    m[1] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m02:")) {
                    m[2] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m03:")) {
                    m[3] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m10:")) {
                    m[4] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m11:")) {
                    m[5] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m12:")) {
                    m[6] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m13:")) {
                    m[7] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m20:")) {
                    m[8] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m21:")) {
                    m[9] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m22:")) {
                    m[10] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m23:")) {
                    m[11] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("model:")) {
                    savedModel = entry.substring(7, entry.length()).trim();
                    continue;
                }
                if (entry.startsWith("minError:")) {
                    view.getViewStructure().getGlobalErrorStatistics().setMinAlignmentError(Double.parseDouble(entry.substring(10, entry.length())));
                    continue;
                }
                if (entry.startsWith("maxError:")) {
                    view.getViewStructure().getGlobalErrorStatistics().setMaxAlignmentError(Double.parseDouble(entry.substring(10, entry.length())));
                    continue;
                }
                if (entry.startsWith("avgError:")) {
                    view.getViewStructure().getGlobalErrorStatistics().setAverageAlignmentError(Double.parseDouble(entry.substring(10, entry.length())));
                    continue;
                }
                for (ViewDataBeads otherView : view.getViewStructure().getViews()) {
                    if (!entry.startsWith(otherView.getName() + " - Average Error:")) continue;
                    view.getViewErrorStatistics().setViewSpecificError(otherView, Double.parseDouble(entry.substring(17 + otherView.getName().length(), entry.length())));
                }
            }
            in.close();
            if (model instanceof AffineModel3D) {
                if (!savedModel.equals("AffineModel3D") && view.getViewStructure().getDebugLevel() <= 2) {
                    IOFunctions.println("Warning: Loading a '" + savedModel + "' as AffineModel3D!");
                }
                ((AffineModel3D)model).set(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11]);
            } else if (model instanceof RigidModel3D) {
                if (!savedModel.equals("RigidModel3D") && view.getViewStructure().getDebugLevel() <= 2) {
                    IOFunctions.println("Warning: Loading a '" + savedModel + "' as RigidModel3D!");
                }
                ((RigidModel3D)model).set(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11]);
            } else if (model instanceof TranslationModel3D) {
                if (!savedModel.equals("TranslationModel3D") && view.getViewStructure().getDebugLevel() <= 2) {
                    IOFunctions.println("Warning: Loading a '" + savedModel + "' as TranslationModel3D!");
                }
                ((TranslationModel3D)model).set(m[3], m[7], m[11]);
            } else {
                throw new Exception("Unknown transformation model for import: " + model.getClass().getCanonicalName());
            }
            if (view.getViewStructure().getDebugLevel() <= 0) {
                IOFunctions.println("Transformation for (" + view.getName() + "):\n" + model);
            }
        }
        catch (Exception e) {
            IOFunctions.printErr("Cannot read registration file: " + fileName + e);
            readReg = false;
        }
        return readReg;
    }

    public static void reWriteRegistrationFile(File file, AffineModel3D newModel, AffineModel3D oldModel, AffineModel3D preConcatenated) {
        try {
            ArrayList<String> content = new ArrayList<String>();
            BufferedReader in = TextFileAccess.openFileRead(file);
            while (in.ready()) {
                content.add(in.readLine().trim());
            }
            in.close();
            PrintWriter out = TextFileAccess.openFileWrite(file);
            double[] matrixNew = newModel.getMatrix(null);
            for (String entry : content) {
                if (entry.startsWith("m00:")) {
                    out.println("m00: " + matrixNew[0]);
                    continue;
                }
                if (entry.startsWith("m01:")) {
                    out.println("m01: " + matrixNew[1]);
                    continue;
                }
                if (entry.startsWith("m02:")) {
                    out.println("m02: " + matrixNew[2]);
                    continue;
                }
                if (entry.startsWith("m03:")) {
                    out.println("m03: " + matrixNew[3]);
                    continue;
                }
                if (entry.startsWith("m10:")) {
                    out.println("m10: " + matrixNew[4]);
                    continue;
                }
                if (entry.startsWith("m11:")) {
                    out.println("m11: " + matrixNew[5]);
                    continue;
                }
                if (entry.startsWith("m12:")) {
                    out.println("m12: " + matrixNew[6]);
                    continue;
                }
                if (entry.startsWith("m13:")) {
                    out.println("m13: " + matrixNew[7]);
                    continue;
                }
                if (entry.startsWith("m20:")) {
                    out.println("m20: " + matrixNew[8]);
                    continue;
                }
                if (entry.startsWith("m21:")) {
                    out.println("m21: " + matrixNew[9]);
                    continue;
                }
                if (entry.startsWith("m22:")) {
                    out.println("m22: " + matrixNew[10]);
                    continue;
                }
                if (entry.startsWith("m23:")) {
                    out.println("m23: " + matrixNew[11]);
                    continue;
                }
                if (entry.startsWith("model:")) {
                    out.println("model: AffineModel3D");
                    continue;
                }
                out.println(entry);
            }
            double[] matrixOld = oldModel.getMatrix(null);
            double[] matrixConcat = preConcatenated.getMatrix(null);
            out.println();
            out.println("Previous model: " + Util.printCoordinates((double[])matrixOld));
            out.println("Pre-concatenated model: " + Util.printCoordinates((double[])matrixConcat));
            out.close();
        }
        catch (IOException e) {
            IJ.log((String)("Cannot find file: " + file.getAbsolutePath() + ": " + e));
            e.printStackTrace();
            return;
        }
    }

    public static AffineModel3D getModelFromFile(File file) {
        AffineModel3D model = new AffineModel3D();
        try {
            BufferedReader in = TextFileAccess.openFileRead(file);
            double[] m = new double[12];
            String savedModel = "AffineModel3D";
            while (in.ready()) {
                String entry = in.readLine().trim();
                if (entry.startsWith("m00:")) {
                    m[0] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m01:")) {
                    m[1] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m02:")) {
                    m[2] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m03:")) {
                    m[3] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m10:")) {
                    m[4] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m11:")) {
                    m[5] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m12:")) {
                    m[6] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m13:")) {
                    m[7] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m20:")) {
                    m[8] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m21:")) {
                    m[9] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m22:")) {
                    m[10] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (entry.startsWith("m23:")) {
                    m[11] = Double.parseDouble(entry.substring(5, entry.length()));
                    continue;
                }
                if (!entry.startsWith("model:")) continue;
                savedModel = entry.substring(7, entry.length()).trim();
            }
            in.close();
            if (!savedModel.equals("AffineModel3D")) {
                IOFunctions.println("Warning: Loading a '" + savedModel + "' as AffineModel3D!");
            }
            model.set(m[0], m[1], m[2], m[3], m[4], m[5], m[6], m[7], m[8], m[9], m[10], m[11]);
        }
        catch (IOException e) {
            IJ.log((String)("Cannot find file: " + file.getAbsolutePath() + ": " + e));
            e.printStackTrace();
            return null;
        }
        return model;
    }
}

