/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.timelapsedisplay;

import fiji.plugin.timelapsedisplay.MouseListenerTimelapse;
import fiji.plugin.timelapsedisplay.RegistrationStatistics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.io.LOCI;
import org.jfree.chart.ChartPanel;

public class FileOpenMenuEntry
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    final ArrayList<RegistrationStatistics> data;
    ChartPanel chartPanel;

    public FileOpenMenuEntry(String title, ArrayList<RegistrationStatistics> data) {
        super(title);
        this.data = data;
    }

    public void setChartPanel(ChartPanel chartPanel) {
        this.chartPanel = chartPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.chartPanel != null) {
            try {
                JMenuItem item = (JMenuItem)e.getSource();
                JPopupMenu m = (JPopupMenu)item.getParent();
                Point p = this.chartPanel.getLocationOnScreen();
                String output = m.toString();
                String x = output.substring(output.indexOf("desiredLocationX"));
                String y = output.substring(output.indexOf("desiredLocationY"));
                System.out.println("chart: " + p);
                System.out.println("popup: " + x + ", " + y);
                p.x = Integer.parseInt(x.substring(x.indexOf("=") + 1, x.indexOf(","))) - p.x;
                p.y = Integer.parseInt(y.substring(y.indexOf("=") + 1, y.indexOf(","))) - p.y;
                int tp = MouseListenerTimelapse.getChartXLocation(p, this.chartPanel);
                for (RegistrationStatistics stat : this.data) {
                    if (stat.timePoint != tp) continue;
                    Image image = LOCI.openLOCIFloatType((String)stat.worstView.getAbsolutePath(), (ContainerFactory)new ArrayContainerFactory());
                    ImageJFunctions.show((Image)image);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

